/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.model;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.component.model.ComponentInstPath;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationI18N;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodePath;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.security.authorization.NodeAccessControl;
import org.silverpeas.kernel.exception.NotFoundException;

public class PublicationPath
extends NodePath {
    private static final long serialVersionUID = -7426600130592037668L;
    private final PublicationDetail publication;
    private final Location folder;

    public static PublicationPath getBestPathForUser(ContributionIdentifier pubId, String userId) {
        PublicationDetail pub = PublicationPath.getPublication(pubId);
        Location folder = OrganizationController.get().getComponentInstance(pub.getInstanceId()).filter(SilverpeasComponentInstance::isTopicTracker).map(i -> {
            PublicationPK pk = new PublicationPK(pubId.getLocalId(), pubId.toReference());
            Map indexedLocations = PublicationService.get().getAllLocations(pk).stream().filter(l -> l.getComponentInstanceId().equals(pubId.getComponentInstanceId())).sorted(Comparator.comparing(WAPrimaryKey::getId)).collect(Collectors.toMap(l -> new NodePK(l.getId(), l.getInstanceId()), l -> l, (l, o) -> l, LinkedHashMap::new));
            return NodeAccessControl.get().filterAuthorizedByUser(indexedLocations.keySet(), userId).map(indexedLocations::get).findFirst().map(l -> {
                pub.setAuthorizedLocation((Location)l);
                return l;
            }).orElseGet(() -> new Location("-1", pubId.getComponentInstanceId()));
        }).orElseGet(() -> new Location("0", pubId.getComponentInstanceId()));
        return new PublicationPath(pub, folder);
    }

    public static PublicationPath getBestPathForGroup(ContributionIdentifier pubId, String groupId) {
        PublicationDetail pub = PublicationPath.getPublication(pubId);
        PublicationPK pk = new PublicationPK(pubId.getLocalId(), pubId.toReference());
        NodeAccessControl nodeAccessControl = NodeAccessControl.get();
        Location folder = OrganizationController.get().getComponentInstance(pub.getInstanceId()).filter(SilverpeasComponentInstance::isTopicTracker).map(i -> PublicationService.get().getAllLocations(pk).stream().filter(l -> l.getComponentInstanceId().equals(pubId.getComponentInstanceId())).filter(l -> nodeAccessControl.isGroupAuthorized(groupId, new NodePK(l.getId(), l.getInstanceId()))).findFirst().map(l -> {
            pub.setAuthorizedLocation((Location)l);
            return l;
        }).orElseGet(() -> new Location("-1", pubId.getComponentInstanceId()))).orElseGet(() -> new Location("0", pubId.getComponentInstanceId()));
        return new PublicationPath(pub, folder);
    }

    public static PublicationPath getPath(ContributionIdentifier pubId) {
        PublicationDetail pub = PublicationPath.getPublication(pubId);
        return PublicationPath.getPath(pub);
    }

    public static PublicationPath getPath(PublicationDetail pub) {
        PublicationPK pk = pub.getPK();
        Location folder = OrganizationController.get().getComponentInstance(pub.getInstanceId()).filter(SilverpeasComponentInstance::isTopicTracker).map(i -> PublicationService.get().getMainLocation(pk).orElseGet(() -> new Location("-1", pub.getInstanceId()))).orElseGet(() -> new Location("0", pub.getInstanceId()));
        return new PublicationPath(pub, folder);
    }

    private static PublicationDetail getPublication(ContributionIdentifier pubId) {
        PublicationPK pk = new PublicationPK(pubId.getLocalId(), pubId.getComponentInstanceId());
        PublicationDetail pub = PublicationService.get().getDetail(pk);
        if (pub == null) {
            throw new NotFoundException("No such publication " + pubId.asString());
        }
        return pub;
    }

    private PublicationPath(PublicationDetail pub, Location folder) {
        this.publication = pub;
        this.folder = folder;
        if (!this.folder.isUndefined() && !this.folder.isRoot()) {
            this.addAll(NodeService.get().getPath(this.folder));
        }
    }

    public PublicationDetail getContribution() {
        return this.publication;
    }

    public Location getLocation() {
        return this.folder;
    }

    @Override
    protected boolean isRoot(NodeDetail node) {
        return this.folder.isRoot() || super.isRoot(node);
    }

    @Override
    public String format(String language, boolean fullSpacePath, String pathSep) {
        String pathPrefix;
        if (this.isEmpty()) {
            ComponentInstPath path = ComponentInstPath.getPath(this.folder.getComponentInstanceId());
            pathPrefix = path.format(language, fullSpacePath, pathSep);
        } else {
            pathPrefix = super.format(language, fullSpacePath, pathSep);
        }
        return pathPrefix + pathSep + ((PublicationI18N)this.publication.getTranslation(language)).getName();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicationPath that = (PublicationPath)o;
        return Objects.equals(this.publication, that.publication) && Objects.equals(this.folder, that.folder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.publication, this.folder);
    }
}

