/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.model;

import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.Date;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.DefaultContributionModel;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.util.StringUtil;

public class PublicationDetailModel
extends DefaultContributionModel<PublicationDetail> {
    PublicationDetailModel(PublicationDetail contribution) {
        super((Contribution)contribution);
    }

    public <T> T getProperty(String property, Object ... parameters) {
        if ("DELAYED_VISIBILITY_AT".equals(property)) {
            return (T)this.getDelayedVisibilityTemporalIfAny();
        }
        return (T)super.getProperty(property, parameters);
    }

    private Temporal getDelayedVisibilityTemporalIfAny() {
        Date beginVisibilityDay;
        PublicationDetail contribution = (PublicationDetail)this.getContribution();
        if (contribution.isValid() && !contribution.isClone() && !contribution.haveGotClone() && (beginVisibilityDay = contribution.getBeginDate()) != null) {
            Date beginVisibilityMoment;
            String beginVisibilityHour = contribution.getBeginHour();
            Date date = beginVisibilityMoment = StringUtil.isDefined((String)beginVisibilityHour) ? DateUtil.getDate((Date)beginVisibilityDay, (String)beginVisibilityHour) : beginVisibilityDay;
            if (beginVisibilityMoment.after(DateUtil.getNow())) {
                return OffsetDateTime.ofInstant(beginVisibilityMoment.toInstant(), ZoneId.systemDefault());
            }
        }
        return null;
    }
}

