/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.model.ValidationStep;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;

public class ValidationStepsDAO {
    private static String publicationValidationTableName = "SB_Publication_Validation";

    private ValidationStepsDAO() {
    }

    public static void deleteComponentInstanceData(String componentInstanceId) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)publicationValidationTableName).where("instanceId = ?", new Object[]{componentInstanceId}).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStep(Connection con, ValidationStep step) throws SQLException {
        StringBuilder insertStatement = new StringBuilder(128);
        insertStatement.append("insert into ").append(publicationValidationTableName).append(" values (?, ?, ?, ?, ?, ?)");
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(insertStatement.toString());
            int id = DBUtil.getNextId((String)publicationValidationTableName, (String)"id");
            prepStmt.setInt(1, id);
            prepStmt.setInt(2, Integer.parseInt(step.getPubPK().getId()));
            prepStmt.setString(3, step.getPubPK().getInstanceId());
            prepStmt.setInt(4, Integer.parseInt(step.getUserId()));
            prepStmt.setString(5, Long.toString(new Date().getTime()));
            prepStmt.setString(6, step.getDecision());
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSteps(Connection con, PublicationPK pubPK) throws SQLException {
        StringBuilder statement = new StringBuilder(128);
        statement.append("delete from ").append(publicationValidationTableName).append(" where pubId = ? and instanceId = ?");
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(statement.toString());
            prepStmt.setInt(1, Integer.parseInt(pubPK.getId()));
            prepStmt.setString(2, pubPK.getInstanceId());
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ValidationStep> getSteps(Connection con, PublicationPK pubPK) throws SQLException {
        ArrayList<ValidationStep> steps = new ArrayList<ValidationStep>();
        StringBuilder statement = new StringBuilder(128);
        statement.append("select * from ").append(publicationValidationTableName).append(" where pubId = ? and instanceId = ? order by decisionDate desc");
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(statement.toString());
            prepStmt.setInt(1, Integer.parseInt(pubPK.getId()));
            prepStmt.setString(2, pubPK.getInstanceId());
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                ValidationStep step = new ValidationStep();
                step.setId(rs.getInt(1));
                step.setPubPK(pubPK);
                step.setUserId(String.valueOf(rs.getInt(4)));
                step.setValidationDate(new Date(Long.parseLong(rs.getString(5))));
                step.setDecision(rs.getString(6));
                steps.add(step);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs);
            DBUtil.close((Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs);
        DBUtil.close((Statement)prepStmt);
        return steps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidationStep getStepByUser(Connection con, PublicationPK pubPK, String userId) throws SQLException {
        ResultSet rs;
        PreparedStatement prepStmt;
        block2: {
            ValidationStep validationStep;
            StringBuilder statement = new StringBuilder(128);
            statement.append("select * from ").append(publicationValidationTableName).append(" where pubId = ? and instanceId = ?");
            statement.append(" and userId = ? order by decisionDate desc");
            prepStmt = null;
            rs = null;
            try {
                prepStmt = con.prepareStatement(statement.toString());
                prepStmt.setInt(1, Integer.parseInt(pubPK.getId()));
                prepStmt.setString(2, pubPK.getInstanceId());
                prepStmt.setInt(3, Integer.parseInt(userId));
                rs = prepStmt.executeQuery();
                if (!rs.next()) break block2;
                ValidationStep step = new ValidationStep();
                step.setId(rs.getInt(1));
                step.setPubPK(pubPK);
                step.setUserId(String.valueOf(rs.getInt(4)));
                step.setValidationDate(new Date(Long.parseLong(rs.getString(5))));
                step.setDecision(rs.getString(6));
                validationStep = step;
            }
            catch (Throwable throwable) {
                DBUtil.close(rs);
                DBUtil.close((Statement)prepStmt);
                throw throwable;
            }
            DBUtil.close((ResultSet)rs);
            DBUtil.close((Statement)prepStmt);
            return validationStep;
        }
        DBUtil.close((ResultSet)rs);
        DBUtil.close((Statement)prepStmt);
        return null;
    }
}

