/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.wysiwyg.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentException;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.model.UnlockContext;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.contribution.content.wysiwyg.WysiwygException;
import org.silverpeas.core.contribution.content.wysiwyg.notification.WysiwygEventNotifier;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.contribution.model.WysiwygContent;
import org.silverpeas.core.contribution.service.WysiwygContentRepository;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.UtilException;
import org.silverpeas.core.util.file.FileFolderManager;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

@Singleton
@Service
public class WysiwygManager
implements WysiwygContentRepository {
    private static final String COMPONENT_ID = "/componentId/";
    private static final String ATTACHMENT_ID = "/attachmentId/";
    @Inject
    private WysiwygEventNotifier notifier;
    public static final String WYSIWYG_CONTEXT = DocumentType.wysiwyg.name();
    public static final String WYSIWYG_IMAGES = "Images";
    public static final String WYSIWYG_WEBSITES = "webSites";

    protected WysiwygManager() {
    }

    private String loadFromFileSystemDirectly(ContributionIdentifier id, String language) throws IOException {
        File wysiwygFile = new File(this.getLegacyWysiwygPath(WYSIWYG_CONTEXT, id.getComponentInstanceId()), this.getWysiwygFileName(id.getLocalId(), language));
        if (!wysiwygFile.exists() || !wysiwygFile.isFile()) {
            wysiwygFile = new File(this.getLegacyWysiwygPath(WYSIWYG_CONTEXT, id.getComponentInstanceId()), this.getOldWysiwygFileName(id.getLocalId()));
        }
        String content = null;
        if (wysiwygFile.exists() && wysiwygFile.isFile()) {
            content = FileUtils.readFileToString((File)wysiwygFile, (Charset)Charsets.UTF_8);
        }
        return content;
    }

    private String getLegacyWysiwygPath(String context, String componentId) {
        String path;
        if (StringUtil.isDefined((String)context)) {
            String strAt = "Attachment,";
            strAt = strAt.concat(context);
            String[] ctx = StringUtil.split((String)strAt, (char)',');
            path = FileRepositoryManager.getAbsolutePath(componentId, ctx);
        } else {
            String[] ctx = new String[]{"Attachment"};
            path = FileRepositoryManager.getAbsolutePath(componentId, ctx);
        }
        return path;
    }

    public List<SimpleDocument> getImages(String id, String componentId) {
        SimpleDocumentList<SimpleDocument> attachments = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(new ResourceReference(id, componentId), DocumentType.image, null);
        Iterator it = attachments.iterator();
        while (it.hasNext()) {
            SimpleDocument document = (SimpleDocument)it.next();
            if (document.isContentImage()) continue;
            it.remove();
        }
        return attachments;
    }

    public String getWebsiteRepository() {
        SettingBundle websiteSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.webSites.settings.webSiteSettings");
        return websiteSettings.getString("uploadsPath");
    }

    public String[][] getWebsiteImages(String path, String componentId) throws WysiwygException {
        this.checkPath(path);
        try {
            Collection<File> listImages = FileFolderManager.getAllImages(path);
            Iterator<File> i = listImages.iterator();
            int nbImages = listImages.size();
            String[][] images = new String[nbImages][2];
            for (int j = 0; j < nbImages; ++j) {
                File image = i.next();
                images[j][0] = this.finNode2(image.getAbsolutePath(), componentId).replace('\\', '/');
                images[j][1] = image.getName();
            }
            return images;
        }
        catch (Exception e) {
            throw new WysiwygException(e);
        }
    }

    public String[][] getWebsitePages(String path, String componentId) throws WysiwygException {
        this.checkPath(path);
        try {
            Collection<File> listPages = FileFolderManager.getAllWebPages(this.getNodePath(path, componentId));
            Iterator<File> i = listPages.iterator();
            int nbPages = listPages.size();
            String[][] pages = new String[nbPages][2];
            for (int j = 0; j < nbPages; ++j) {
                File page = i.next();
                pages[j][0] = this.finNode2(page.getAbsolutePath(), componentId).replace('\\', '/');
                pages[j][1] = page.getName();
            }
            return pages;
        }
        catch (UtilException e) {
            throw new WysiwygException(e);
        }
    }

    String finNode(String path, String componentId) {
        int longueur = componentId.length();
        int index = path.lastIndexOf(componentId);
        String chemin = path.substring(index + longueur);
        chemin = this.suppressLeadingSlashesOrAntislashes(chemin);
        chemin = this.supprDoubleAntiSlash(chemin);
        return chemin;
    }

    String finNode2(String path, String componentId) {
        String finNode = StringUtil.doubleAntiSlash((String)path);
        int index = (finNode = this.finNode(finNode, componentId)).indexOf(92);
        if (index < 0) {
            index = finNode.indexOf(47);
        }
        return finNode.substring(index + 1);
    }

    String getNodePath(String currentPath, String componentId) {
        String path = currentPath;
        if (path != null) {
            path = this.suppressFinalSlash(path);
            int indexComponent = path.lastIndexOf(componentId) + componentId.length();
            String pathEnd = this.suppressLeadingSlashesOrAntislashes(path.substring(indexComponent));
            int index = -1;
            if (pathEnd.contains("/")) {
                index = pathEnd.indexOf(47);
            } else if (pathEnd.contains("\\")) {
                index = pathEnd.indexOf(92);
            }
            if (index == -1) {
                return path;
            }
            return path.substring(0, path.indexOf(pathEnd) + index);
        }
        return "";
    }

    String suppressFinalSlash(String path) {
        if (path.endsWith("/")) {
            return this.suppressFinalSlash(path.substring(0, path.length() - 1));
        }
        return path;
    }

    String ignoreLeadingSlash(String path) {
        if (path.startsWith("/")) {
            return this.ignoreLeadingSlash(path.substring(1));
        }
        return path;
    }

    String supprDoubleAntiSlash(String path) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char car = path.charAt(i);
            if (car == '\\' && path.charAt(i + 1) == '\\') {
                res.append(car);
                ++i;
                continue;
            }
            res.append(car);
        }
        return res.toString();
    }

    String suppressLeadingSlashesOrAntislashes(String path) {
        if (path.startsWith("\\") || path.startsWith("/")) {
            return this.suppressLeadingSlashesOrAntislashes(path.substring(1));
        }
        return path;
    }

    public String getOldWysiwygFileName(String objectId) {
        return objectId + WYSIWYG_CONTEXT + ".txt";
    }

    public String getWysiwygFileName(String objectId, String lang) {
        String language = I18NHelper.checkLanguage(lang);
        return objectId + WYSIWYG_CONTEXT + "_" + language + ".txt";
    }

    public String getImagesFileName(String objectId) {
        return objectId + WYSIWYG_IMAGES;
    }

    public void deleteFileAndAttachment(String componentId, String id) {
        ResourceReference foreignKey = new ResourceReference(id, componentId);
        SimpleDocumentList<SimpleDocument> documents = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKey(foreignKey, null);
        for (SimpleDocument doc : documents) {
            AttachmentServiceProvider.getAttachmentService().deleteAttachment(doc);
        }
    }

    public void deleteFile(String componentId, String objectId, String language) {
        ResourceReference foreignKey = new ResourceReference(objectId, componentId);
        SimpleDocumentList<SimpleDocument> files = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKey(foreignKey, null);
        for (SimpleDocument file : files) {
            if (file == null || !file.getFilename().equalsIgnoreCase(this.getWysiwygFileName(objectId, language))) continue;
            AttachmentServiceProvider.getAttachmentService().removeContent(file, language, false);
        }
    }

    public void delete(WysiwygContent content) {
        LocalizedContribution contribution = content.getContribution();
        this.deleteFile(contribution.getIdentifier().getComponentInstanceId(), contribution.getIdentifier().getLocalId(), contribution.getLanguage());
    }

    public void deleteByContribution(Contribution contribution) {
        this.deleteWysiwygAttachments(contribution.getIdentifier().getComponentInstanceId(), contribution.getIdentifier().getLocalId());
    }

    public void createFileAndAttachment(WysiwygContent content, String context) {
        this.createFileAndAttachment(content, DocumentType.valueOf(context), true, true);
    }

    private void createFileAndAttachment(WysiwygContent content, DocumentType context, boolean indexIt, boolean notify) {
        if (!StringUtil.isDefined((String)content.getData())) {
            return;
        }
        LocalizedContribution contribution = content.getContribution();
        String fileName = this.getWysiwygFileName(contribution.getIdentifier().getLocalId(), contribution.getLanguage());
        String language = I18NHelper.checkLanguage(contribution.getLanguage());
        String textHtml = content.getData();
        String userId = content.getAuthor().getId();
        SimpleDocumentPK docPk = new SimpleDocumentPK(null, content.getContribution().getIdentifier().getComponentInstanceId());
        SimpleAttachment attachment = SimpleAttachment.builder(language).setFilename(fileName).setTitle(fileName).setSize(textHtml.length()).setContentType("text/html").setCreationData(userId, new Date()).build();
        SimpleDocument document = new SimpleDocument(docPk, contribution.getIdentifier().getLocalId(), 0, false, userId, attachment);
        document.setDocumentType(context);
        AttachmentServiceProvider.getAttachmentService().createAttachment(document, new ByteArrayInputStream(textHtml.getBytes(Charsets.UTF_8)), indexIt, false);
        if (notify) {
            this.notifier.notifyEventOn(ResourceEvent.Type.CREATION, (Serializable[])new WysiwygContent[]{content});
        }
        AttachmentServiceProvider.getAttachmentService().unlock(new UnlockContext(document.getId(), userId, document.getLanguage()));
    }

    public void createFileAndAttachment(WysiwygContent content) {
        this.createFileAndAttachment(content, WYSIWYG_CONTEXT);
    }

    public void createUnindexedFileAndAttachment(WysiwygContent content) {
        this.createFileAndAttachment(content, DocumentType.wysiwyg, false, false);
    }

    public void addToIndex(FullIndexEntry indexEntry, ResourceReference pk, String language) {
        SimpleDocumentList<SimpleDocument> docs = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(pk, DocumentType.wysiwyg, language);
        if (!docs.isEmpty()) {
            for (SimpleDocument wysiwyg : docs) {
                String wysiwygPath = wysiwyg.getAttachmentPath();
                indexEntry.addFileContent(wysiwygPath, null, "text/html", language);
                String wysiwygContent = this.loadContent(wysiwyg, language);
                List<String> embeddedAttachmentIds = this.getEmbeddedAttachmentIds(wysiwygContent);
                this.indexEmbeddedLinkedFiles(indexEntry, embeddedAttachmentIds);
            }
        }
    }

    private void saveFile(WysiwygContent content, boolean indexIt) {
        LocalizedContribution contribution = content.getContribution();
        String lang = I18NHelper.checkLanguage(contribution.getLanguage());
        DocumentType wysiwygType = DocumentType.wysiwyg;
        String fileName = this.getWysiwygFileName(contribution.getIdentifier().getLocalId(), lang);
        SimpleDocument document = this.searchAttachmentDetail(contribution.getIdentifier(), wysiwygType, lang);
        if (document != null) {
            WysiwygContent beforeUpdateContent = this.getByContribution(contribution);
            if (!document.getLanguage().equals(lang)) {
                document.setFilename(fileName);
            }
            document.setLanguage(lang);
            document.setSize(content.getData().getBytes(Charsets.UTF_8).length);
            document.setDocumentType(wysiwygType);
            document.setUpdatedBy(content.getAuthor().getId());
            if (document.getSize() > 0L) {
                AttachmentServiceProvider.getAttachmentService().updateAttachment(document, new ByteArrayInputStream(content.getData().getBytes(Charsets.UTF_8)), indexIt, false);
                this.notifier.notifyEventOn(ResourceEvent.Type.UPDATE, (Serializable[])new WysiwygContent[]{beforeUpdateContent, content});
            } else {
                AttachmentServiceProvider.getAttachmentService().removeContent(document, lang, true);
            }
        } else {
            this.createFileAndAttachment(content, wysiwygType, indexIt, true);
        }
    }

    public void updateFileAndAttachment(WysiwygContent content) {
        this.saveFile(content, content.getContribution().isIndexable());
    }

    public void save(WysiwygContent content) {
        this.saveFile(content, content.getContribution().isIndexable());
    }

    public void deleteWysiwygAttachments(String componentId, String objectId) {
        try {
            ResourceReference foreignKey = new ResourceReference(objectId, componentId);
            SimpleDocumentList<SimpleDocument> documents = AttachmentServiceProvider.getAttachmentService().listAllDocumentsByForeignKey(foreignKey, null);
            for (SimpleDocument document : documents) {
                AttachmentServiceProvider.getAttachmentService().deleteAttachment(document);
            }
        }
        catch (AttachmentException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
    }

    public void deleteWysiwygAttachmentsOnly(String componentId, String objectId) throws WysiwygException {
        try {
            ResourceReference foreignKey = new ResourceReference(objectId, componentId);
            SimpleDocumentList<SimpleDocument> docs = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.wysiwyg, null);
            for (SimpleDocument wysiwygAttachment : docs) {
                AttachmentServiceProvider.getAttachmentService().deleteAttachment(wysiwygAttachment, false);
            }
            docs = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.image, null);
            for (SimpleDocument document : docs) {
                AttachmentServiceProvider.getAttachmentService().deleteAttachment(document, false);
            }
        }
        catch (Exception exc) {
            throw new WysiwygException(exc);
        }
    }

    private String loadContent(SimpleDocument document, String lang) {
        String content = "";
        if (this.isEmptyWysiwygContent(document, lang)) {
            return content;
        }
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            AttachmentServiceProvider.getAttachmentService().getBinaryContent(buffer, document.getPk(), lang);
            content = new String(buffer.toByteArray(), Charsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return content;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEmptyWysiwygContent(SimpleDocument document, String lang) {
        if (document.getDocumentType() != DocumentType.wysiwyg) return false;
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            AttachmentServiceProvider.getAttachmentService().getBinaryContent(buffer, document.getPk(), lang, 0L, 1L);
            if (buffer.size() != 0) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public WysiwygContent getByContribution(LocalizedContribution contribution) {
        String content = this.internalLoad(contribution.getIdentifier(), contribution.getLanguage());
        if (I18NHelper.isI18nContentEnabled() && content != null && StringUtil.isNotDefined((String)content)) {
            ArrayList<String> languages = new ArrayList<String>(I18NHelper.getAllSupportedLanguages());
            languages.remove(contribution.getLanguage());
            for (String lang : languages) {
                content = this.internalLoad(contribution.getIdentifier(), lang);
                if (content != null && !StringUtil.isDefined((String)content)) continue;
                break;
            }
        }
        if (content == null) {
            content = "";
        }
        return new WysiwygContent(contribution, content);
    }

    private String internalLoad(ContributionIdentifier id, String language) {
        String currentLanguage;
        String finalLanguage = currentLanguage = I18NHelper.checkLanguage(language);
        String content = "";
        SimpleDocument document = this.searchAttachmentDetail(id, DocumentType.wysiwyg, currentLanguage);
        if (document != null) {
            content = this.loadContent(document, currentLanguage);
            finalLanguage = document.getLanguage();
        }
        if (!StringUtil.isDefined((String)content)) {
            try {
                String contentFromSystem = this.loadFromFileSystemDirectly(id, currentLanguage);
                if (StringUtil.isDefined((String)contentFromSystem)) {
                    content = contentFromSystem;
                    finalLanguage = currentLanguage;
                }
            }
            catch (IOException ex) {
                SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (StringUtil.isNotDefined((String)content) && !finalLanguage.equals(currentLanguage)) {
            content = null;
        }
        return content;
    }

    public List<String> getEmbeddedAttachmentIds(String content) {
        ArrayList<String> attachmentIds = new ArrayList<String>();
        if (content != null) {
            String fileId;
            Pattern attachmentLinkPattern = Pattern.compile("href=\\\"\\/silverpeas\\/File\\/(.*?)\\\"");
            Matcher linkMatcher = attachmentLinkPattern.matcher(content);
            while (linkMatcher.find()) {
                fileId = linkMatcher.group(1);
                attachmentIds.add(fileId);
            }
            attachmentLinkPattern = Pattern.compile("href=\\\"\\/silverpeas\\/FileServer\\/(.*?)attachmentId=(\\d*)");
            linkMatcher = attachmentLinkPattern.matcher(content);
            while (linkMatcher.find()) {
                fileId = linkMatcher.group(2);
                attachmentIds.add(fileId);
            }
        }
        return attachmentIds;
    }

    public String loadFileWebsite(String path, String fileName) throws WysiwygException {
        this.checkPath(path);
        try {
            Optional<String> content = FileFolderManager.getFileContent(path, fileName);
            if (content.isPresent()) {
                return content.get();
            }
            return "";
        }
        catch (UtilException e) {
            throw new WysiwygException(e);
        }
    }

    public boolean haveGotWysiwygToDisplay(LocalizedContribution contribution) {
        return this.haveGotWysiwyg(contribution);
    }

    public boolean haveGotWysiwyg(LocalizedContribution contribution) {
        WysiwygContent wysiwygContent = this.getByContribution(contribution);
        return !wysiwygContent.isEmpty();
    }

    private SimpleDocument searchAttachmentDetail(ContributionIdentifier id, DocumentType context, String lang) {
        String language = I18NHelper.checkLanguage(lang);
        SimpleDocumentList<SimpleDocument> documents = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(new ResourceReference(id.getLocalId(), id.getComponentInstanceId()), context, language);
        if (!documents.isEmpty()) {
            return (SimpleDocument)documents.orderByLanguageAndLastUpdate(lang).get(0);
        }
        return null;
    }

    public void updateWebsite(String filePath, String fileName, String fileContent) throws WysiwygException {
        this.checkPath(filePath);
        this.createFile(filePath, fileName, fileContent);
    }

    protected File createFile(String filePath, String fileName, String fileContent) throws WysiwygException {
        this.checkPath(filePath);
        FileFolderManager.createFile(filePath, fileName, fileContent);
        File directory = new File(filePath);
        return FileUtils.getFile((File)directory, (String[])new String[]{fileName});
    }

    public Map<String, String> copy(String oldComponentId, String oldObjectId, String componentId, String objectId, String userId) {
        ResourceReference foreignKey = new ResourceReference(oldObjectId, oldComponentId);
        ResourceReference targetPk = new ResourceReference(objectId, componentId);
        SimpleDocument copy = null;
        ArrayList<Pair<SimpleDocumentPK, SimpleDocumentPK>> oldNewImagePkMapping = new ArrayList<Pair<SimpleDocumentPK, SimpleDocumentPK>>();
        HashMap<String, String> fileIds = new HashMap<String, String>();
        ArrayList<String> languagesWithEmptyContent = new ArrayList<String>();
        for (String language : I18NHelper.getAllSupportedLanguages()) {
            SimpleDocumentList<SimpleDocument> documents = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.wysiwyg, language).removeLanguageFallbacks();
            for (SimpleDocument doc : documents) {
                if (!this.isEmptyWysiwygContent(doc, doc.getLanguage())) {
                    doc.getAttachment().setCreatedBy(userId);
                    if (copy == null) {
                        copy = this.getCopy(foreignKey, targetPk, oldNewImagePkMapping, fileIds, doc);
                    }
                    copy.setLanguage(language);
                    String content = this.updateCopyContent(oldComponentId, oldObjectId, componentId, objectId, copy, oldNewImagePkMapping, doc);
                    AttachmentServiceProvider.getAttachmentService().updateAttachment(copy, new ByteArrayInputStream(content.getBytes(Charsets.UTF_8)), false, false);
                    continue;
                }
                languagesWithEmptyContent.add(language);
            }
        }
        if (copy != null) {
            for (String languageWithEmptyContent : languagesWithEmptyContent) {
                AttachmentServiceProvider.getAttachmentService().removeContent(copy, languageWithEmptyContent, false);
            }
        }
        return fileIds;
    }

    public Pair<String, Map<String, String>> copyDocumentsBetweenTwoResourcesWithSourceContent(ResourceReference sourceRef, ResourceReference targetRef, String sourceContent) {
        ArrayList<Pair<SimpleDocumentPK, SimpleDocumentPK>> oldNewImagePkMapping = new ArrayList<Pair<SimpleDocumentPK, SimpleDocumentPK>>();
        HashMap fileIds = new HashMap();
        AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(sourceRef, DocumentType.image, null).forEach(i -> {
            SimpleDocumentPK imageCopyPk = AttachmentServiceProvider.getAttachmentService().copyDocument((SimpleDocument)i, targetRef);
            fileIds.put(i.getId(), imageCopyPk.getId());
            oldNewImagePkMapping.add(Pair.of((Object)((Object)i.getPk()), (Object)((Object)imageCopyPk)));
        });
        String updatedContent = this.updateCopyContent(sourceContent, sourceRef, targetRef, oldNewImagePkMapping);
        return Pair.of((Object)updatedContent, fileIds);
    }

    private String updateCopyContent(String oldComponentId, String oldObjectId, String componentId, String objectId, SimpleDocument copy, List<Pair<SimpleDocumentPK, SimpleDocumentPK>> oldNewImagePkMapping, SimpleDocument doc) {
        String sourceContent = this.loadContent(copy, doc.getLanguage());
        return this.updateCopyContent(sourceContent, new ResourceReference(oldObjectId, oldComponentId), new ResourceReference(objectId, componentId), oldNewImagePkMapping);
    }

    private String updateCopyContent(String sourceContent, ResourceReference sourceRef, ResourceReference targetRef, List<Pair<SimpleDocumentPK, SimpleDocumentPK>> oldNewImagePkMapping) {
        String content = this.replaceInternalImagesPath(sourceContent, sourceRef.getComponentInstanceId(), sourceRef.getLocalId(), targetRef.getComponentInstanceId(), targetRef.getLocalId());
        for (Pair<SimpleDocumentPK, SimpleDocumentPK> oldNewPk : oldNewImagePkMapping) {
            content = this.replaceInternalImageId(content, (SimpleDocumentPK)((Object)oldNewPk.getFirst()), (SimpleDocumentPK)((Object)oldNewPk.getSecond()));
        }
        return content;
    }

    private SimpleDocument getCopy(ResourceReference foreignKey, ResourceReference targetPk, List<Pair<SimpleDocumentPK, SimpleDocumentPK>> oldNewImagePkMapping, Map<String, String> fileIds, SimpleDocument doc) {
        SimpleDocumentPK pk = AttachmentServiceProvider.getAttachmentService().copyDocument(doc, targetPk);
        SimpleDocument copy = AttachmentServiceProvider.getAttachmentService().searchDocumentById(pk, doc.getLanguage());
        SimpleDocumentList<SimpleDocument> images = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.image, null);
        for (SimpleDocument image : images) {
            SimpleDocumentPK imageCopyPk = AttachmentServiceProvider.getAttachmentService().copyDocument(image, targetPk);
            fileIds.put(image.getId(), imageCopyPk.getId());
            oldNewImagePkMapping.add((Pair<SimpleDocumentPK, SimpleDocumentPK>)Pair.of((Object)((Object)image.getPk()), (Object)((Object)imageCopyPk)));
        }
        return copy;
    }

    public void move(String fromComponentId, String fromObjectId, String componentId, String objectId) {
        ResourceReference fromResourceReference = new ResourceReference(fromObjectId, fromComponentId);
        SimpleDocumentList<SimpleDocument> documents = AttachmentServiceProvider.getAttachmentService().listAllDocumentsByForeignKey(fromResourceReference, null);
        ResourceReference toResourceReference = new ResourceReference(objectId, componentId);
        for (SimpleDocument document : documents) {
            AttachmentServiceProvider.getAttachmentService().moveDocument(document, toResourceReference);
        }
        this.wysiwygPlaceHaveChanged(fromComponentId, fromObjectId, componentId, objectId);
    }

    String replaceInternalImageId(String wysiwygContent, SimpleDocumentPK oldPK, SimpleDocumentPK newPK) {
        String from = COMPONENT_ID + oldPK.getInstanceId() + ATTACHMENT_ID + oldPK.getId() + "/";
        String fromOldId = COMPONENT_ID + oldPK.getInstanceId() + ATTACHMENT_ID + oldPK.getOldSilverpeasId() + "/";
        String to = COMPONENT_ID + newPK.getInstanceId() + ATTACHMENT_ID + newPK.getId() + "/";
        return wysiwygContent.replaceAll(from, to).replaceAll(fromOldId, to);
    }

    private String replaceInternalImagesPath(String wysiwygContent, String oldComponentId, String oldObjectId, String componentId, String objectId) {
        StringBuilder newStr = new StringBuilder();
        if (wysiwygContent.contains("FileServer")) {
            String co = "ComponentId=" + oldComponentId;
            String di = "Directory=Attachment/" + this.getImagesFileName(oldObjectId);
            String diBis = "Directory=Attachment%2F" + this.getImagesFileName(oldObjectId);
            String diTer = "Directory=Attachment\\" + this.getImagesFileName(oldObjectId);
            String diQua = "Directory=Attachment%5C" + this.getImagesFileName(oldObjectId);
            int begin = 0;
            int end = wysiwygContent.indexOf(co, begin);
            while (end != -1) {
                newStr.append(wysiwygContent.substring(begin, end));
                newStr.append("ComponentId=").append(componentId);
                begin = end + co.length();
                end = wysiwygContent.indexOf(co, begin);
            }
            newStr.append(wysiwygContent.substring(begin, wysiwygContent.length()));
            wysiwygContent = newStr.toString();
            newStr = new StringBuilder();
            begin = 0;
            end = wysiwygContent.indexOf(di, begin);
            while (end != -1) {
                newStr.append(wysiwygContent.substring(begin, end));
                newStr.append("Directory=Attachment/").append(this.getImagesFileName(objectId));
                begin = end + di.length();
                end = wysiwygContent.indexOf(di, begin);
            }
            newStr.append(wysiwygContent.substring(begin, wysiwygContent.length()));
            wysiwygContent = newStr.toString();
            newStr = new StringBuilder();
            begin = 0;
            end = wysiwygContent.indexOf(diBis, begin);
            while (end != -1) {
                newStr.append(wysiwygContent.substring(begin, end));
                newStr.append("Directory=Attachment%2F").append(this.getImagesFileName(objectId));
                begin = end + diBis.length();
                end = wysiwygContent.indexOf(diBis, begin);
            }
            newStr.append(wysiwygContent.substring(begin, wysiwygContent.length()));
            wysiwygContent = newStr.toString();
            newStr = new StringBuilder();
            begin = 0;
            end = wysiwygContent.indexOf(diTer, begin);
            while (end != -1) {
                newStr.append(wysiwygContent.substring(begin, end));
                newStr.append("Directory=Attachment\\").append(this.getImagesFileName(objectId));
                begin = end + diTer.length();
                end = wysiwygContent.indexOf(diTer, begin);
            }
            newStr.append(wysiwygContent.substring(begin, wysiwygContent.length()));
            wysiwygContent = newStr.toString();
            newStr = new StringBuilder();
            begin = 0;
            end = wysiwygContent.indexOf(diQua, begin);
            while (end != -1) {
                newStr.append(wysiwygContent.substring(begin, end));
                newStr.append("Directory=Attachment%5C" + this.getImagesFileName(objectId));
                begin = end + diQua.length();
                end = wysiwygContent.indexOf(diQua, begin);
            }
            newStr.append(wysiwygContent.substring(begin, wysiwygContent.length()));
        } else {
            newStr = new StringBuilder(wysiwygContent);
        }
        return newStr.toString();
    }

    public void wysiwygPlaceHaveChanged(String oldComponentId, String oldObjectId, String newComponentId, String newObjectId) {
        ResourceReference foreignKey = new ResourceReference(newObjectId, newComponentId);
        SimpleDocumentList<SimpleDocument> images = null;
        for (String language : I18NHelper.getAllSupportedLanguages()) {
            SimpleDocumentList<SimpleDocument> documents = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.wysiwyg, language).removeLanguageFallbacks();
            for (SimpleDocument document : documents) {
                String wysiwyg = this.loadContent(document, language);
                if (!StringUtil.isDefined((String)wysiwyg)) continue;
                wysiwyg = this.replaceInternalImagesPath(wysiwyg, oldComponentId, oldObjectId, newComponentId, newObjectId);
                if (images == null) {
                    images = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.image, null);
                }
                for (SimpleDocument image : images) {
                    image.getPk().setComponentName(oldComponentId);
                    SimpleDocumentPK imageCopyPk = new SimpleDocumentPK(image.getId(), newComponentId);
                    imageCopyPk.setOldSilverpeasId(image.getOldSilverpeasId());
                    wysiwyg = this.replaceInternalImageId(wysiwyg, image.getPk(), imageCopyPk);
                }
                AttachmentServiceProvider.getAttachmentService().updateAttachment(document, new ByteArrayInputStream(wysiwyg.getBytes(Charsets.UTF_8)), true, true);
            }
        }
    }

    public String getWysiwygPath(String componentId, String objectId, String language) {
        SimpleDocumentList<SimpleDocument> attachements = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(new ResourceReference(objectId, componentId), DocumentType.wysiwyg, language);
        if (!attachements.isEmpty()) {
            return ((SimpleDocument)attachements.get(0)).getAttachmentPath();
        }
        return "";
    }

    public String getWysiwygPath(String componentId, String objectId) {
        return this.getWysiwygPath(componentId, objectId, null);
    }

    public List<ComponentInstLight> getGalleries() {
        return OrganizationController.get().getComponentsWithParameterValue("viewInWysiwyg", "yes");
    }

    public void indexEmbeddedLinkedFiles(FullIndexEntry indexEntry, List<String> embeddedAttachmentIds) {
        for (String attachmentId : embeddedAttachmentIds) {
            try {
                SimpleDocument attachment = AttachmentServiceProvider.getAttachmentService().searchDocumentById(new SimpleDocumentPK(attachmentId), null);
                if (attachment == null) continue;
                indexEntry.addLinkedFileContent(attachment.getAttachmentPath(), Charsets.UTF_8.toString(), attachment.getContentType(), attachment.getLanguage());
                indexEntry.addLinkedFileId(attachmentId);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Error while indexing the WYSIWYG content (attachment id {0})", new Object[]{attachmentId});
            }
        }
    }

    public String createPath(String componentId, String context) {
        String path = this.getLegacyWysiwygPath(context, componentId);
        try {
            File folder = new File(path);
            if (!folder.exists()) {
                FileFolderManager.createFolder(path);
            }
            return path;
        }
        catch (UtilException e) {
            throw new AttachmentException("Cannot create path", e);
        }
    }

    private void checkPath(String path) throws WysiwygException {
        if (path.contains("..")) {
            throw new WysiwygException("Forbidden access to " + path, new String[0]);
        }
    }
}

