/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.field;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class TextFieldImpl
extends TextField {
    private static final long serialVersionUID = 1L;
    private String value = "";
    private static final String SUGGESTIONS_QUERY = "select distinct(f.fieldValue) from sb_formtemplate_template t, sb_formtemplate_record r, sb_formtemplate_textfield f where t.templateId = r.templateId and r.recordId = f.recordId and f.fieldName = ? and t.externalId = ? order by f.fieldValue";

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public void setStringValue(String value) {
        this.value = value;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSuggestions(String fieldName, String templateName, String componentId) {
        ArrayList<String> suggestions = new ArrayList<String>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try (Connection connection = DBUtil.openConnection();){
            statement = connection.prepareStatement(SUGGESTIONS_QUERY);
            statement.setString(1, fieldName);
            statement.setString(2, componentId + ":" + templateName);
            rs = statement.executeQuery();
            while (rs.next()) {
                String oneSuggestion = rs.getString(1);
                if (!StringUtil.isDefined((String)oneSuggestion)) continue;
                suggestions.add(oneSuggestion);
            }
        }
        catch (Exception e) {
            try {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, statement);
                throw throwable;
            }
            DBUtil.close(rs, (Statement)statement);
        }
        DBUtil.close((ResultSet)rs, (Statement)statement);
        return suggestions;
    }

    public static void printSuggestionsIncludes(String fieldName, PrintWriter out) {
        int zindex = 100;
        out.println("<style type=\"text/css\">\n");
        out.println("\t#container" + fieldName + " {\n");
        out.println("\t\tz-index:" + zindex + "; /* z-index needed on top instance for ie & sf absolute inside relative issue */\n");
        out.println("\t}\n");
        out.println("\t#" + fieldName + " {\n");
        out.println("\t\t_position:absolute; /* abs pos needed for ie quirks */\n");
        out.println("\t}\n");
        out.println("</style>\n");
    }

    public static void printSuggestionsScripts(String fieldName, List<String> suggestions, PrintWriter out) {
        out.println("<script type=\"text/javascript\">\n");
        out.println("listArray" + fieldName + " = [\n");
        Iterator<String> itRes = suggestions.iterator();
        while (itRes.hasNext()) {
            String val = itRes.next();
            out.println("\"" + WebEncodeHelper.javaStringToJsString((String)val) + "\"");
            if (!itRes.hasNext()) continue;
            out.println(",");
        }
        out.println("];\n");
        out.println("</script>\n");
        out.println("<script type=\"text/javascript\">\n");
        out.println(" this.oACDS" + fieldName + " = new YAHOO.util.LocalDataSource(listArray" + fieldName + ");\n");
        out.println("\tthis.oAutoComp" + fieldName + " = new YAHOO.widget.AutoComplete('" + fieldName + "','container" + fieldName + "', this.oACDS" + fieldName + ");\n");
        out.println("\tthis.oAutoComp" + fieldName + ".prehighlightClassName = \"yui-ac-prehighlight\";\n");
        out.println("\tthis.oAutoComp" + fieldName + ".typeAhead = true;\n");
        out.println("\tthis.oAutoComp" + fieldName + ".useShadow = true;\n");
        out.println("\tthis.oAutoComp" + fieldName + ".minQueryLength = 0;\n");
        out.println("\tthis.oAutoComp" + fieldName + ".textboxFocusEvent.subscribe(function(){\n");
        out.println("\t\tvar sInputValue = YAHOO.util.Dom.get('" + fieldName + "').value;\n");
        out.println("\t\tif(sInputValue.length == 0) {\n");
        out.println("\t\t\tvar oSelf = this;\n");
        out.println("\t\t\tsetTimeout(function(){oSelf.sendQuery(sInputValue);},0);\n");
        out.println("\t\t}\n");
        out.println("\t});\n");
        out.println("</script>\n");
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

