/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.silverpeas.core.contribution.content.form.FieldValue;

public class FieldValuesTemplate {
    private final List<FieldValue> values = new ArrayList<FieldValue>(10);
    private final String language;

    public FieldValuesTemplate(String language) {
        this.language = language;
    }

    public FieldValuesTemplate withAsValue(String key, String label) {
        String l;
        String k = key.isBlank() && !label.isBlank() ? label : key;
        String string = l = label.isBlank() && !key.isBlank() ? key : label;
        if (!k.isBlank() && !l.isBlank()) {
            this.values.add(new FieldValue(k, l, this.language));
        }
        return this;
    }

    public void apply(Consumer<FieldValue> consumer) {
        this.values.forEach(consumer);
    }

    public Optional<FieldValue> get(String key) {
        return this.values.stream().filter(value -> value.getKey().equals(key)).findFirst();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int size() {
        return this.values.size();
    }
}

