/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.core.ActionType;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.cache.VolatileResourceCleaner;
import org.silverpeas.core.contribution.attachment.AttachmentException;
import org.silverpeas.core.contribution.attachment.AttachmentService;
import org.silverpeas.core.contribution.attachment.SimpleDocumentServiceContext;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.HistorisedDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.model.UnlockContext;
import org.silverpeas.core.contribution.attachment.notification.AttachmentEventNotifier;
import org.silverpeas.core.contribution.attachment.process.AttachmentSimulationElementLister;
import org.silverpeas.core.contribution.attachment.process.huge.AttachmentHugeProcess;
import org.silverpeas.core.contribution.attachment.process.huge.AttachmentHugeProcessManager;
import org.silverpeas.core.contribution.attachment.process.huge.PreventAttachmentHugeProcess;
import org.silverpeas.core.contribution.attachment.repository.DocumentRepository;
import org.silverpeas.core.contribution.attachment.util.AttachmentSettings;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.contribution.attachment.webdav.WebdavRepository;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.jcr.JCRSession;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.process.annotation.SimulationActionProcess;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.annotation.Action;
import org.silverpeas.core.util.annotation.SourceObject;
import org.silverpeas.core.util.annotation.SourcePK;
import org.silverpeas.core.util.annotation.TargetPK;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class SimpleDocumentService
implements AttachmentService,
ComponentInstanceDeletion,
VolatileResourceCleaner {
    private static final String ATTACHMENT_TYPE = "Attachment";
    private static final String COMMENT_TYPE = "Comment";
    private static final String NODE_TYPE = "Node";
    @Inject
    private WebdavRepository webdavRepository;
    @Inject
    private DocumentRepository repository;
    @Inject
    private AttachmentEventNotifier notificationService;
    private final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.util.attachment.Attachment");

    @Override
    public void deleteAllAttachments(String componentInstanceId) {
        try (JCRSession session = JCRSession.openSystemSession();){
            String componentInstanceNodePath = "/" + componentInstanceId;
            if (session.nodeExists(componentInstanceNodePath)) {
                List<SimpleDocument> documentsToDelete = this.repository.listAllDocumentsByComponentId((Session)session, componentInstanceId, null);
                for (SimpleDocument documentToDelete : documentsToDelete) {
                    this.deleteAttachment((Session)session, documentToDelete, true);
                }
                session.getNode(componentInstanceNodePath).remove();
                session.save();
            } else {
                SilverLogger.getLogger((Object)this).warn("Non existing node in JCR matching the component instance {0}", new Object[]{componentInstanceId});
            }
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    @Override
    public void cleanVolatileResources(String volatileResourceId, String componentInstanceIdentifier) {
        this.deleteAllAttachments(volatileResourceId, componentInstanceIdentifier);
    }

    @Override
    public void createIndex(SimpleDocument document) {
        this.createIndex(document, null, null);
    }

    @Override
    public void deleteIndex(SimpleDocument document) {
        for (String lang : I18NHelper.getAllSupportedLanguages()) {
            this.deleteIndex(document, lang);
        }
    }

    @Override
    public void createIndex(SimpleDocument document, Date startOfVisibility, Date endOfVisibility) {
        if (this.settings.getBoolean("attachment.index.separately", true)) {
            String language = I18NHelper.checkLanguage(document.getLanguage());
            String objectType = "Attachment_" + language;
            FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey(document.getInstanceId(), objectType, document.getId(), document.getForeignId()));
            indexEntry.setLang(language);
            indexEntry.setCreationDate(document.getCreationDate());
            indexEntry.setCreationUser(document.getCreatedBy());
            if (startOfVisibility != null) {
                indexEntry.setStartDate(startOfVisibility);
            }
            if (endOfVisibility != null) {
                indexEntry.setEndDate(endOfVisibility);
            }
            indexEntry.setTitle(document.getTitle(), language);
            indexEntry.setPreview(document.getDescription(), language);
            indexEntry.setFilename(document.getFilename());
            indexEntry.addFileContent(document.getAttachmentPath(), Charsets.UTF_8.name(), document.getContentType(), language);
            if (StringUtil.isDefined((String)document.getXmlFormId())) {
                this.updateIndexEntryWithXMLFormContent(document.getPk(), document.getXmlFormId(), indexEntry);
            }
            IndexEngineProxy.addIndexEntry(indexEntry);
        }
    }

    private void updateIndexEntryWithXMLFormContent(SimpleDocumentPK pk, String xmlFormName, FullIndexEntry indexEntry) {
        try {
            PublicationTemplate pub = PublicationTemplateManager.getInstance().getPublicationTemplate(indexEntry.getComponent() + ":Attachment:" + xmlFormName);
            RecordSet set = pub.getRecordSet();
            set.indexRecord(pk.getId(), xmlFormName, indexEntry);
        }
        catch (FormException | PublicationTemplateException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    private void deleteIndex(SimpleDocument document, String lang) {
        String language = lang;
        if (language == null) {
            language = I18NHelper.DEFAULT_LANGUAGE;
        }
        String objectType = "Attachment_" + language;
        IndexEntryKey indexEntry = new IndexEntryKey(document.getInstanceId(), objectType, document.getId(), document.getForeignId());
        IndexEngineProxy.removeIndexEntry(indexEntry);
    }

    @Override
    public void unindexAttachmentsOfExternalObject(ResourceReference externalResource) {
        try (JCRSession session = JCRSession.openSystemSession();){
            SimpleDocumentList<SimpleDocument> docs = this.repository.listDocumentsByForeignId((Session)session, externalResource.getInstanceId(), externalResource.getId(), I18NHelper.DEFAULT_LANGUAGE);
            for (SimpleDocument doc : docs) {
                this.deleteIndex(doc, I18NHelper.DEFAULT_LANGUAGE);
            }
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    @Override
    @PreventAttachmentHugeProcess
    public void addXmlForm(@SourcePK SimpleDocumentPK pk, String language, String xmlFormName) {
        try (JCRSession session = JCRSession.openSystemSession();){
            SimpleDocument doc = this.repository.findDocumentById((Session)session, pk, language);
            doc.setXmlFormId(xmlFormName);
            this.repository.updateDocument((Session)session, doc, true);
            session.save();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    @Override
    @PreventAttachmentHugeProcess
    @SimulationActionProcess(elementLister=AttachmentSimulationElementLister.class)
    @Action(value=ActionType.CREATE)
    public SimpleDocument createAttachment(@SourceObject @TargetPK SimpleDocument document, InputStream content) {
        return this.createAttachment(document, content, true);
    }

    @Override
    @PreventAttachmentHugeProcess
    @SimulationActionProcess(elementLister=AttachmentSimulationElementLister.class)
    @Action(value=ActionType.CREATE)
    public SimpleDocument createAttachment(@SourceObject @TargetPK SimpleDocument document, InputStream content, boolean indexIt) {
        return this.createAttachment(document, content, indexIt, true);
    }

    @Override
    @PreventAttachmentHugeProcess
    @SimulationActionProcess(elementLister=AttachmentSimulationElementLister.class)
    @Action(value=ActionType.CREATE)
    public SimpleDocument createAttachment(@SourceObject @TargetPK SimpleDocument document, InputStream content, boolean indexIt, boolean notify) {
        SimpleDocument simpleDocument;
        block10: {
            this.normalizeFileName(document);
            JCRSession session = JCRSession.openSystemSession();
            try {
                SimpleDocumentPK docPk = this.repository.createDocument((Session)session, document);
                session.save();
                SimpleDocument createdDocument = this.repository.findDocumentById((Session)session, docPk, document.getLanguage());
                createdDocument.setPublicDocument(document.isPublic());
                SimpleDocument finalDocument = this.repository.checkin((Session)session, createdDocument, false);
                this.repository.storeContent(finalDocument, content, false);
                if (this.reallyNotifying(document, notify) && StringUtil.isDefined((String)document.getCreatedBy())) {
                    this.notificationService.notifyEventOn(ResourceEvent.Type.CREATION, new SimpleDocument[]{document});
                }
                if (indexIt) {
                    this.createIndex(finalDocument);
                }
                simpleDocument = finalDocument;
                if (session == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RepositoryException ex) {
                    throw new AttachmentException(ex);
                }
            }
            session.close();
        }
        return simpleDocument;
    }

    @Override
    @PreventAttachmentHugeProcess
    public void deleteAttachment(@SourceObject SimpleDocument document) {
        this.deleteAttachment(document, true);
    }

    @Override
    public void deleteAllAttachments(String resourceId, String componentInstanceId) {
        SimpleDocumentList<SimpleDocument> documentsToDelete = this.listAllDocumentsByForeignKey(new ResourceReference(resourceId, componentInstanceId), null);
        for (SimpleDocument documentToDelete : documentsToDelete) {
            this.deleteAttachment(documentToDelete);
        }
    }

    @Override
    @PreventAttachmentHugeProcess
    public void deleteAttachment(@SourceObject SimpleDocument document, boolean notify) {
        try (JCRSession session = JCRSession.openSystemSession();){
            this.deleteAttachment((Session)session, document, notify);
            session.save();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    private void deleteAttachment(Session session, SimpleDocument document, boolean notify) throws RepositoryException {
        this.repository.fillNodeName(session, document);
        this.repository.deleteDocument(session, document.getPk());
        for (String lang : I18NHelper.getAllSupportedLanguages()) {
            this.deleteIndex(document, lang);
        }
        if (document.isOpenOfficeCompatible()) {
            this.webdavRepository.deleteAttachmentNode(session, document);
        }
        if (this.reallyNotifying(document, notify)) {
            this.notificationService.notifyEventOn(ResourceEvent.Type.DELETION, new SimpleDocument[]{document});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SimpleDocument searchDocumentById(SimpleDocumentPK docPk, String lang) {
        try (JCRSession session = JCRSession.openSystemSession();){
            if (StringUtil.isDefined((String)docPk.getId()) && !StringUtil.isLong((String)docPk.getId())) {
                SimpleDocument simpleDocument2 = this.repository.findDocumentById((Session)session, docPk, lang);
                return simpleDocument2;
            }
            SimpleDocument doc = this.repository.findDocumentByOldSilverpeasId((Session)session, docPk.getComponentName(), docPk.getOldSilverpeasId(), false, lang);
            if (doc == null) {
                doc = this.repository.findDocumentByOldSilverpeasId((Session)session, docPk.getComponentName(), docPk.getOldSilverpeasId(), true, lang);
            }
            SimpleDocument simpleDocument = doc;
            return simpleDocument;
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    @Override
    public SimpleDocumentList<SimpleDocument> listAllDocumentsByForeignKey(ResourceReference foreignKey, String lang) {
        SimpleDocumentList<SimpleDocument> simpleDocumentList;
        block8: {
            JCRSession session = JCRSession.openSystemSession();
            try {
                simpleDocumentList = this.repository.listAllDocumentsByForeignId((Session)session, foreignKey.getInstanceId(), foreignKey.getId(), lang);
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException ex) {
                    throw new AttachmentException(ex);
                }
            }
            session.close();
        }
        return simpleDocumentList;
    }

    @Override
    public SimpleDocumentList<SimpleDocument> listDocumentsByForeignKey(ResourceReference foreignKey, String lang) {
        SimpleDocumentList<SimpleDocument> simpleDocumentList;
        block8: {
            JCRSession session = JCRSession.openSystemSession();
            try {
                SimpleDocumentList<SimpleDocument> documents = this.repository.listDocumentsByForeignId((Session)session, foreignKey.getInstanceId(), foreignKey.getId(), lang);
                documents.sortYoungestToOldestAddIfEnabled();
                simpleDocumentList = documents;
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException ex) {
                    throw new AttachmentException(ex);
                }
            }
            session.close();
        }
        return simpleDocumentList;
    }

    @Override
    @PreventAttachmentHugeProcess
    @SimulationActionProcess(elementLister=AttachmentSimulationElementLister.class)
    @Action(value=ActionType.UPDATE)
    public void updateAttachment(@SourceObject @TargetPK SimpleDocument document, boolean indexIt, boolean notify) {
        this.normalizeFileName(document);
        try (JCRSession session = JCRSession.openSystemSession();){
            SimpleDocument oldAttachment = this.repository.findDocumentById((Session)session, document.getPk(), document.getLanguage());
            this.repository.fillNodeName((Session)session, document);
            this.repository.updateDocument((Session)session, document, true);
            if (!oldAttachment.isVersioned() && document.isOpenOfficeCompatible() && document.isEdited()) {
                if (!oldAttachment.getFilename().equals(document.getFilename())) {
                    this.webdavRepository.deleteAttachmentNode((Session)session, oldAttachment);
                    this.webdavRepository.createAttachmentNode((Session)session, document);
                } else {
                    this.webdavRepository.updateAttachmentBinaryContent((Session)session, document);
                }
            }
            session.save();
            String userId = document.getUpdatedBy();
            if (StringUtil.isDefined((String)userId) && this.reallyNotifying(document, notify)) {
                this.notificationService.notifyEventOn(ResourceEvent.Type.UPDATE, new SimpleDocument[]{oldAttachment, document});
                SimpleDocumentServiceContext.unlockMustNotNotifyUpdateIntoRequestContext(document);
            }
            if (indexIt) {
                this.createIndex(document);
            }
        }
        catch (IOException | RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    @Override
    @PreventAttachmentHugeProcess
    @SimulationActionProcess(elementLister=AttachmentSimulationElementLister.class)
    @Action(value=ActionType.UPDATE)
    public void updateAttachment(@SourceObject @TargetPK SimpleDocument document, InputStream in, boolean indexIt, boolean notify) {
        this.normalizeFileName(document);
        try (JCRSession session = JCRSession.openSystemSession();){
            String owner = document.getEditedBy();
            if (!StringUtil.isDefined((String)owner)) {
                owner = document.getUpdatedBy();
            }
            boolean checkinRequired = this.repository.checkout((Session)session, document, owner);
            SimpleDocument docBeforeUpdate = this.repository.findDocumentById((Session)session, document.getPk(), document.getLanguage());
            this.repository.updateDocument((Session)session, document, true);
            this.repository.addContent((Session)session, document.getPk(), document.getAttachment());
            this.repository.fillNodeName((Session)session, document);
            SimpleDocument finalDocument = document;
            if (checkinRequired) {
                finalDocument = this.repository.checkin((Session)session, document, false);
            }
            this.repository.storeContent(finalDocument, in, true);
            if (document.isOpenOfficeCompatible() && finalDocument.isEdited()) {
                this.webdavRepository.updateNodeAttachment((Session)session, finalDocument);
            }
            this.repository.duplicateContent(document, finalDocument);
            session.save();
            String userId = finalDocument.getUpdatedBy();
            if (StringUtil.isDefined((String)userId) && this.reallyNotifying(finalDocument, notify) && finalDocument.isPublic()) {
                this.notificationService.notifyEventOn(ResourceEvent.Type.UPDATE, new SimpleDocument[]{docBeforeUpdate, document});
                SimpleDocumentServiceContext.unlockMustNotNotifyUpdateIntoRequestContext(document);
            }
            if (indexIt) {
                this.createIndex(finalDocument);
            }
        }
        catch (IOException | RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    @Override
    @PreventAttachmentHugeProcess
    public void removeContent(@SourceObject SimpleDocument document, String lang, boolean notify) {
        try (JCRSession session = JCRSession.openSystemSession();){
            boolean requireLock = this.repository.checkout((Session)session, document, document.getEditedBy());
            boolean existsOtherContents = this.repository.removeContent((Session)session, document.getPk(), lang);
            if (document.isOpenOfficeCompatible() && document.isEdited()) {
                this.webdavRepository.deleteAttachmentContentNode((Session)session, document, lang);
            }
            this.deleteIndex(document, document.getLanguage());
            session.save();
            String userId = document.getCreatedBy();
            if (StringUtil.isDefined((String)userId) && this.reallyNotifying(document, notify)) {
                if (existsOtherContents) {
                    this.notificationService.notifyEventOn(ResourceEvent.Type.UPDATE, new SimpleDocument[]{document, document});
                    SimpleDocumentServiceContext.unlockMustNotNotifyUpdateIntoRequestContext(document);
                } else {
                    this.notificationService.notifyEventOn(ResourceEvent.Type.DELETION, new SimpleDocument[]{document});
                }
            }
            SimpleDocument finalDocument = document;
            if (requireLock) {
                finalDocument = this.repository.checkinFromContentDeletion((Session)session, document);
                if (existsOtherContents) {
                    this.repository.duplicateContent(document, finalDocument);
                }
            }
            finalDocument.setLanguage(lang);
            File fileToDelete = !existsOtherContents ? new File(finalDocument.getDirectoryPath(null)).getParentFile().getParentFile() : new File(finalDocument.getAttachmentPath()).getParentFile();
            FileUtils.deleteQuietly((File)fileToDelete);
            FileUtil.deleteEmptyDir(fileToDelete.getParentFile());
        }
        catch (IOException | RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    @Override
    @PreventAttachmentHugeProcess
    public SimpleDocumentPK cloneDocument(@SourceObject SimpleDocument original, String foreignCloneId) {
        SimpleDocumentPK simpleDocumentPK;
        block8: {
            JCRSession session = JCRSession.openSystemSession();
            try {
                SimpleDocumentPK clonePk = this.repository.copyDocument((Session)session, original, new ResourceReference(foreignCloneId, original.getInstanceId()));
                SimpleDocument clone = this.repository.findDocumentById((Session)session, clonePk, null);
                this.repository.copyMultilangContent(original, clone);
                this.repository.setClone((Session)session, original, clone);
                session.save();
                simpleDocumentPK = clonePk;
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RepositoryException ex) {
                    throw new AttachmentException(ex);
                }
            }
            session.close();
        }
        return simpleDocumentPK;
    }

    @Override
    @PreventAttachmentHugeProcess
    @SimulationActionProcess(elementLister=AttachmentSimulationElementLister.class)
    @Action(value=ActionType.COPY)
    public SimpleDocumentPK copyDocument(@SourceObject SimpleDocument original, @TargetPK ResourceReference targetResource) {
        SimpleDocumentPK simpleDocumentPK;
        block10: {
            JCRSession session = JCRSession.openSystemSession();
            try {
                SimpleDocumentPK copyPk = original instanceof HistorisedDocument ? this.repository.copyDocument((Session)session, (HistorisedDocument)original, targetResource) : this.repository.copyDocument((Session)session, original, targetResource);
                session.save();
                SimpleDocument copy = this.repository.findDocumentById((Session)session, copyPk, null);
                if (original.isVersioned()) {
                    this.repository.copyFullContent(original, copy);
                } else {
                    this.repository.copyMultilangContent(original, copy);
                }
                simpleDocumentPK = copyPk;
                if (session == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RepositoryException ex) {
                    throw new AttachmentException(ex);
                }
            }
            session.close();
        }
        return simpleDocumentPK;
    }

    @Override
    @PreventAttachmentHugeProcess
    @SimulationActionProcess(elementLister=AttachmentSimulationElementLister.class)
    @Action(value=ActionType.COPY)
    public List<Pair<SimpleDocumentPK, SimpleDocumentPK>> copyAllDocuments(@SourcePK ResourceReference sourceResource, @TargetPK ResourceReference destinationResource) {
        return this.listAllDocumentsByForeignKey(sourceResource, null).stream().map(s -> {
            SimpleDocumentPK copyPK = this.copyDocument((SimpleDocument)s, new ResourceReference((WAPrimaryKey)destinationResource));
            return Pair.of((Object)((Object)s.getPk()), (Object)((Object)copyPK));
        }).collect(Collectors.toList());
    }

    @Override
    public void reorderAttachments(List<SimpleDocumentPK> pks) {
        try (JCRSession session = JCRSession.openSystemSession();){
            ArrayList<SimpleDocument> list = new ArrayList<SimpleDocument>();
            for (SimpleDocumentPK pk : pks) {
                list.add(this.repository.findDocumentById((Session)session, pk, null));
            }
            AttachmentHugeProcessManager attachmentHugeProcessManager = AttachmentHugeProcessManager.get();
            list.stream().map(SimpleDocument::getInstanceId).distinct().forEach(attachmentHugeProcessManager::checkNoOneIsRunningOnInstance);
            this.reorderDocuments(session, list);
            session.save();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    @Override
    public void reorderDocuments(List<SimpleDocument> documents) {
        AttachmentHugeProcessManager attachmentHugeProcessManager = AttachmentHugeProcessManager.get();
        documents.stream().map(SimpleDocument::getInstanceId).distinct().forEach(attachmentHugeProcessManager::checkNoOneIsRunningOnInstance);
        try (JCRSession session = JCRSession.openSystemSession();){
            this.reorderDocuments(session, documents);
            session.save();
        }
        catch (RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    private void reorderDocuments(JCRSession session, List<SimpleDocument> documents) throws RepositoryException {
        int i;
        if (AttachmentSettings.listFromYoungestToOldestAdd()) {
            boolean isYoungestToOldestSorted = true;
            for (int y = 1; isYoungestToOldestSorted && y < documents.size(); ++y) {
                SimpleDocument previous = documents.get(y - 1);
                SimpleDocument current = documents.get(y);
                isYoungestToOldestSorted = previous.getOldSilverpeasId() > current.getOldSilverpeasId();
            }
            if (isYoungestToOldestSorted) {
                i = 1;
                Collections.reverse(documents);
            } else {
                i = 200000;
            }
        } else {
            i = 1;
        }
        for (SimpleDocument doc : documents) {
            doc.setOrder(i);
            this.repository.setOrder((Session)session, doc);
            ++i;
        }
    }

    @Override
    public void getBinaryContent(OutputStream output, SimpleDocumentPK pk, String lang) {
        this.getBinaryContent(output, pk, lang, 0L, -1L);
    }

    @Override
    public void getBinaryContent(OutputStream output, SimpleDocumentPK pk, String lang, long contentOffset, long contentLength) {
        try (JCRSession session = JCRSession.openSystemSession();
             InputStream in = this.repository.getContent((Session)session, pk, lang);){
            IOUtils.copyLarge((InputStream)in, (OutputStream)output, (long)contentOffset, (long)contentLength);
        }
        catch (IOException | RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    @Override
    public List<SimpleDocument> listDocumentsRequiringWarning(Date alertDate, String language) {
        List<SimpleDocument> list;
        block8: {
            JCRSession session = JCRSession.openSystemSession();
            try {
                list = this.repository.listDocumentsRequiringWarning((Session)session, alertDate, language);
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException ex) {
                    throw new AttachmentException(ex);
                }
            }
            session.close();
        }
        return list;
    }

    @Override
    public List<SimpleDocument> listExpiringDocuments(Date expiryDate, String language) {
        List<SimpleDocument> list;
        block8: {
            JCRSession session = JCRSession.openSystemSession();
            try {
                list = this.repository.listExpiringDocuments((Session)session, expiryDate, language);
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException ex) {
                    throw new AttachmentException(ex);
                }
            }
            session.close();
        }
        return list;
    }

    @Override
    public List<SimpleDocument> listDocumentsToUnlock(Date expiryDate, String language) {
        List<SimpleDocument> list;
        block8: {
            JCRSession session = JCRSession.openSystemSession();
            try {
                list = this.repository.listDocumentsToUnlock((Session)session, expiryDate, language);
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException ex) {
                    throw new AttachmentException(ex);
                }
            }
            session.close();
        }
        return list;
    }

    @Override
    @PreventAttachmentHugeProcess
    @SimulationActionProcess(elementLister=AttachmentSimulationElementLister.class)
    @Action(value=ActionType.UPDATE)
    public void updateAttachment(@SourceObject @TargetPK SimpleDocument document, File content, boolean indexIt, boolean notify) {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(content));){
            this.updateAttachment(document, in, indexIt, notify);
        }
        catch (IOException ex) {
            throw new AttachmentException(ex);
        }
    }

    @Override
    public void getBinaryContent(File file, SimpleDocumentPK pk, String lang) {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            this.getBinaryContent(out, pk, lang);
        }
        catch (IOException ex) {
            throw new AttachmentException(ex);
        }
    }

    @Override
    @PreventAttachmentHugeProcess
    @SimulationActionProcess(elementLister=AttachmentSimulationElementLister.class)
    @Action(value=ActionType.CREATE)
    public SimpleDocument createAttachment(@SourceObject @TargetPK SimpleDocument document, File content) {
        return this.createAttachment(document, content, true);
    }

    @Override
    @PreventAttachmentHugeProcess
    @SimulationActionProcess(elementLister=AttachmentSimulationElementLister.class)
    @Action(value=ActionType.CREATE)
    public SimpleDocument createAttachment(@SourceObject @TargetPK SimpleDocument document, File content, boolean indexIt) {
        return this.createAttachment(document, content, indexIt, true);
    }

    @Override
    @PreventAttachmentHugeProcess
    @SimulationActionProcess(elementLister=AttachmentSimulationElementLister.class)
    @Action(value=ActionType.CREATE)
    public SimpleDocument createAttachment(@SourceObject @TargetPK SimpleDocument document, File content, boolean indexIt, boolean notify) {
        SimpleDocument simpleDocument;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(content));
        try {
            simpleDocument = this.createAttachment(document, in, indexIt, notify);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new AttachmentException(ex);
            }
        }
        ((InputStream)in).close();
        return simpleDocument;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean unlock(UnlockContext context) {
        try (JCRSession session = JCRSession.openSystemSession();){
            String userId;
            boolean updateOfficeContentFromWebDav;
            boolean restorePreviousVersion = context.isForce();
            String contentLanguage = I18NHelper.checkLanguage(context.getLang());
            SimpleDocument document = this.repository.findDocumentById((Session)session, new SimpleDocumentPK(context.getAttachmentId()), contentLanguage);
            AttachmentHugeProcessManager.get().checkNoOneIsRunningOnInstance(document.getInstanceId());
            SimpleDocument docBeforeUpdate = new SimpleDocument(document);
            contentLanguage = document.getLanguage();
            boolean bl = updateOfficeContentFromWebDav = document.isOpenOfficeCompatible() && !context.isUpload() && context.isWebdav();
            if (updateOfficeContentFromWebDav && !contentLanguage.equals(StringUtil.defaultStringIfNotDefined((String)document.getWebdavContentEditionLanguage(), (String)contentLanguage))) {
                contentLanguage = document.getWebdavContentEditionLanguage();
                document = this.repository.findDocumentById((Session)session, new SimpleDocumentPK(context.getAttachmentId()), contentLanguage);
            }
            if (!this.canBeCheckedIn(context, session, document)) {
                boolean bl2 = false;
                return bl2;
            }
            boolean notify = this.prepareDocumentForCheckin(context, document, updateOfficeContentFromWebDav);
            this.checkinDocumentInRepo(session, context, document, restorePreviousVersion, updateOfficeContentFromWebDav);
            if (document.isPublic() && StringUtil.isDefined((String)(userId = context.getUserId())) && this.reallyNotifying(document, notify)) {
                this.notificationService.notifyEventOn(ResourceEvent.Type.UPDATE, new SimpleDocument[]{docBeforeUpdate, document});
            }
            this.notificationService.notifyEventOn(ResourceEvent.Type.UNLOCK, new SimpleDocument[]{docBeforeUpdate, document});
            return true;
        }
        catch (IOException | RepositoryException e) {
            throw new AttachmentException("Check-in failed", e);
        }
    }

    private void checkinDocumentInRepo(JCRSession session, UnlockContext context, SimpleDocument document, boolean restorePreviousVersion, boolean updateOfficeContentFromWebDav) throws RepositoryException, IOException {
        SimpleDocument finalDocument = this.repository.checkin((Session)session, document, restorePreviousVersion);
        if (updateOfficeContentFromWebDav) {
            this.webdavRepository.updateAttachmentBinaryContent((Session)session, finalDocument);
            this.webdavRepository.deleteAttachmentNode((Session)session, finalDocument);
            this.repository.duplicateContent(document, finalDocument);
        } else if (finalDocument.isOpenOfficeCompatible() && (context.isUpload() || !context.isWebdav())) {
            this.webdavRepository.deleteAttachmentNode((Session)session, finalDocument);
        } else {
            File file = new File(finalDocument.getAttachmentPath());
            if (!file.exists() && !context.isForce()) {
                this.repository.duplicateContent(document, finalDocument);
            }
        }
        session.save();
    }

    private boolean prepareDocumentForCheckin(UnlockContext context, SimpleDocument document, boolean updateOfficeContentFromWebDav) {
        boolean notify = false;
        if (context.isWebdav() || context.isUpload()) {
            document.setLastUpdateDate(new Date());
            document.setUpdatedBy(StringUtil.defaultStringIfNotDefined((String)document.getEditedBy(), (String)context.getUserId()));
            notify = SimpleDocumentServiceContext.canUnlockNotifyUpdateFromRequestContext(document);
        }
        document.setPublicDocument(context.isPublicVersion());
        document.setComment(context.getComment());
        if (updateOfficeContentFromWebDav) {
            document.setSize(document.getWebdavContentEditionSize());
        }
        return notify;
    }

    private boolean canBeCheckedIn(UnlockContext context, JCRSession session, SimpleDocument document) throws RepositoryException {
        if (document.isOpenOfficeCompatible() && !context.isForce() && this.webdavRepository.isNodeLocked((Session)session, document)) {
            return context.getUserId().equals(document.getEditedBy());
        }
        return context.isForce() || !document.isEdited() || document.getEditedBy().equals(context.getUserId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean lock(String attachmentId, String userId, String language) {
        try (JCRSession session = JCRSession.openSystemSession();){
            SimpleDocumentPK pk = new SimpleDocumentPK(attachmentId);
            SimpleDocument document = this.repository.findDocumentById((Session)session, pk, language);
            AttachmentHugeProcessManager.get().checkNoOneIsRunningOnInstance(document.getInstanceId());
            if (document.isEdited()) {
                boolean bl2 = document.getEditedBy().equals(userId);
                return bl2;
            }
            this.repository.checkout((Session)session, document, userId);
            document.edit(userId);
            if (document.isOpenOfficeCompatible()) {
                this.webdavRepository.createAttachmentNode((Session)session, document);
            }
            SimpleDocument oldAttachment = this.repository.findDocumentById((Session)session, document.getPk(), document.getLanguage());
            this.repository.updateDocument((Session)session, document, false);
            if (document.isOpenOfficeCompatible() && document.isEdited()) {
                if (!oldAttachment.getFilename().equals(document.getFilename())) {
                    this.webdavRepository.deleteAttachmentNode((Session)session, oldAttachment);
                    this.webdavRepository.createAttachmentNode((Session)session, document);
                } else {
                    this.webdavRepository.updateNodeAttachment((Session)session, document);
                }
            }
            session.save();
            boolean bl = true;
            return bl;
        }
        catch (IOException | RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    @Override
    @PreventAttachmentHugeProcess
    public SimpleDocumentPK changeVersionState(@SourcePK SimpleDocumentPK pk, String comment) {
        SimpleDocumentPK simpleDocumentPK;
        block8: {
            JCRSession session = JCRSession.openSystemSession();
            try {
                SimpleDocumentPK updatedPk = this.repository.changeVersionState((Session)session, pk, comment);
                session.save();
                simpleDocumentPK = updatedPk;
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RepositoryException ex) {
                    throw new AttachmentException(ex);
                }
            }
            session.close();
        }
        return simpleDocumentPK;
    }

    @Override
    public SimpleDocument findExistingDocument(SimpleDocumentPK pk, String fileName, ResourceReference foreign, String lang) {
        Function<SimpleDocument, String> getLanguageForCompare = d -> {
            String language = d.getAttachment().getLanguage();
            if (language.equals(lang)) {
                return "0";
            }
            if (I18NHelper.DEFAULT_LANGUAGE.equals(language)) {
                return "1";
            }
            return language;
        };
        return Optional.ofNullable(this.searchDocumentById(pk, lang)).orElseGet(() -> this.listDocumentsByForeignKey(foreign, lang).stream().sorted(Comparator.comparing(getLanguageForCompare)).filter(d -> d.getFilename().equalsIgnoreCase(fileName)).findFirst().orElse(null));
    }

    @Override
    public SimpleDocumentList<SimpleDocument> listDocumentsByForeignKeyAndType(ResourceReference foreignKey, DocumentType type, String lang) {
        SimpleDocumentList<SimpleDocument> simpleDocumentList;
        block8: {
            JCRSession session = JCRSession.openSystemSession();
            try {
                SimpleDocumentList<SimpleDocument> documents = this.repository.listDocumentsByForeignIdAndType((Session)session, foreignKey.getInstanceId(), foreignKey.getId(), type, lang);
                documents.sortYoungestToOldestAddIfEnabled();
                simpleDocumentList = documents;
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException ex) {
                    throw new AttachmentException(ex);
                }
            }
            session.close();
        }
        return simpleDocumentList;
    }

    @Override
    public List<SimpleDocument> listDocumentsLockedByUser(String usedId, String language) {
        List<SimpleDocument> list;
        block8: {
            JCRSession session = JCRSession.openSystemSession();
            try {
                List<SimpleDocument> documents = this.repository.listDocumentsLockedByUser((Session)session, usedId, language);
                documents.sort((o1, o2) -> o2.getLastUpdateDate().compareTo(o1.getLastUpdateDate()));
                list = documents;
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException ex) {
                    throw new AttachmentException(ex);
                }
            }
            session.close();
        }
        return list;
    }

    @Override
    @PreventAttachmentHugeProcess
    @SimulationActionProcess(elementLister=AttachmentSimulationElementLister.class)
    @Action(value=ActionType.MOVE)
    public SimpleDocumentPK moveDocument(@SourceObject SimpleDocument document, @TargetPK ResourceReference destination) {
        SimpleDocumentPK simpleDocumentPK;
        block9: {
            JCRSession session = JCRSession.openSystemSession();
            try {
                SimpleDocumentPK pk = this.repository.moveDocument((Session)session, document, destination);
                SimpleDocument moveDoc = this.repository.findDocumentById((Session)session, pk, null);
                this.repository.moveFullContent(document, moveDoc);
                if (moveDoc.isOpenOfficeCompatible()) {
                    this.webdavRepository.moveNodeAttachment((Session)session, document, destination.getInstanceId());
                }
                session.save();
                simpleDocumentPK = pk;
                if (session == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RepositoryException ex) {
                    throw new AttachmentException(ex);
                }
            }
            session.close();
        }
        return simpleDocumentPK;
    }

    @Override
    @PreventAttachmentHugeProcess
    @SimulationActionProcess(elementLister=AttachmentSimulationElementLister.class)
    @Action(value=ActionType.MOVE)
    public List<SimpleDocumentPK> moveAllDocuments(@SourcePK ResourceReference sourceResource, @TargetPK ResourceReference destinationResource) {
        ArrayList<SimpleDocumentPK> movedDocumentKeys = new ArrayList<SimpleDocumentPK>();
        SimpleDocumentList<SimpleDocument> documentsToMove = this.listAllDocumentsByForeignKey(sourceResource, null);
        for (SimpleDocument documentToMove : documentsToMove) {
            movedDocumentKeys.add(this.moveDocument(documentToMove, new ResourceReference((WAPrimaryKey)destinationResource)));
        }
        return movedDocumentKeys;
    }

    @Override
    public void updateIndexEntryWithDocuments(FullIndexEntry indexEntry) {
        if (!(indexEntry.getObjectType().startsWith(ATTACHMENT_TYPE) || indexEntry.getObjectType().startsWith(COMMENT_TYPE) || indexEntry.getObjectType().startsWith(NODE_TYPE))) {
            ResourceReference pk = new ResourceReference(indexEntry.getObjectId(), indexEntry.getComponent());
            String lang = indexEntry.getLang();
            SimpleDocumentList<SimpleDocument> documents = this.listDocumentsByForeignKey(pk, lang);
            boolean indexFileContent = this.settings.getBoolean("attachment.index.incorporated", true);
            for (SimpleDocument currentDocument : documents) {
                SimpleDocument lastPublicVersion = currentDocument.getLastPublicVersion();
                if (lastPublicVersion == null) continue;
                indexEntry.addTextContent(lastPublicVersion.getTitle(), lang);
                indexEntry.addTextContent(lastPublicVersion.getDescription(), lang);
                indexEntry.addTextContent(lastPublicVersion.getFilename(), lang);
                if (!indexFileContent) continue;
                indexEntry.addFileContent(lastPublicVersion.getAttachmentPath(), Charsets.UTF_8.name(), lastPublicVersion.getContentType(), lang);
            }
        }
    }

    @Override
    public void indexAllDocuments(ResourceReference resource, Date startOfVisibilityPeriod, Date endOfVisibilityPeriod) {
        SimpleDocumentList<SimpleDocument> documents = this.listAllDocumentsByForeignKey(resource, null);
        for (SimpleDocument currentDocument : documents) {
            this.createIndex(currentDocument, startOfVisibilityPeriod, endOfVisibilityPeriod);
        }
    }

    @Override
    @PreventAttachmentHugeProcess
    public Map<String, String> mergeDocuments(@SourcePK ResourceReference originalResource, @TargetPK ResourceReference clonedResource, DocumentType type) {
        HashMap<String, String> hashMap;
        block12: {
            JCRSession session = JCRSession.openSystemSession();
            try {
                SimpleDocumentList<SimpleDocument> attachments = this.listDocumentsByForeignKeyAndType(originalResource, type, null);
                Map<String, SimpleDocument> clones = this.listDocumentsOfClone(clonedResource, type);
                HashMap<String, String> ids = new HashMap<String, String>(clones.size());
                for (SimpleDocument attachment : attachments) {
                    if (clones.containsKey(attachment.getId())) {
                        SimpleDocument clone = clones.get(attachment.getId());
                        this.repository.mergeAttachment((Session)session, attachment, clone);
                        this.repository.copyMultilangContent(clone, attachment);
                        this.repository.deleteDocument((Session)session, clone.getPk());
                        ids.put(clone.getId(), attachment.getId());
                        clones.remove(attachment.getId());
                        continue;
                    }
                    this.deleteAttachment((Session)session, attachment, true);
                }
                if (!clones.isEmpty()) {
                    for (SimpleDocument clone : clones.values()) {
                        clone.setCloneId(null);
                        clone.setForeignId(originalResource.getId());
                        this.updateAttachment(clone, false, false);
                    }
                }
                session.save();
                hashMap = ids;
                if (session == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RepositoryException ex) {
                    throw new AttachmentException(ex);
                }
            }
            session.close();
        }
        return hashMap;
    }

    private Map<String, SimpleDocument> listDocumentsOfClone(ResourceReference resourceReference, DocumentType type) {
        SimpleDocumentList<SimpleDocument> documents = this.listDocumentsByForeignKeyAndType(resourceReference, type, null);
        HashMap<String, SimpleDocument> result = new HashMap<String, SimpleDocument>(documents.size());
        for (SimpleDocument doc : documents) {
            if (StringUtil.isDefined((String)doc.getCloneId())) {
                result.put(doc.getCloneId(), doc);
                continue;
            }
            result.put(doc.getId(), doc);
        }
        return result;
    }

    @Override
    @AttachmentHugeProcess
    public void switchComponentBehaviour(@SourceObject String componentId, boolean versioned) {
        try (JCRSession session = JCRSession.openSystemSession();){
            List<SimpleDocument> attachments = this.repository.listDocumentsByComponentIdAndType((Session)session, componentId, DocumentType.attachment, I18NHelper.DEFAULT_LANGUAGE);
            for (SimpleDocument attachment : attachments) {
                if (attachment.isVersioned() == versioned) continue;
                this.repository.changeVersionState((Session)session, attachment.getPk(), "");
            }
            session.save();
        }
        catch (IOException | RepositoryException ex) {
            throw new AttachmentException(ex);
        }
    }

    @Override
    @PreventAttachmentHugeProcess
    public void switchAllowingDownloadForReaders(@SourcePK SimpleDocumentPK pk, boolean allowing) {
        SimpleDocument document = this.searchDocumentById(pk, null);
        boolean documentUpdateRequired = allowing ? document.addRolesForWhichDownloadIsAllowed(SilverpeasRole.READER_ROLES) : document.addRolesForWhichDownloadIsForbidden(SilverpeasRole.READER_ROLES);
        if (documentUpdateRequired) {
            try (JCRSession session = JCRSession.openSystemSession();){
                this.repository.saveForbiddenDownloadForRoles((Session)session, document);
                session.save();
            }
            catch (RepositoryException ex) {
                throw new AttachmentException(ex);
            }
        }
    }

    @Override
    @PreventAttachmentHugeProcess
    public void switchEnableDisplayAsContent(@SourcePK SimpleDocumentPK pk, boolean enable) {
        boolean documentUpdateRequired;
        SimpleDocument document = this.searchDocumentById(pk, null);
        boolean bl = documentUpdateRequired = enable != document.isDisplayableAsContent();
        if (documentUpdateRequired) {
            document.setDisplayableAsContent(enable);
            try (JCRSession session = JCRSession.openSystemSession();){
                this.repository.saveDisplayableAsContent((Session)session, document);
                session.save();
            }
            catch (RepositoryException ex) {
                throw new AttachmentException(ex);
            }
        }
    }

    @Override
    @PreventAttachmentHugeProcess
    public void switchEnableEditSimultaneously(@SourcePK SimpleDocumentPK pk, boolean enable) {
        SimpleDocument document = this.searchDocumentById(pk, null);
        document.editableSimultaneously().ifPresent(e -> {
            boolean documentUpdateRequired;
            boolean bl = documentUpdateRequired = enable != e;
            if (documentUpdateRequired) {
                document.setEditableSimultaneously(enable);
                try (JCRSession session = JCRSession.openSystemSession();){
                    this.repository.saveEditableSimultaneously((Session)session, document);
                    session.save();
                }
                catch (RepositoryException ex) {
                    throw new AttachmentException(ex);
                }
            }
        });
    }

    private boolean reallyNotifying(SimpleDocument document, boolean requestedNotify) {
        if (document.getDocumentType() == DocumentType.image) {
            return false;
        }
        return requestedNotify;
    }

    @Override
    public void delete(String componentInstanceId) {
        this.deleteAllAttachments(componentInstanceId);
    }

    private void normalizeFileName(SimpleDocument document) {
        String normalizedFileName = StringUtil.normalize((String)document.getFilename());
        document.setFilename(normalizedFileName);
    }
}

