/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.domain.DomainDriverManager;
import org.silverpeas.core.admin.domain.synchro.SynchroDomainReport;
import org.silverpeas.core.admin.persistence.GroupUserRoleRow;
import org.silverpeas.core.admin.persistence.GroupUserRoleTable;
import org.silverpeas.core.admin.persistence.OrganizationSchema;
import org.silverpeas.core.admin.persistence.SpaceUserRoleRow;
import org.silverpeas.core.admin.persistence.UserRoleRow;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.UserAlreadyExistsAdminException;
import org.silverpeas.core.admin.space.UserFavoriteSpaceService;
import org.silverpeas.core.admin.space.UserFavoriteSpaceServiceProvider;
import org.silverpeas.core.admin.space.dao.SpaceDAO;
import org.silverpeas.core.admin.space.model.UserFavoriteSpaceVO;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.dao.GroupDAO;
import org.silverpeas.core.admin.user.dao.UserDAO;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserDetailsSearchCriteria;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.admin.user.notification.UserEventNotifier;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.notification.user.delayed.delegate.DelayedNotificationDelegate;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.security.encryption.X509Factory;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
@Transactional(value=Transactional.TxType.MANDATORY)
public class UserManager {
    private static final String USERMANAGER_SYNCHRO_REPORT = "UserManager";
    private static final String IN_DOMAIN = "in domain ";
    private static final String ALL_USERS = "all users";
    private static final String SPECIFIC_ID = "(specificId:";
    private static final String USER_TABLE_RESTORE_USER = "UserTable.restoreUser()";
    private static final String USER_TABLE_REMOVE_USER = "UserTable.removeUser()";
    private static final String AWAITING_DELETION_MESSAGE = "En attente de suppression de ";
    private static final String REMOVING_MESSAGE = "Suppression de ";
    private static final String ID_PART = " (ID=";
    @Inject
    private UserDAO userDAO;
    @Inject
    private GroupDAO groupDAO;
    @Inject
    private SpaceDAO spaceDAO;
    @Inject
    private UserEventNotifier notifier;
    @Inject
    private DomainDriverManager domainDriverManager;
    @Inject
    private OrganizationSchema organizationSchema;

    protected UserManager() {
    }

    public static UserManager get() {
        return (UserManager)ServiceProvider.getService(UserManager.class, (Annotation[])new Annotation[0]);
    }

    public int getUserCount() throws AdminException {
        int n;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                n = this.userDAO.getUserCountByCriteria(connection, new UserDetailsSearchCriteria().onUserStatesToExclude(UserState.REMOVED));
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"total user count", (Object)""), e);
                }
            }
            connection.close();
        }
        return n;
    }

    public UserDetail[] getAllUsersInGroups(List<String> groupIds) throws AdminException {
        UserDetail[] userDetailArray;
        block9: {
            if (groupIds == null || groupIds.isEmpty()) {
                return new UserDetail[0];
            }
            Connection connection = DBUtil.openConnection();
            try {
                List<UserDetail> users = this.userDAO.getUsersInGroups(connection, groupIds);
                userDetailArray = users.toArray(new UserDetail[0]);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"users in groups", (Object)String.join((CharSequence)", ", groupIds)), e);
                }
            }
            connection.close();
        }
        return userDetailArray;
    }

    public ListSlice<UserDetail> getUsersMatchingCriteria(UserDetailsSearchCriteria criteria) throws AdminException {
        ListSlice<UserDetail> listSlice;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                listSlice = this.userDAO.getUsersByCriteria(connection, criteria);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"users matching some criteria", (Object)""), e);
                }
            }
            connection.close();
        }
        return listSlice;
    }

    public List<String> getAllUserIdsInGroups(List<String> groupIds) throws AdminException {
        List<String> list;
        block9: {
            if (groupIds == null || groupIds.isEmpty()) {
                return new ArrayList<String>(0);
            }
            Connection connection = DBUtil.openConnection();
            try {
                list = this.userDAO.getUserIdsInGroups(connection, groupIds);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"users in groups", (Object)String.join((CharSequence)", ", groupIds)), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<String> getDirectUserIdsInRole(String roleId, boolean includeRemoved) throws AdminException {
        List<String> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.userDAO.getUserIdsByUserRole(connection, roleId, includeRemoved);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"users in role", (Object)roleId), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<String> getDirectUserIdsInSpaceRole(String spaceRoleId, boolean includeRemoved) throws AdminException {
        List<String> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.userDAO.getUserIdsBySpaceUserRole(connection, spaceRoleId, includeRemoved);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"users in space role", (Object)spaceRoleId), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public UserDetail[] getAllUsersInDomain(String sDomainId, boolean includeRemoved) throws AdminException {
        UserDetail[] userDetailArray;
        block11: {
            Connection connection = DBUtil.openConnection();
            try {
                UserState[] userStateArray;
                String usersOfDomain = ".getAllUsersInDomain()";
                SynchroDomainReport.debug("UserManager.getAllUsersInDomain()", "Recherche des utilisateurs du domaine (domaine " + sDomainId + ") dans la base...");
                if (includeRemoved) {
                    UserState[] userStateArray2 = new UserState[1];
                    userStateArray = userStateArray2;
                    userStateArray2[0] = UserState.DELETED;
                } else {
                    UserState[] userStateArray3 = new UserState[2];
                    userStateArray3[0] = UserState.REMOVED;
                    userStateArray = userStateArray3;
                    userStateArray3[1] = UserState.DELETED;
                }
                UserState[] userStatesToExclude = userStateArray;
                ListSlice<UserDetail> users = this.userDAO.getUsersByCriteria(connection, new UserDetailsSearchCriteria().onDomainIds(sDomainId).onUserStatesToExclude(userStatesToExclude));
                UserDetail[] usersInDomain = new UserDetail[users.size()];
                int i = 0;
                for (UserDetail u : users) {
                    usersInDomain[i++] = u;
                    SynchroDomainReport.debug("UserManager.getAllUsersInDomain()", "Utilisateur trouv\u00e9 no : " + i + ", login : " + u.getLogin() + ", " + u.getFirstName() + ", " + u.getLastName() + ", " + u.getEmailAddress());
                }
                SynchroDomainReport.debug("UserManager.getAllUsersInDomain()", "R\u00e9cup\u00e9ration de " + users.size() + " utilisateurs du domaine dans la base");
                userDetailArray = usersInDomain;
                if (connection == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"users in domain", (Object)sDomainId), e);
                }
            }
            connection.close();
        }
        return userDetailArray;
    }

    public List<String> getAllUserIdsInDomain(String sDomainId) throws AdminException {
        List<String> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.userDAO.getUserIdsInDomain(connection, sDomainId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"users in domain", (Object)sDomainId), e);
                }
            }
            connection.close();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getUserIdsByAccessLevel(UserAccessLevel accessLevel) throws AdminException {
        try (Connection connection = DBUtil.openConnection();){
            List<String> userIds = this.userDAO.getUserIdsByAccessLevel(connection, accessLevel);
            if (userIds.isEmpty()) {
                String[] stringArray2 = ArrayUtil.emptyStringArray();
                return stringArray2;
            }
            String[] stringArray = userIds.toArray(new String[0]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"users with access level ", (Object)accessLevel.getName()), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getUserIdsByDomainAndByAccessLevel(String sDomainId, UserAccessLevel accessLevel) throws AdminException {
        try (Connection connection = DBUtil.openConnection();){
            List<String> userIds = this.userDAO.getUserIdsByAccessLevelInDomain(connection, accessLevel, sDomainId);
            if (userIds.isEmpty()) {
                String[] stringArray2 = ArrayUtil.emptyStringArray();
                return stringArray2;
            }
            String[] stringArray = userIds.toArray(new String[0]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)("users with access level " + accessLevel.getName()), (Object)(IN_DOMAIN + sDomainId)), e);
        }
    }

    public Integer[] getManageableSpaceIds(String sUserId, List<String> groupIds) throws AdminException {
        Integer[] integerArray;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                List<Integer> spaceIds = this.spaceDAO.getManageableSpaceIds(connection, sUserId, groupIds);
                integerArray = spaceIds.toArray(new Integer[0]);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"spaces manageable by user", (Object)sUserId), e);
                }
            }
            connection.close();
        }
        return integerArray;
    }

    public List<String> getAllUsersIds() throws AdminException {
        List<String> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.userDAO.getAllUserIds(connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)ALL_USERS, (Object)""), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public String[] getAllAdminIds(UserDetail fromUser) throws AdminException {
        String[] stringArray;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                List<String> adminIds = this.userDAO.getAllAdminIds(connection, fromUser);
                stringArray = adminIds.toArray(new String[0]);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"admin users", (Object)""), e);
                }
            }
            connection.close();
        }
        return stringArray;
    }

    public UserFull getUserFull(String sUserId) throws AdminException {
        try {
            return this.domainDriverManager.getUserFull(sUserId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"user", (Object)sUserId), e);
        }
    }

    public List<UserFull> listUserFulls(Collection<String> userIds) throws AdminException {
        try {
            return this.domainDriverManager.listUserFulls(userIds);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"users", userIds), e);
        }
    }

    public UserDetail getUserDetail(String sUserId) throws AdminException {
        UserDetail userDetail;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                userDetail = this.userDAO.getUserById(connection, sUserId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"user", (Object)sUserId), e);
                }
            }
            connection.close();
        }
        return userDetail;
    }

    public String getUserIdBySpecificIdAndDomainId(String sSpecificId, String sDomainId) throws AdminException {
        String string;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                UserDetail user = this.userDAO.getUserBySpecificId(connection, sDomainId, sSpecificId);
                String string2 = string = user != null ? user.getId() : null;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)("user with specific id " + sSpecificId), (Object)(IN_DOMAIN + sDomainId)), e);
                }
            }
            connection.close();
        }
        return string;
    }

    public List<UserDetail> getUsersBySpecificIdsAndDomainId(Collection<String> specificIds, String domainId) throws AdminException {
        List<UserDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.userDAO.getUsersBySpecificIds(connection, domainId, specificIds);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String sSpecificIds = String.join((CharSequence)", ", specificIds);
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)("users with specific ids " + sSpecificIds), (Object)(IN_DOMAIN + domainId)), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public String getUserIdByLoginAndDomain(String sLogin, String sDomainId) throws AdminException {
        String string;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                string = this.userDAO.getUserIdByLoginAndDomain(connection, sLogin, sDomainId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)("users with login " + sLogin), (Object)(IN_DOMAIN + sDomainId)), e);
                }
            }
            connection.close();
        }
        return string;
    }

    public void migrateUser(UserDetail userDetail, String targetDomainId) throws AdminException {
        if (userDetail == null || !StringUtil.isDefined((String)userDetail.getDomainId())) {
            throw new AdminException(SilverpeasExceptionMessages.undefined((String)"user"), new String[0]);
        }
        try {
            String oldDomainId = userDetail.getDomainId();
            UserFull userFull = this.getUserFull(userDetail.getId());
            userFull.setDomainId(targetDomainId);
            String specificId = this.domainDriverManager.createUser(userFull);
            userFull.setSpecificId(specificId);
            userDetail.setDomainId(targetDomainId);
            userDetail.setSpecificId(specificId);
            this.domainDriverManager.resetEncryptedPassword(userDetail, userFull.getPassword());
            userFull.setDomainId(oldDomainId);
            this.domainDriverManager.deleteUser(userFull.getId());
            userFull.setDomainId(targetDomainId);
            userFull.setSpecificId(specificId);
            this.updateUser(userFull, true);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)"user", (Object)userDetail.getId()), e);
        }
    }

    public String addUser(UserDetail userDetail, boolean addOnlyInSilverpeas, boolean indexation) throws AdminException {
        String string;
        block20: {
            String addUser = ".addUser()";
            String pbAddUser = "Probl\u00e8me lors de l'ajout de l'utilisateur ";
            if (!(userDetail != null && StringUtil.isDefined((String)userDetail.getLastName()) && StringUtil.isDefined((String)userDetail.getLogin()) && StringUtil.isDefined((String)userDetail.getDomainId()))) {
                if (userDetail == null) {
                    SynchroDomainReport.error("UserManager.addUser()", "Probl\u00e8me lors de l'ajout de l'utilisateur dans la base, cet utilisateur n'existe pas", null);
                } else if (!StringUtil.isDefined((String)userDetail.getLastName())) {
                    SynchroDomainReport.error("UserManager.addUser()", "Probl\u00e8me lors de l'ajout de l'utilisateur " + userDetail.getSpecificId() + " dans la base, cet utilisateur n'a pas de nom", null);
                } else if (!StringUtil.isDefined((String)userDetail.getLogin())) {
                    SynchroDomainReport.error("UserManager.addUser()", "Probl\u00e8me lors de l'ajout de l'utilisateur " + userDetail.getSpecificId() + " dans la base, login non sp\u00e9cifi\u00e9", null);
                } else if (!StringUtil.isDefined((String)userDetail.getDomainId())) {
                    SynchroDomainReport.error("UserManager.addUser()", "Probl\u00e8me lors de l'ajout de l'utilisateur " + userDetail.getSpecificId() + " dans la base, domaine non sp\u00e9cifi\u00e9", null);
                }
                return "";
            }
            Connection connection = DBUtil.openConnection();
            try {
                long domainActions;
                boolean isX509Enabled;
                SynchroDomainReport.debug("UserManager.addUser()", "Ajout de l'utilisateur " + userDetail.getSpecificId() + " dans la base...");
                String alreadyExistingUserId = this.userDAO.getUserIdByLoginAndDomain(connection, userDetail.getLogin(), userDetail.getDomainId());
                if (alreadyExistingUserId != null) {
                    SynchroDomainReport.error("UserManager.addUser()", "Utilisateur " + userDetail.getLogin() + " d\u00e9j\u00e0 pr\u00e9sent dans la base avec ce login. Il n'a pas \u00e9t\u00e9 rajout\u00e9", null);
                    throw new UserAlreadyExistsAdminException(userDetail);
                }
                if (!addOnlyInSilverpeas) {
                    String specificId = this.domainDriverManager.createUser(userDetail);
                    userDetail.setSpecificId(specificId);
                }
                String userId = this.userDAO.addUser(connection, userDetail);
                userDetail.setId(userId);
                this.notifier.notifyEventOn(ResourceEvent.Type.CREATION, (Serializable[])new UserDetail[]{userDetail});
                if (indexation) {
                    this.domainDriverManager.indexUser(userDetail.getId());
                }
                boolean bl = isX509Enabled = ((domainActions = this.domainDriverManager.getDomainActions(userDetail.getDomainId())) & 0x8000L) != 0L;
                if (isX509Enabled) {
                    X509Factory.getFactory().buildP12(userDetail);
                }
                string = userDetail.getId();
                if (connection == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    SynchroDomainReport.error("UserManager.addUser()", "Probl\u00e8me lors de l'ajout de l'utilisateur " + userDetail.getFirstName() + " " + userDetail.getLastName() + SPECIFIC_ID + userDetail.getSpecificId() + ") - " + e.getMessage(), null);
                    throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)"user", (Object)userDetail.getLogin()), e);
                }
            }
            connection.close();
        }
        return string;
    }

    public String restoreUser(UserDetail user, boolean indexation) throws AdminException {
        String string;
        block9: {
            String restoreUser = ".restoreUser()";
            Connection connection = DBUtil.openConnection();
            try {
                SynchroDomainReport.info("UserManager.restoreUser()", "Restauration de l'utilisateur " + user.getSpecificId());
                this.restoreUser(connection, user);
                if (indexation) {
                    this.domainDriverManager.indexUser(user.getId());
                }
                string = user.getId();
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    SynchroDomainReport.error("UserManager.restoreUser()", "probl\u00e8me \u00e0 la restauration de l'utilisateur " + user.getFirstName() + " " + user.getLastName() + SPECIFIC_ID + user.getSpecificId() + ") - " + e.getMessage(), null);
                    throw new AdminException(SilverpeasExceptionMessages.failureOnRestoring((String)"user", (Object)user.getId()), e);
                }
            }
            connection.close();
        }
        return string;
    }

    public String removeUser(UserDetail user, boolean indexation) throws AdminException {
        String string;
        block9: {
            String removeUser = ".removeUser()";
            Connection connection = DBUtil.openConnection();
            try {
                SynchroDomainReport.debug("UserManager.removeUser()", "En attente de suppression de l'utilisateur " + user.getSpecificId() + " de la base...");
                this.removeUser(connection, user);
                if (indexation) {
                    this.domainDriverManager.unindexUser(user.getId());
                }
                string = user.getId();
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    SynchroDomainReport.error("UserManager.removeUser()", "probl\u00e8me \u00e0 la mise en attente de suppression de l'utilisateur " + user.getFirstName() + " " + user.getLastName() + SPECIFIC_ID + user.getSpecificId() + ") - " + e.getMessage(), null);
                    throw new AdminException(SilverpeasExceptionMessages.failureOnRemoving((String)"user", (Object)user.getId()), e);
                }
            }
            connection.close();
        }
        return string;
    }

    public String deleteUser(UserDetail user, boolean onlyInSilverpeas) throws AdminException {
        String string;
        block10: {
            String deleteUser = ".deleteUser()";
            Connection connection = DBUtil.openConnection();
            try {
                boolean isX509Enabled;
                this.delayedNotificationOfUserDeletion(user);
                if (!onlyInSilverpeas) {
                    this.domainDriverManager.deleteUser(user.getId());
                }
                SynchroDomainReport.info("UserManager.deleteUser()", "Suppression de l'utilisateur " + user.getSpecificId() + " de la base...");
                this.deleteUser(connection, user);
                this.notifier.notifyEventOn(ResourceEvent.Type.DELETION, (Serializable[])new UserDetail[]{user});
                this.domainDriverManager.unindexUser(user.getId());
                long domainActions = this.domainDriverManager.getDomainActions(user.getDomainId());
                boolean bl = isX509Enabled = (domainActions & 0x8000L) != 0L;
                if (isX509Enabled) {
                    X509Factory.getFactory().revokeUserCertificate(user.getId());
                }
                string = user.getId();
                if (connection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    SynchroDomainReport.error("UserManager.deleteUser()", "probl\u00e8me \u00e0 la suppression de l'utilisateur " + user.getFirstName() + " " + user.getLastName() + SPECIFIC_ID + user.getSpecificId() + ") - " + e.getMessage(), null);
                    throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)"user", (Object)user.getId()), e);
                }
            }
            connection.close();
        }
        return string;
    }

    public void blankUser(UserDetail user) throws AdminException {
        if (!user.getState().equals((Object)UserState.DELETED)) {
            throw new AdminException("The user " + user.getId() + " cannot be blanked because it is not deleted!", new String[0]);
        }
        try (Connection connection = DBUtil.openConnection();){
            this.userDAO.blankUser(connection, user);
        }
        catch (SQLException e) {
            throw new AdminException("Cannot blank the user " + user.getId(), e);
        }
    }

    private void restoreUser(Connection connection, UserDetail user) throws SQLException {
        SynchroDomainReport.debug(USER_TABLE_RESTORE_USER, AWAITING_DELETION_MESSAGE + user.getLogin() + ID_PART + user.getId() + ")");
        this.userDAO.restoreUser(connection, user);
    }

    private void removeUser(Connection connection, UserDetail user) throws SQLException {
        SynchroDomainReport.debug(USER_TABLE_REMOVE_USER, AWAITING_DELETION_MESSAGE + user.getLogin() + ID_PART + user.getId() + ")");
        this.userDAO.removeUser(connection, user);
    }

    private void deleteUser(Connection connection, UserDetail user) throws SQLException {
        SpaceUserRoleRow[] spaceRoles;
        UserRoleRow[] roles;
        String userLogin = user.getLogin();
        SynchroDomainReport.debug(USER_TABLE_REMOVE_USER, REMOVING_MESSAGE + userLogin + " des groupes dans la base");
        String userId = user.getId();
        List<GroupDetail> groups = this.groupDAO.getDirectGroupsOfUser(connection, userId, true);
        for (GroupDetail group : groups) {
            this.groupDAO.deleteUserInGroup(connection, userId, group.getId());
        }
        SynchroDomainReport.debug(USER_TABLE_REMOVE_USER, REMOVING_MESSAGE + userLogin + " des r\u00f4les dans la base");
        int userIdAsInt = Integer.parseInt(userId);
        for (UserRoleRow role : roles = this.organizationSchema.userRole().getDirectUserRolesOfUser(userIdAsInt)) {
            this.organizationSchema.userRole().removeUserFromUserRole(userIdAsInt, role.getId());
        }
        SynchroDomainReport.debug(USER_TABLE_REMOVE_USER, REMOVING_MESSAGE + userLogin + " en tant que manager d'espace dans la base");
        for (SpaceUserRoleRow spaceRole : spaceRoles = this.organizationSchema.spaceUserRole().getDirectSpaceUserRolesOfUser(userIdAsInt)) {
            this.organizationSchema.spaceUserRole().removeUserFromSpaceUserRole(userIdAsInt, spaceRole.getId());
        }
        GroupUserRoleTable groupUserRoleTable = OrganizationSchema.get().groupUserRole();
        GroupUserRoleRow[] groupRoles = groupUserRoleTable.getDirectGroupUserRolesOfUser(userIdAsInt);
        SynchroDomainReport.info(USER_TABLE_REMOVE_USER, REMOVING_MESSAGE + userLogin + " en tant que manager de groupe dans la base");
        for (GroupUserRoleRow groupRole : groupRoles) {
            groupUserRoleTable.removeUserFromGroupUserRole(userIdAsInt, groupRole.id);
        }
        SynchroDomainReport.info(USER_TABLE_REMOVE_USER, "Delete " + userLogin + " from user favorite space table");
        UserFavoriteSpaceService ufsService = UserFavoriteSpaceServiceProvider.getUserFavoriteSpaceService();
        if (!ufsService.removeUserFavoriteSpace(new UserFavoriteSpaceVO(userIdAsInt, -1))) {
            throw new SQLException(SilverpeasExceptionMessages.failureOnDeleting((String)"user", (Object)userId));
        }
        SynchroDomainReport.debug(USER_TABLE_REMOVE_USER, REMOVING_MESSAGE + userLogin + ID_PART + userId + ")");
        this.userDAO.deleteUser(connection, user);
    }

    private void delayedNotificationOfUserDeletion(UserDetail user) {
        try {
            DelayedNotificationDelegate.executeUserDeleting(Integer.parseInt(user.getId()));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            SynchroDomainReport.warn("UserManager.delayedNotificationOfUserDeletion()", "probl\u00e8me d'envoi des notifications journalis\u00e9es " + user.getFirstName() + " " + user.getLastName() + SPECIFIC_ID + user.getSpecificId() + ") - " + e.getMessage());
        }
    }

    public String updateUser(UserDetail user, boolean indexation) throws AdminException {
        String string;
        block9: {
            Connection connection = DBUtil.openConnection();
            try {
                SynchroDomainReport.debug("UserManager.updateUser()", "Maj de l'utilisateur " + user.getSpecificId() + " dans la base...");
                this.userDAO.updateUser(connection, user);
                if (indexation) {
                    this.domainDriverManager.indexUser(user.getId());
                }
                string = user.getId();
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    SynchroDomainReport.error("UserManager.updateUser()", "probl\u00e8me lors de la maj de l'utilisateur " + user.getFirstName() + " " + user.getLastName() + SPECIFIC_ID + user.getSpecificId() + ") - " + e.getMessage(), null);
                    throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)"user", (Object)user.getId()), e);
                }
            }
            connection.close();
        }
        return string;
    }

    public String updateUserFull(UserFull userFull) throws AdminException {
        String string;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                this.domainDriverManager.updateUserFull(userFull);
                this.userDAO.updateUser(connection, userFull);
                string = userFull.getId();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)"user", (Object)userFull.getId()), e);
                }
            }
            connection.close();
        }
        return string;
    }

    public boolean isEmailExisting(String email) throws AdminException {
        boolean bl;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                bl = this.userDAO.isUserEmailExisting(connection, email);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.unknown((String)"user with email", (Object)email), e);
                }
            }
            connection.close();
        }
        return bl;
    }

    public List<UserDetail> getAllUsers() throws AdminException {
        List<UserDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.userDAO.getAllUsers(connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)ALL_USERS, (Object)""), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<UserDetail> getAllUsersFromNewestToOldest() throws AdminException {
        List<UserDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.userDAO.getAllUsersFromNewestToOldest(connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)ALL_USERS, (Object)""), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<UserDetail> getUsersOfDomains(List<String> domainIds) throws AdminException {
        List<UserDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.userDAO.getUsersOfDomains(connection, domainIds);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"users in domains", (Object)String.join((CharSequence)", ", domainIds)), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<UserDetail> getRemovedUsersOfDomains(String ... domainIds) throws AdminException {
        List<UserDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.userDAO.getRemovedUsers(connection, domainIds);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"deleted users in domains", (Object)String.join((CharSequence)", ", domainIds)), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<UserDetail> getNonBlankedDeletedUsersOfDomains(String ... domainIds) throws AdminException {
        List<UserDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.userDAO.getNonBlankedDeletedUsers(connection, domainIds);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"deleted users in domains", (Object)String.join((CharSequence)", ", domainIds)), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<UserDetail> getUsersWithSensitiveData(String ... domainIds) throws AdminException {
        List<UserDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.userDAO.getUsersWithSensitiveData(connection, domainIds);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"Users with sensitive data in domains", (Object)String.join((CharSequence)", ", domainIds)), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<UserDetail> getUsersOfDomainsFromNewestToOldest(List<String> domainIds) throws AdminException {
        List<UserDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.userDAO.getUsersOfDomainsFromNewestToOldest(connection, domainIds);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)ALL_USERS, (Object)""), e);
                }
            }
            connection.close();
        }
        return list;
    }
}

