/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.googledriver;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.directory.Directory;
import com.google.api.services.directory.model.User;
import com.google.api.services.directory.model.Users;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.silverpeas.core.admin.domain.driver.googledriver.GoogleUserFilter;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.kernel.logging.SilverLogger;

public class GoogleDirectoryRequester {
    private static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    private static final int QUERY_MAX_RESULTS = 500;
    private static final String MY_CUSTOMER = "my_customer";
    private final String serviceAccountUser;
    private final String jsonKeyPath;
    private final String filter;
    private static final List<String> SCOPES = Collections.singletonList("https://www.googleapis.com/auth/admin.directory.user.readonly");
    private static final String APPLICATION_NAME = "Silverpeas Google Domain Fetcher";

    GoogleDirectoryRequester(String serviceAccountUser, String jsonKeyPath, String filter) {
        this.serviceAccountUser = serviceAccountUser;
        this.jsonKeyPath = jsonKeyPath;
        this.filter = filter;
    }

    private GoogleCredentials getGoogleCredentials() throws IOException {
        ServiceAccountCredentials credentials;
        try (FileInputStream is = new FileInputStream(this.jsonKeyPath);){
            credentials = ServiceAccountCredentials.fromStream((InputStream)is);
        }
        return credentials.toBuilder().setScopes(SCOPES).setServiceAccountUser(this.serviceAccountUser).build();
    }

    private Directory getDirectoryService() throws AdminException {
        try {
            NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            HttpCredentialsAdapter requestInitializer = new HttpCredentialsAdapter((Credentials)this.getGoogleCredentials());
            return new Directory.Builder((HttpTransport)httpTransport, JSON_FACTORY, (HttpRequestInitializer)requestInitializer).setApplicationName(APPLICATION_NAME).build();
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
    }

    public List<User> users() throws AdminException {
        try {
            List currentResult;
            List<User> result = new LinkedList<User>();
            long start = System.currentTimeMillis();
            Directory.Users.List users = this.getDirectoryService().users().list().setMaxResults(Integer.valueOf(500)).setCustomer(MY_CUSTOMER).setProjection("full");
            String pageToken = null;
            do {
                Users currentUsers = (Users)users.setPageToken(pageToken).execute();
                pageToken = currentUsers.getNextPageToken();
                currentResult = currentUsers.getUsers();
                result.addAll(currentResult);
            } while (currentResult.size() >= 500 && pageToken != null);
            result = this.applyFilter(result);
            result.sort(Comparator.comparing(g -> g.getName().getFamilyName().toLowerCase()).thenComparing(g -> g.getName().getGivenName().toLowerCase()));
            long end = System.currentTimeMillis();
            SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("Getting accounts in {0}", DurationFormatUtils.formatDurationHMS((long)(end - start))));
            return result;
        }
        catch (IOException e) {
            throw new AdminException(e);
        }
    }

    private List<User> applyFilter(List<User> result) {
        return new GoogleUserFilter<User>(result, this.filter).apply();
    }

    public User user(String id) throws AdminException {
        long start = System.currentTimeMillis();
        try {
            User user = (User)this.getDirectoryService().users().get(id).execute();
            return user;
        }
        catch (IOException e) {
            throw new AdminException(e);
        }
        finally {
            long end = System.currentTimeMillis();
            SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("Getting account {0} in {1}", id, DurationFormatUtils.formatDurationHMS((long)(end - start))));
        }
    }
}

