/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container;

import java.util.logging.Logger;

public class ContainerLogger {
    private static String DEBUG_NAME = "debug";

    private ContainerLogger() {
    }

    public static Logger getLogger(Class cls, String logMessages) {
        return Logger.getLogger(ContainerLogger.getName(cls), logMessages);
    }

    public static Logger getLogger(String name) {
        return Logger.getLogger(ContainerLogger.correct(name));
    }

    private static String getName(Class cls) {
        Package pkg = cls.getPackage();
        String packageName = pkg == null ? ContainerLogger.getDefaultPkgName(cls) : pkg.getName();
        String correctName = ContainerLogger.correct(packageName);
        return correctName;
    }

    private static String getDefaultPkgName(Class cls) {
        String className = cls.getName();
        String pkgName = DEBUG_NAME;
        int index = -1;
        if (className != null) {
            index = className.lastIndexOf(".");
        }
        if (index != -1) {
            pkgName = className.substring(0, index);
        }
        return pkgName;
    }

    private static String correct(String name) {
        if (name.indexOf(DEBUG_NAME) != 0) {
            StringBuffer csuffix = new StringBuffer();
            csuffix.append(DEBUG_NAME);
            csuffix.append(".");
            csuffix.append(name);
            return csuffix.toString();
        }
        return name;
    }
}

