/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.service.util;

import java.io.IOException;
import java.io.Reader;
import javax.enterprise.inject.Alternative;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.silverpeas.components.mailinglist.service.util.HtmlCleaner;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.kernel.annotation.Technical;

@Alternative
@Technical
@Bean
public class Html2Text
extends HTMLEditorKit.ParserCallback
implements HtmlCleaner {
    private StringBuilder texte = new StringBuilder(1024);
    private boolean register = false;
    private int inScript = 0;
    private boolean hasError = false;
    private boolean isFormatTag = false;
    private int maxSize = 150;

    public Html2Text() {
    }

    public Html2Text(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public void setSummarySize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        this.hasError = false;
        if (!this.register) {
            this.register = HTML.Tag.BODY.equals(t);
        }
        if (HTML.Tag.SCRIPT.equals(t)) {
            this.register = false;
            ++this.inScript;
        }
        if (HTML.Tag.META.equals(t) || HTML.Tag.OPTION.equals(t) || HTML.Tag.LINK.equals(t)) {
            this.register = false;
        }
        if (HTML.Tag.I.equals(t) || HTML.Tag.B.equals(t) || HTML.Tag.BIG.equals(t) || HTML.Tag.CENTER.equals(t) || HTML.Tag.FONT.equals(t) || HTML.Tag.SMALL.equals(t) || HTML.Tag.SPAN.equals(t) || HTML.Tag.U.equals(t) || HTML.Tag.H1.equals(t) || HTML.Tag.H2.equals(t) || HTML.Tag.H3.equals(t) || HTML.Tag.H4.equals(t) || HTML.Tag.H5.equals(t) || HTML.Tag.H6.equals(t)) {
            this.isFormatTag = true;
        }
    }

    @Override
    public void handleError(String errorMsg, int pos) {
        this.hasError = !errorMsg.startsWith("invalid.tagatt");
    }

    @Override
    public void handleEndTag(HTML.Tag t, int pos) {
        if (HTML.Tag.SCRIPT.equals(t)) {
            this.register = true;
            --this.inScript;
            if (this.inScript < 0) {
                this.inScript = 0;
            }
        }
        if (HTML.Tag.META.equals(t) || HTML.Tag.OPTION.equals(t) || HTML.Tag.LINK.equals(t)) {
            this.register = true;
        }
        if (HTML.Tag.I.equals(t) || HTML.Tag.B.equals(t) || HTML.Tag.BIG.equals(t) || HTML.Tag.CENTER.equals(t) || HTML.Tag.FONT.equals(t) || HTML.Tag.SMALL.equals(t) || HTML.Tag.SPAN.equals(t) || HTML.Tag.U.equals(t) || HTML.Tag.H1.equals(t) || HTML.Tag.H2.equals(t) || HTML.Tag.H3.equals(t) || HTML.Tag.H4.equals(t) || HTML.Tag.H5.equals(t) || HTML.Tag.H6.equals(t)) {
            this.isFormatTag = false;
        }
    }

    @Override
    public void parse(Reader in) throws IOException {
        this.texte = new StringBuilder(1024);
        ParserDelegator delegator = new ParserDelegator();
        delegator.parse(in, this, true);
    }

    @Override
    public void handleText(char[] text, int pos) {
        if (this.register && this.inScript <= 0 && !this.hasError && this.texte.length() <= this.maxSize) {
            for (char aText : text) {
                if (Character.isLetterOrDigit(aText)) {
                    this.texte.append(aText);
                    continue;
                }
                if (Character.isSpaceChar(aText)) {
                    this.texte.append(' ');
                    continue;
                }
                this.texte.append(aText);
            }
            if (!this.isFormatTag && !Character.isSpaceChar(text[text.length - 1])) {
                this.texte.append(' ');
            }
        }
    }

    @Override
    public void handleEndOfLineString(String eol) {
        if (this.texte.length() <= this.maxSize) {
            this.texte.append(' ');
        }
    }

    @Override
    public void handleComment(char[] data, int pos) {
    }

    @Override
    public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
    }

    @Override
    public String getSummary() {
        String buffer = this.texte.toString();
        buffer = buffer.trim();
        buffer = buffer.replaceAll("<[B,b][R,r]>", " ");
        buffer = buffer.replaceAll("<[B,b][R,r]/>", " ");
        if ((buffer = buffer.replaceAll("\\s[\\s]*", " ")).length() <= this.maxSize) {
            return buffer;
        }
        return buffer.substring(0, this.maxSize);
    }
}

