/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.service.job;

import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;

public class BetterMimeMessage
extends MimeMessage {
    public static final String SPAM_FLAG_HEADER = "X-Spam-Flag";
    public static final String SPAM_LEVEL_HEADER = "X-Spam-Score";
    public static final String AUTO_SUBMITTED_HEADER = "Auto-Submitted";
    private final MimeMessage mimeMessage;

    public BetterMimeMessage(MimeMessage message) throws MessagingException {
        super(message);
        this.mimeMessage = message;
    }

    public boolean isSpam() throws MessagingException {
        String[] spamFlags = this.mimeMessage.getHeader(SPAM_FLAG_HEADER);
        if (spamFlags != null) {
            for (String flag : spamFlags) {
                if (!"YES".equalsIgnoreCase(flag)) continue;
                return true;
            }
        }
        return false;
    }

    public float getSpamLevel() throws MessagingException {
        String[] spamScores = this.mimeMessage.getHeader(SPAM_LEVEL_HEADER);
        if (spamScores != null && spamScores.length > 0) {
            return Float.parseFloat(spamScores[0]);
        }
        return 0.0f;
    }

    public boolean isBounced() throws IOException, MessagingException {
        if (this.isAutomaticMessage()) {
            return true;
        }
        if (this.mimeMessage.getContent() instanceof Multipart) {
            Multipart parts = (Multipart)this.mimeMessage.getContent();
            for (int i = 0; i < parts.getCount(); ++i) {
                String contentType = parts.getBodyPart(i).getContentType();
                if (!this.isNotification(contentType)) continue;
                return true;
            }
        }
        return this.isNotification(this.mimeMessage.getContentType());
    }

    protected boolean isAutomaticMessage() throws MessagingException {
        String[] autoSubmittedHeaders = this.mimeMessage.getHeader(AUTO_SUBMITTED_HEADER);
        if (autoSubmittedHeaders != null) {
            for (String autoSubmittedHeader : autoSubmittedHeaders) {
                if (!"auto-generated".equalsIgnoreCase(autoSubmittedHeader) && !"auto-replied".equalsIgnoreCase(autoSubmittedHeader) && !autoSubmittedHeader.startsWith("auto-notified")) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isNotification(String contentType) {
        return this.isDeliveryStatus(contentType) || this.isMessageReport(contentType);
    }

    protected boolean isDeliveryStatus(String contentType) {
        return "message/delivery-status".equalsIgnoreCase(contentType);
    }

    protected boolean isMessageReport(String contentType) {
        return contentType.startsWith("multipart/report");
    }
}

