/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol;

import edu.psu.swe.scim.spec.adapter.FilterWrapper;
import edu.psu.swe.scim.spec.protocol.attribute.AttributeReference;
import edu.psu.swe.scim.spec.protocol.attribute.AttributeReferenceListWrapper;
import edu.psu.swe.scim.spec.protocol.data.ListResponse;
import edu.psu.swe.scim.spec.protocol.data.PatchRequest;
import edu.psu.swe.scim.spec.protocol.data.SearchRequest;
import edu.psu.swe.scim.spec.protocol.exception.ScimException;
import edu.psu.swe.scim.spec.protocol.search.SortOrder;
import edu.psu.swe.scim.spec.resources.ScimResource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.jaxrs.PATCH;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Api(tags={"SCIM"}, hidden=true)
public interface BaseResourceTypeResource<T> {
    @GET
    @Path(value="{id}")
    @Produces(value={"application/scim+json"})
    @ApiOperation(value="Find by id", produces="application/scim+json", response=ScimResource.class, code=200)
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=501, message="Not Implemented")})
    default public Response getById(@ApiParam(value="id", required=true) @PathParam(value="id") String id, @ApiParam(value="attributes", required=false) @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @ApiParam(value="excludedAttributes", required=false) @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) throws ScimException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @GET
    @Produces(value={"application/scim+json"})
    @ApiOperation(value="Find by a combination of query parameters", produces="application/scim+json", response=ListResponse.class, code=200)
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=501, message="Not Implemented")})
    default public Response query(@ApiParam(value="attributes", required=false) @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @ApiParam(value="excludedAttributes", required=false) @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes, @ApiParam(value="filter", required=false) @QueryParam(value="filter") FilterWrapper filterWrapper, @ApiParam(value="sortBy", required=false) @QueryParam(value="sortBy") AttributeReference sortBy, @ApiParam(value="sortOrder", required=false) @QueryParam(value="sortOrder") SortOrder sortOrder, @ApiParam(value="startIndex", required=false) @QueryParam(value="startIndex") Integer startIndex, @ApiParam(value="count", required=false) @QueryParam(value="count") Integer count) throws ScimException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @POST
    @Consumes(value={"application/scim+json"})
    @Produces(value={"application/scim+json"})
    @ApiOperation(value="Create", produces="application/scim+json", consumes="application/scim+json", response=ScimResource.class, code=201)
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=409, message="Conflict"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=501, message="Not Implemented")})
    default public Response create(T resource, @ApiParam(value="attributes", required=false) @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @ApiParam(value="excludedAttributes", required=false) @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) throws ScimException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @POST
    @Path(value="/.search")
    @Produces(value={"application/scim+json"})
    @ApiOperation(value="Search", produces="application/scim+json", response=ListResponse.class, code=200)
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=501, message="Not Implemented")})
    default public Response find(SearchRequest request) throws ScimException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/scim+json"})
    @Produces(value={"application/scim+json"})
    @ApiOperation(value="Update", produces="application/scim+json", consumes="application/scim+json", response=ScimResource.class, code=200)
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=501, message="Not Implemented")})
    default public Response update(T resource, @PathParam(value="id") String id, @ApiParam(value="attributes", required=false) @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @ApiParam(value="excludedAttributes", required=false) @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) throws ScimException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @PATCH
    @Path(value="{id}")
    @Consumes(value={"application/scim+json"})
    @Produces(value={"application/scim+json"})
    @ApiOperation(value="Patch a portion of the backing store", produces="application/scim+json", consumes="application/scim+json", code=204)
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=501, message="Not Implemented")})
    default public Response patch(PatchRequest patchRequest, @PathParam(value="id") String id, @ApiParam(value="attributes", required=false) @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @ApiParam(value="excludedAttributes", required=false) @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) throws ScimException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @DELETE
    @Path(value="{id}")
    @ApiOperation(value="Delete from the backing store", code=204)
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=501, message="Not Implemented")})
    default public Response delete(@ApiParam(value="id", required=true) @PathParam(value="id") String id) throws ScimException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }
}

