/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree.factories;

import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.oak.plugins.tree.impl.NodeBuilderTree;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public final class TreeFactory {
    private TreeFactory() {
    }

    public static Tree createTree(@NotNull NodeBuilder builder) {
        return new NodeBuilderTree("", builder);
    }

    public static Tree createReadOnlyTree(@NotNull NodeState rootState) {
        return new ImmutableTree(rootState);
    }

    public static Tree createReadOnlyTree(@NotNull Tree readOnlyParent, @NotNull String childName, @NotNull NodeState childState) {
        Validate.checkArgument((boolean)(readOnlyParent instanceof ImmutableTree));
        return new ImmutableTree((ImmutableTree)readOnlyParent, childName, childState);
    }
}

