/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.commit;

import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.commit.PartialConflictHandler;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class ChildOrderConflictHandler
implements PartialConflictHandler {
    public PartialConflictHandler.Resolution addExistingProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        if (ChildOrderConflictHandler.isChildOrderProperty(ours)) {
            ChildOrderConflictHandler.merge(parent, ours, theirs);
            return PartialConflictHandler.Resolution.MERGED;
        }
        return null;
    }

    public PartialConflictHandler.Resolution changeDeletedProperty(NodeBuilder parent, PropertyState ours) {
        if (ChildOrderConflictHandler.isChildOrderProperty(ours)) {
            return PartialConflictHandler.Resolution.THEIRS;
        }
        return null;
    }

    public PartialConflictHandler.Resolution changeChangedProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        if (ChildOrderConflictHandler.isChildOrderProperty(ours)) {
            ChildOrderConflictHandler.merge(parent, ours, theirs);
            return PartialConflictHandler.Resolution.MERGED;
        }
        return null;
    }

    private static void merge(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        Set theirOrder = SetUtils.toSet((Iterable)((Iterable)theirs.getValue(Type.NAMES)));
        PropertyBuilder merged = PropertyBuilder.array((Type)Type.NAME).assignFrom(theirs);
        for (String ourChild : (Iterable)ours.getValue(Type.NAMES)) {
            if (theirOrder.contains(ourChild)) continue;
            merged.addValue((Object)ourChild);
        }
        for (String child : merged.getValues()) {
            if (parent.hasChildNode(child)) continue;
            merged.removeValue((Object)child);
        }
        parent.setProperty(merged.getPropertyState());
    }

    public PartialConflictHandler.Resolution deleteDeletedProperty(NodeBuilder parent, PropertyState ours) {
        if (ChildOrderConflictHandler.isChildOrderProperty(ours)) {
            return PartialConflictHandler.Resolution.THEIRS;
        }
        return null;
    }

    public PartialConflictHandler.Resolution deleteChangedProperty(NodeBuilder parent, PropertyState theirs) {
        if (ChildOrderConflictHandler.isChildOrderProperty(theirs)) {
            return PartialConflictHandler.Resolution.THEIRS;
        }
        return null;
    }

    public PartialConflictHandler.Resolution addExistingNode(NodeBuilder parent, String name, NodeState ours, NodeState theirs) {
        return null;
    }

    public PartialConflictHandler.Resolution changeDeletedNode(NodeBuilder parent, String name, NodeState ours) {
        return null;
    }

    public PartialConflictHandler.Resolution deleteChangedNode(NodeBuilder parent, String name, NodeState theirs) {
        return null;
    }

    public PartialConflictHandler.Resolution deleteDeletedNode(NodeBuilder parent, String name) {
        return null;
    }

    private static boolean isChildOrderProperty(PropertyState p) {
        return ":childOrder".equals(p.getName());
    }
}

