/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.guava.common.hash.HashCode;
import org.apache.jackrabbit.guava.common.hash.Hashing;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.commons.properties.SystemPropertySupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBlob
implements Blob {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBlob.class);
    private static final boolean DEBUG_BLOB_EQUAL_LOG = (Boolean)SystemPropertySupplier.create((String)"oak.abstractblob.equal.log", (Object)false).loggingTo(LOG).formatSetMessage((name, value) -> String.format("%s set to: %s", name, value)).get();
    private static final long DEBUG_BLOB_EQUAL_LOG_LIMIT = (Long)SystemPropertySupplier.create((String)"oak.abstractblob.equal.log.limit", (Object)100000000L).loggingTo(LOG).formatSetMessage((name, value) -> String.format("%s set to: %s", name, value)).get();
    private HashCode hashCode;

    public static boolean equal(Blob a, Blob b) {
        long al = a.length();
        long bl = b.length();
        if (al != -1L && bl != -1L && al != bl) {
            return false;
        }
        String ai = a.getContentIdentity();
        String bi = b.getContentIdentity();
        if (ai != null && bi != null && ai.equals(bi)) {
            return true;
        }
        if (DEBUG_BLOB_EQUAL_LOG && al > DEBUG_BLOB_EQUAL_LOG_LIMIT) {
            LOG.debug("Blobs have the same length of {} and we're falling back to byte-wise comparison.", (Object)al);
        }
        try {
            return IOUtils.contentEquals((InputStream)a.getNewStream(), (InputStream)b.getNewStream());
        }
        catch (IOException e) {
            throw new IllegalStateException("Blob equality check failed", e);
        }
    }

    public static HashCode calculateSha256(final Blob blob) {
        AbstractBlob ab = blob instanceof AbstractBlob ? (AbstractBlob)blob : new AbstractBlob(){

            public long length() {
                return blob.length();
            }

            public boolean isInlined() {
                return blob.isInlined();
            }

            @NotNull
            public InputStream getNewStream() {
                return blob.getNewStream();
            }
        };
        return ab.getSha256();
    }

    protected AbstractBlob(HashCode hashCode) {
        this.hashCode = hashCode;
    }

    protected AbstractBlob() {
        this(null);
    }

    private synchronized HashCode getSha256() {
        if (this.hashCode == null) {
            try {
                this.hashCode = Hashing.sha256().hashBytes(this.getNewStream().readAllBytes());
            }
            catch (IOException e) {
                throw new IllegalStateException("Hash calculation failed", e);
            }
        }
        return this.hashCode;
    }

    protected byte[] sha256() {
        return this.getSha256().asBytes();
    }

    @Nullable
    public String getReference() {
        return null;
    }

    public String getContentIdentity() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof AbstractBlob) {
            AbstractBlob that = (AbstractBlob)other;
            AbstractBlob abstractBlob = this;
            synchronized (abstractBlob) {
                if (this.hashCode != null) {
                    AbstractBlob abstractBlob2 = that;
                    synchronized (abstractBlob2) {
                        if (that.hashCode != null) {
                            return this.hashCode.equals((Object)that.hashCode);
                        }
                    }
                }
            }
        }
        return other instanceof Blob && AbstractBlob.equal(this, (Blob)other);
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return this.getSha256().toString();
    }
}

