/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.warupdater;

import com.sun.portal.portletcontainer.common.PortletDeployConfigReader;
import com.sun.portal.portletcontainer.warupdater.PortletWarUpdaterException;
import com.sun.portal.portletcontainer.warupdater.PortletWarUpdaterUtil;
import com.sun.portal.portletcontainer.warupdater.PortletWebAppUpdater;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class PortletWarUpdater {
    private static Logger logger = PortletWarUpdaterUtil.getLogger(PortletWarUpdater.class, "PWULogMessages");
    private File warFile;
    private JarFile jar;
    private static Properties configProps;
    private String warFileLocation;
    private static final String PORTLET_TLD_FILE = "sun-portlet.tld";
    private static final String PORTLET_2_0_TLD_FILE = "sun-portlet_2_0.tld";
    private static final String XML_PORTLET_REQUEST_JS_FILE = "XMLPortletRequest.js";
    private static final String JS_PREFIX = "js/";
    private static final String JS_DIR = "js";
    private static final String WEB_INF_PREFIX = "WEB-INF/";
    private static final String WEB_INF_DIR = "WEB-INF";
    private static final String WEB_XML = "web.xml";
    private static final String DEFAULT_WEB_XML = "default-web.xml";
    private static final String WEB_XML_NAME = "WEB-INF/web.xml";
    private String fileSuffix = "";
    public static final String ADD_WEB_XML = "addWebXML";

    public PortletWarUpdater() {
        configProps = PortletDeployConfigReader.getPortletDeployDefaultConfigProperties();
    }

    public PortletWarUpdater(Properties deployConfigCustomizedProperties) {
        configProps = PortletDeployConfigReader.getPortletDeployConfigProperties(deployConfigCustomizedProperties);
    }

    public PortletWarUpdater(String deployConfigFileLocation) {
        configProps = PortletDeployConfigReader.getPortletDeployConfigProperties(deployConfigFileLocation);
        logger.log(Level.FINEST, "PSPL_CSPPCWU0004", this.warFileLocation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean preparePortlet(File warFile, String warFileDestination) throws PortletWarUpdaterException {
        if (warFileDestination == null) {
            throw new NullPointerException("The location where the updated war will be stored cannot be null");
        }
        if (!PortletWarUpdaterUtil.makeDir(warFileDestination)) {
            Object[] tokens = new Object[]{warFileDestination};
            throw new PortletWarUpdaterException("cannotCreateDirectory", tokens);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "PSPL_CSPPCWU0005", new String[]{warFile.getAbsolutePath(), warFileDestination});
        }
        this.warFile = warFile;
        this.warFileLocation = warFileDestination;
        String warNameOnly = PortletWarUpdaterUtil.getWarName(warFile.getName());
        this.fileSuffix = PortletWarUpdaterUtil.getFileSuffix(warNameOnly);
        String portletAppName = warNameOnly.substring(0, warNameOnly.lastIndexOf(46));
        logger.log(Level.FINER, "PSPL_CSPPCWU0006", portletAppName);
        try {
            this.jar = new JarFile(warFile);
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{warNameOnly};
            throw new PortletWarUpdaterException("errorGettingJarFile", ioe, tokens);
        }
        logger.log(Level.FINER, "PSPL_CSPPCWU0008");
        File newWebXMLFile = null;
        InputStream webXMLStream = null;
        try {
            ZipEntry webXMLEntry = this.jar.getEntry(WEB_XML_NAME);
            if (webXMLEntry == null) {
                if (!this.shouldAddWebXML()) {
                    logger.log(Level.INFO, "PSPL_CSPPCWU0003");
                    boolean bl = false;
                    return bl;
                }
                webXMLStream = this.getDefaultWebXML();
            } else {
                webXMLStream = this.jar.getInputStream(webXMLEntry);
            }
            newWebXMLFile = PortletWebAppUpdater.addWebAppParam(webXMLStream, configProps, portletAppName);
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{portletAppName};
            throw new PortletWarUpdaterException("errorUpdatingWebApp", ioe, tokens);
        }
        catch (Exception ex) {
            Object[] tokens = new Object[]{portletAppName};
            throw new PortletWarUpdaterException("errorUpdatingWebApp", ex, tokens);
        }
        finally {
            if (webXMLStream != null) {
                try {
                    webXMLStream.close();
                }
                catch (IOException ioe) {
                    throw new PortletWarUpdaterException("errorStreamClose", ioe);
                }
            }
        }
        String warFileName = portletAppName + this.fileSuffix;
        File destFile = new File(warFileDestination, warFileName);
        try {
            File newWarFile = this.getUpdatedWarFile(newWebXMLFile);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "PSPL_CSPPCWU0009", newWarFile.getAbsolutePath());
            }
            if (newWarFile != null) {
                PortletWarUpdaterUtil.copyFile(newWarFile, destFile, true, false);
                newWarFile.delete();
                return true;
            }
            Object[] tokens = new Object[]{warFileName};
            throw new PortletWarUpdaterException("errorJarUpdate", tokens);
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{warFileName};
            throw new PortletWarUpdaterException("errorJarUpdate", ioe, tokens);
        }
        catch (Exception ex) {
            Object[] tokens = new Object[]{warFileName};
            throw new PortletWarUpdaterException("errorJarUpdate", ex, tokens);
        }
    }

    public boolean preparePortlet(String portletAppName, File explodedDirectory) throws PortletWarUpdaterException {
        if (explodedDirectory == null) {
            throw new NullPointerException("The exploded directory cannot be null");
        }
        if (!explodedDirectory.isDirectory()) {
            Object[] tokens = new Object[]{explodedDirectory.getAbsolutePath()};
            throw new PortletWarUpdaterException("notADirectory", tokens);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "PSPL_CSPPCWU0014", portletAppName);
        }
        File webXMLFile = new File(explodedDirectory + File.separator + WEB_INF_DIR + File.separator + WEB_XML);
        InputStream webXMLStream = null;
        File newWebXMLFile = null;
        if (webXMLFile == null || !webXMLFile.exists()) {
            if (this.shouldAddWebXML()) {
                webXMLStream = this.getDefaultWebXML();
                try {
                    PortletWarUpdaterUtil.copyFile(webXMLStream, webXMLFile);
                }
                catch (IOException ioe) {
                    Object[] tokens = new Object[]{explodedDirectory};
                    throw new PortletWarUpdaterException("cannotCopyWebXMLToDirectory", ioe, tokens);
                }
            } else {
                logger.log(Level.INFO, "PSPL_CSPPCWU0003");
                return false;
            }
        }
        try {
            webXMLStream = new FileInputStream(webXMLFile);
            newWebXMLFile = PortletWebAppUpdater.addWebAppParam(webXMLStream, configProps, portletAppName);
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{portletAppName};
            throw new PortletWarUpdaterException("errorUpdatingWebApp", ioe, tokens);
        }
        catch (Exception ex) {
            Object[] tokens = new Object[]{portletAppName};
            throw new PortletWarUpdaterException("errorUpdatingWebApp", ex, tokens);
        }
        finally {
            if (webXMLStream != null) {
                try {
                    webXMLStream.close();
                }
                catch (IOException ioe) {
                    throw new PortletWarUpdaterException("errorStreamClose", ioe);
                }
            }
        }
        try {
            PortletWarUpdaterUtil.copyFile(newWebXMLFile, webXMLFile, true, true);
            this.addFile(explodedDirectory, WEB_INF_DIR, PORTLET_TLD_FILE);
            this.addFile(explodedDirectory, WEB_INF_DIR, PORTLET_2_0_TLD_FILE);
            this.addFile(explodedDirectory, JS_DIR, XML_PORTLET_REQUEST_JS_FILE);
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{explodedDirectory};
            throw new PortletWarUpdaterException("errorDirectoryUpdate", ioe, tokens);
        }
        catch (Exception ex) {
            Object[] tokens = new Object[]{explodedDirectory};
            throw new PortletWarUpdaterException("errorDirectoryUpdate", ex, tokens);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getUpdatedWarFile(File webXMLFile) throws Exception {
        String tempWarFileName = this.warFile.getName().substring(0, this.warFile.getName().lastIndexOf(46)) + this.fileSuffix + ".tmp";
        File tempJarFile = new File(this.warFileLocation, tempWarFileName);
        tempJarFile.deleteOnExit();
        boolean jarUpdated = false;
        try {
            JarOutputStream tempJar = new JarOutputStream(new FileOutputStream(tempJarFile));
            byte[] buffer = new byte[1024];
            try {
                int bytesRead;
                FileInputStream webXMLin = new FileInputStream(webXMLFile);
                try {
                    JarEntry entry = new JarEntry(WEB_XML_NAME);
                    tempJar.putNextEntry(entry);
                    while ((bytesRead = webXMLin.read(buffer)) != -1) {
                        tempJar.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    webXMLin.close();
                }
                this.addFile(tempJar, WEB_INF_PREFIX, PORTLET_TLD_FILE);
                this.addFile(tempJar, WEB_INF_PREFIX, PORTLET_2_0_TLD_FILE);
                this.addFile(tempJar, JS_PREFIX, null);
                this.addFile(tempJar, JS_PREFIX, XML_PORTLET_REQUEST_JS_FILE);
                Enumeration<JarEntry> entries = this.jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    InputStream entryStream = null;
                    try {
                        if (entry.getName().equals(WEB_XML_NAME) || entry.getName().equals("WEB-INF/sun-portlet.tld") || entry.getName().equals("WEB-INF/sun-portlet_2_0.tld") || entry.getName().equals(JS_PREFIX) || entry.getName().equals("js/XMLPortletRequest.js")) continue;
                        entryStream = this.jar.getInputStream(entry);
                        tempJar.putNextEntry(new JarEntry(entry.getName()));
                        while ((bytesRead = entryStream.read(buffer)) != -1) {
                            tempJar.write(buffer, 0, bytesRead);
                        }
                    }
                    finally {
                        if (entryStream == null) continue;
                        entryStream.close();
                    }
                }
                jarUpdated = true;
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "PSPL_CSPPCWU0001", ex);
                throw ex;
            }
            finally {
                tempJar.close();
            }
        }
        finally {
            this.jar.close();
            if (!jarUpdated) {
                tempJarFile.delete();
            }
        }
        if (jarUpdated) {
            return tempJarFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(JarOutputStream tempJar, String prefix, String fileName) throws Exception {
        if (fileName == null) {
            JarEntry entry = new JarEntry(prefix);
            tempJar.putNextEntry(entry);
            return;
        }
        InputStream resourceStream = this.getResourceAsStream(fileName);
        byte[] buffer = new byte[1024];
        try {
            int bytesRead;
            JarEntry entry = new JarEntry(prefix + fileName);
            tempJar.putNextEntry(entry);
            while ((bytesRead = resourceStream.read(buffer)) != -1) {
                tempJar.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (resourceStream != null) {
                resourceStream.close();
            }
        }
    }

    private void addFile(File docBase, String dir, String fileName) throws Exception {
        InputStream resourceStream = this.getResourceAsStream(fileName);
        File dirObj = new File(docBase + File.separator + dir);
        if (!dirObj.exists()) {
            dirObj.mkdirs();
        }
        File destFile = new File(dirObj, fileName);
        PortletWarUpdaterUtil.copyFile(resourceStream, destFile);
    }

    private InputStream getResourceAsStream(String fileName) {
        InputStream resourceStream = null;
        resourceStream = fileName.equals(PORTLET_TLD_FILE) || fileName.equals(PORTLET_2_0_TLD_FILE) ? this.getClass().getClassLoader().getResourceAsStream("META-INF/" + fileName) : this.getClass().getClassLoader().getResourceAsStream(fileName);
        return resourceStream;
    }

    private InputStream getDefaultWebXML() {
        return this.getClass().getClassLoader().getResourceAsStream(DEFAULT_WEB_XML);
    }

    private boolean shouldAddWebXML() {
        return "true".equals(configProps.getProperty(ADD_WEB_XML));
    }

    public static void main(String[] args) {
        try {
            String unMessagedWarFile = "D:/work/PorletContainer/samples/WelcomePortlet/dist/WelcomePortlet.war";
            String warDestinationFolder = "d:/";
            try {
                unMessagedWarFile = args[0];
                warDestinationFolder = args[1];
            }
            catch (Exception ee) {
                System.out.println("Number of input parameters: " + args.length);
            }
            System.out.println("Preparing portlet : " + unMessagedWarFile);
            Properties customizedProperties = new Properties();
            customizedProperties.setProperty("request_response_factory.maxSizeParam", "152");
            PortletWarUpdater warUpdater = new PortletWarUpdater(customizedProperties);
            warUpdater.preparePortlet(args[0], new File(args[1]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

