/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAERequestWrapper
extends HttpServletRequestWrapper {
    private String namespace;
    private List<String> requestSharedAttributes;
    static Set<String> reservedAttributes = new HashSet<String>();

    public PAERequestWrapper(HttpServletRequest request, String namespace) {
        super(request);
        this.namespace = namespace;
    }

    public Object getAttribute(String name) {
        Object value = super.getAttribute(this.namespace + name);
        if (value == null) {
            value = super.getAttribute(name);
        }
        return value;
    }

    public void setAttribute(String name, Object value) {
        if (this.isReservedParameter(name)) {
            super.setAttribute(name, value);
        } else {
            super.setAttribute(this.namespace + name, value);
        }
    }

    public Enumeration<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration attributeNames = super.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            if (!name.startsWith(this.namespace)) continue;
            names.add(name.substring(this.namespace.length(), name.length()));
        }
        return Collections.enumeration(names);
    }

    public void removeAttribute(String name) {
        if (this.isReservedParameter(name)) {
            super.removeAttribute(name);
        } else {
            super.removeAttribute(this.namespace + name);
        }
    }

    protected void setRequestSharedAttributes(List<String> requestSharedAttributes) {
        this.requestSharedAttributes = requestSharedAttributes;
    }

    private boolean isReservedParameter(String name) {
        if (reservedAttributes.contains(name)) {
            return true;
        }
        if (this.requestSharedAttributes != null) {
            for (String requestSharedAttribute : this.requestSharedAttributes) {
                if (!name.startsWith(requestSharedAttribute)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        reservedAttributes.add("javax.portlet.request");
        reservedAttributes.add("javax.portlet.response");
        reservedAttributes.add("javax.portlet.config");
        reservedAttributes.add("javax.portlet.lifecycle_phase");
    }
}

