/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.PortletID;
import com.sun.portal.portletcontainer.common.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainer.common.descriptor.InitParamDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletInfoDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletPreferencesDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletXMLDocumentHelper;
import com.sun.portal.portletcontainer.common.descriptor.SecurityRoleRefDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.SupportsDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletDescriptor {
    private String id;
    private String portletAppName;
    private String portletName;
    private PortletID portletID;
    private String portletClassName;
    private String resourceBundle;
    private List<String> descriptions;
    private List<String> displayNames;
    private Map<String, String> descriptionMap;
    private Map<String, String> displayNameMap;
    private List<String> supportedLocales;
    private PortletPreferencesDescriptor portletPreferencesDescriptor;
    private List<InitParamDescriptor> initParamDescriptors;
    private List<SupportsDescriptor> supportsDescriptors;
    private String cacheExpiration;
    private String cacheScope;
    private PortletInfoDescriptor infoDescriptor;
    private List<SecurityRoleRefDescriptor> secRoleRefDescriptors;
    private Map<String, String[]> containerRTOptions;
    private List<QName> supportedProcessingEvents;
    private List<QName> supportedPublishingEvents;
    private List<String> supportedPublicRenderParameterIdentifiers;
    private static Logger logger = ContainerLogger.getLogger(PortletDescriptor.class, (String)"PCCLogMessages");

    public PortletDescriptor(String portletAppName) {
        this.portletAppName = portletAppName;
    }

    public void load(Element portletElement, String namespaceURI, String defaultNameSpace) throws DeploymentDescriptorException {
        NodeList supportedPublishingEventElements;
        NodeList secRoleElements;
        NodeList initParamElements;
        NodeList supportsElements;
        NodeList supportedLocaleElements;
        NodeList displayNameElements;
        NodeList descriptionElements;
        this.id = PortletXMLDocumentHelper.getId(portletElement);
        this.portletName = PortletXMLDocumentHelper.getChildTextTrim(portletElement, "portlet-name");
        if (this.portletName == null) {
            logger.warning("PSPL_PCCCSPPCCD0005");
        }
        this.portletID = new PortletID(this.portletAppName, this.portletName);
        this.portletClassName = PortletXMLDocumentHelper.getChildTextTrim(portletElement, "portlet-class");
        if (this.portletClassName == null) {
            logger.warning("PSPL_PCCCSPPCCD0006");
        }
        if ((descriptionElements = portletElement.getElementsByTagName("description")).getLength() > 0) {
            this.descriptionMap = new HashMap<String, String>(descriptionElements.getLength());
            this.descriptions = new ArrayList<String>(descriptionElements.getLength());
            for (int i = 0; i < descriptionElements.getLength(); ++i) {
                String lang;
                Element descriptionElement = (Element)descriptionElements.item(i);
                String description = PortletXMLDocumentHelper.getTextTrim(descriptionElement);
                this.descriptions.add(description);
                Map<String, String> descAttributes = PortletXMLDocumentHelper.getAttributeTable(descriptionElement);
                Iterator<Map.Entry<String, String>> dait = descAttributes.entrySet().iterator();
                if (dait.hasNext()) {
                    while (dait.hasNext()) {
                        Map.Entry<String, String> entry = dait.next();
                        lang = entry.getKey();
                        if (!lang.equals("xml:lang")) continue;
                        this.descriptionMap.put(entry.getValue(), description);
                    }
                    continue;
                }
                lang = Locale.getDefault().toString().replace('_', '-');
                this.descriptionMap.put(lang, description);
            }
        }
        if ((displayNameElements = portletElement.getElementsByTagName("display-name")).getLength() > 0) {
            this.displayNames = new ArrayList<String>(displayNameElements.getLength());
            this.displayNameMap = new HashMap<String, String>(displayNameElements.getLength());
            for (int i = 0; i < displayNameElements.getLength(); ++i) {
                String lang;
                Element displayNameElement = (Element)displayNameElements.item(i);
                String displayName = PortletXMLDocumentHelper.getTextTrim(displayNameElement);
                this.displayNames.add(displayName);
                Map<String, String> displayNameAttributes = PortletXMLDocumentHelper.getAttributeTable(displayNameElement);
                Iterator<Map.Entry<String, String>> dnit = displayNameAttributes.entrySet().iterator();
                if (dnit.hasNext()) {
                    while (dnit.hasNext()) {
                        Map.Entry<String, String> entry = dnit.next();
                        lang = entry.getKey();
                        if (!lang.equals("xml:lang")) continue;
                        this.displayNameMap.put(entry.getValue(), displayName);
                    }
                    continue;
                }
                lang = Locale.getDefault().toString().replace('_', '-');
                this.displayNameMap.put(lang, displayName);
            }
        }
        if ((supportedLocaleElements = portletElement.getElementsByTagName("supported-locale")).getLength() > 0) {
            this.supportedLocales = new ArrayList<String>(supportedLocaleElements.getLength());
            for (int i = 0; i < supportedLocaleElements.getLength(); ++i) {
                Element supportedLocaleElement = (Element)supportedLocaleElements.item(i);
                this.supportedLocales.add(PortletXMLDocumentHelper.getTextTrim(supportedLocaleElement));
            }
        }
        if ((supportsElements = portletElement.getElementsByTagName("supports")).getLength() == 0) {
            logger.warning("PSPL_PCCCSPPCCD0008");
        } else {
            this.supportsDescriptors = new ArrayList<SupportsDescriptor>(supportsElements.getLength());
            for (int i = 0; i < supportsElements.getLength(); ++i) {
                Element supportsElement = (Element)supportsElements.item(i);
                SupportsDescriptor supportsDescriptor = new SupportsDescriptor();
                supportsDescriptor.load(supportsElement, namespaceURI);
                this.supportsDescriptors.add(supportsDescriptor);
            }
        }
        Element pPreferencesElement = PortletXMLDocumentHelper.getChildElement(portletElement, "portlet-preferences");
        if (pPreferencesElement != null) {
            this.portletPreferencesDescriptor = new PortletPreferencesDescriptor(this.portletName);
            this.portletPreferencesDescriptor.load(pPreferencesElement, namespaceURI);
        }
        if ((initParamElements = portletElement.getElementsByTagName("init-param")).getLength() > 0) {
            this.initParamDescriptors = new ArrayList<InitParamDescriptor>(initParamElements.getLength());
            for (int i = 0; i < initParamElements.getLength(); ++i) {
                Element initParamElement = (Element)initParamElements.item(i);
                InitParamDescriptor initParamDescriptor = new InitParamDescriptor();
                initParamDescriptor.load(initParamElement, namespaceURI);
                this.initParamDescriptors.add(initParamDescriptor);
            }
        }
        this.cacheExpiration = PortletXMLDocumentHelper.getChildTextTrim(portletElement, "expiration-cache");
        this.setCachingScope(PortletXMLDocumentHelper.getChildTextTrim(portletElement, "cache-scope"));
        Element infoElement = PortletXMLDocumentHelper.getChildElement(portletElement, "portlet-info");
        if (infoElement != null) {
            this.infoDescriptor = new PortletInfoDescriptor();
            this.infoDescriptor.load(infoElement, namespaceURI);
        }
        if ((secRoleElements = portletElement.getElementsByTagName("security-role-ref")).getLength() > 0) {
            this.secRoleRefDescriptors = new ArrayList<SecurityRoleRefDescriptor>(secRoleElements.getLength());
            for (int i = 0; i < secRoleElements.getLength(); ++i) {
                Element secRoleElement = (Element)secRoleElements.item(i);
                SecurityRoleRefDescriptor secRoleRefDescriptor = new SecurityRoleRefDescriptor();
                secRoleRefDescriptor.load(secRoleElement, namespaceURI);
                this.secRoleRefDescriptors.add(secRoleRefDescriptor);
            }
        }
        this.resourceBundle = PortletXMLDocumentHelper.getChildTextTrim(portletElement, "resource-bundle");
        NodeList supportedProcessingEventElements = portletElement.getElementsByTagName("supported-processing-event");
        if (supportedProcessingEventElements.getLength() > 0) {
            this.supportedProcessingEvents = new ArrayList<QName>(supportedProcessingEventElements.getLength());
            for (int i = 0; i < supportedProcessingEventElements.getLength(); ++i) {
                Element supportedProcessingEventElement = (Element)supportedProcessingEventElements.item(i);
                QName qname = this.getQName(supportedProcessingEventElement, defaultNameSpace);
                if (qname == null) continue;
                this.supportedProcessingEvents.add(qname);
            }
        }
        if ((supportedPublishingEventElements = portletElement.getElementsByTagName("supported-publishing-event")).getLength() > 0) {
            this.supportedPublishingEvents = new ArrayList<QName>(supportedPublishingEventElements.getLength());
            for (int i = 0; i < supportedPublishingEventElements.getLength(); ++i) {
                Element supportedPublishingEventElement = (Element)supportedPublishingEventElements.item(i);
                QName qname = this.getQName(supportedPublishingEventElement, defaultNameSpace);
                if (qname == null) continue;
                this.supportedPublishingEvents.add(qname);
            }
        }
        this.supportedPublicRenderParameterIdentifiers = PortletXMLDocumentHelper.getChildElementsText(portletElement, "supported-public-render-parameter");
        this.containerRTOptions = PortletXMLDocumentHelper.getRuntimeOptions(portletElement);
    }

    public String getPortletName() {
        return this.portletName;
    }

    public String getClassName() {
        return this.portletClassName;
    }

    public String getDescription() {
        String description = null;
        if (this.descriptions != null && !this.descriptions.isEmpty()) {
            description = this.descriptions.get(0);
        }
        return description;
    }

    public List<String> getDescriptions() {
        if (this.descriptions == null) {
            return Collections.emptyList();
        }
        return this.descriptions;
    }

    public Map<String, String> getDescriptionMap() {
        if (this.descriptionMap == null) {
            return Collections.emptyMap();
        }
        return this.descriptionMap;
    }

    public List getDisplayNames() {
        if (this.displayNames == null) {
            return Collections.emptyList();
        }
        return this.displayNames;
    }

    public Map getDisplayNameMap() {
        if (this.displayNameMap == null) {
            return Collections.emptyMap();
        }
        return this.displayNameMap;
    }

    public List<String> getSupportedLocales() {
        if (this.supportedLocales == null) {
            return Collections.emptyList();
        }
        return this.supportedLocales;
    }

    public PortletPreferencesDescriptor getPortletPreferencesDescriptor() {
        return this.portletPreferencesDescriptor;
    }

    public List<InitParamDescriptor> getInitParamDescriptors() {
        if (this.initParamDescriptors == null) {
            return Collections.emptyList();
        }
        return this.initParamDescriptors;
    }

    public List<SupportsDescriptor> getSupportsDescriptors() {
        if (this.supportsDescriptors == null) {
            return Collections.emptyList();
        }
        return this.supportsDescriptors;
    }

    public List<String> getSupportedMimeTypes() {
        ArrayList<String> mimeTypeList = new ArrayList<String>();
        for (SupportsDescriptor supportsDescriptor : this.supportsDescriptors) {
            mimeTypeList.add(supportsDescriptor.getMimeType());
        }
        return mimeTypeList;
    }

    public List<String> getSupportedPortletModes(String mime) {
        List<String> supportList = null;
        boolean stop = false;
        Iterator<SupportsDescriptor> iterator = this.supportsDescriptors.iterator();
        while (iterator.hasNext() && !stop) {
            SupportsDescriptor supportsDescriptor = iterator.next();
            String mimeType = supportsDescriptor.getMimeType();
            if (mimeType.toLowerCase(Locale.ENGLISH).equals("*/*")) {
                supportList = supportsDescriptor.getPortletModes();
                stop = true;
                continue;
            }
            if (mimeType.toLowerCase(Locale.ENGLISH).equals("text/*") && mime.toLowerCase(Locale.ENGLISH).startsWith("text/")) {
                supportList = supportsDescriptor.getPortletModes();
                stop = true;
                continue;
            }
            if (!supportsDescriptor.getMimeType().equals(mime)) continue;
            supportList = supportsDescriptor.getPortletModes();
            stop = true;
        }
        if (supportList == null) {
            return Collections.emptyList();
        }
        return supportList;
    }

    public int getCacheExpiration() {
        int retValue = -999;
        if (this.cacheExpiration != null) {
            try {
                retValue = Integer.parseInt(this.cacheExpiration);
            }
            catch (NumberFormatException ne) {
                logger.log(Level.WARNING, "PSPL_PCCCSPPCCD0009", this.portletName);
            }
        }
        return retValue;
    }

    public String getCachingScope() {
        return this.cacheScope;
    }

    private QName getQName(Element supportedEventElement, String defaultNameSpace) {
        String name;
        QName qname = PortletXMLDocumentHelper.generateQName(PortletXMLDocumentHelper.getChildElement(supportedEventElement, "qname"), defaultNameSpace);
        if (qname == null && (name = PortletXMLDocumentHelper.getChildTextTrim(supportedEventElement, "name")) != null) {
            qname = new QName(defaultNameSpace, name);
        }
        return qname;
    }

    private void setCachingScope(String scope) {
        this.cacheScope = scope != null && (scope.equalsIgnoreCase("private") || scope.equalsIgnoreCase("public")) ? scope : "private";
    }

    public PortletInfoDescriptor getPortletInfoDescriptor() {
        return this.infoDescriptor;
    }

    public List<SecurityRoleRefDescriptor> getSecurityRoleRefDescriptors() {
        if (this.secRoleRefDescriptors == null) {
            return Collections.emptyList();
        }
        return this.secRoleRefDescriptors;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public Map<String, String[]> getContainerRuntimeOptions() {
        if (this.containerRTOptions == null) {
            return Collections.emptyMap();
        }
        return this.containerRTOptions;
    }

    public String[] getContainerRuntimeOption(String optionName) {
        return this.containerRTOptions.get(optionName);
    }

    public List<QName> getSupportedProcessingEvents() {
        if (this.supportedProcessingEvents == null) {
            return Collections.emptyList();
        }
        return this.supportedProcessingEvents;
    }

    public List<QName> getSupportedPublishingEvents() {
        if (this.supportedPublishingEvents == null) {
            return Collections.emptyList();
        }
        return this.supportedPublishingEvents;
    }

    public List<String> getSupportedPublicRenderParameterIdentifiers() {
        if (this.supportedPublicRenderParameterIdentifiers == null) {
            return Collections.emptyList();
        }
        return this.supportedPublicRenderParameterIdentifiers;
    }

    public String getId() {
        return this.id;
    }

    public PortletID getPortletID() {
        return this.portletID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PortletDescriptor ");
        sb.append(" portlet name [");
        if (this.portletName != null) {
            sb.append(this.portletName);
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        sb.append(" portlet class [");
        if (this.portletClassName != null) {
            sb.append(this.portletClassName);
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        sb.append(" portlet descriptions [");
        Iterator<String> iterator0 = this.descriptions.iterator();
        while (iterator0.hasNext()) {
            sb.append(iterator0.next());
        }
        sb.append(" ]");
        sb.append(" portlet display names [");
        Iterator<String> iterator3 = this.displayNames.iterator();
        while (iterator3.hasNext()) {
            sb.append(iterator3.next());
        }
        sb.append(" ]");
        sb.append(" portlet supported locales [");
        Iterator<String> iterator5 = this.supportedLocales.iterator();
        while (iterator5.hasNext()) {
            sb.append(iterator5.next());
        }
        sb.append(" ]");
        for (InitParamDescriptor initParamDescriptor : this.initParamDescriptors) {
            sb.append(initParamDescriptor.toString());
            sb.append("\n");
        }
        for (SupportsDescriptor supportsDescriptor : this.supportsDescriptors) {
            sb.append(supportsDescriptor.toString());
            sb.append("\n");
        }
        if (this.cacheExpiration != null) {
            sb.append(this.cacheExpiration);
        }
        if (this.infoDescriptor != null) {
            sb.append(this.infoDescriptor.toString());
        }
        if (this.portletPreferencesDescriptor != null) {
            sb.append(this.portletPreferencesDescriptor.toString());
        }
        for (SecurityRoleRefDescriptor secRoleRefDescriptor : this.secRoleRefDescriptors) {
            sb.append(secRoleRefDescriptor.toString());
            sb.append("\n");
        }
        if (this.resourceBundle != null) {
            sb.append(" resource bundle [");
            sb.append(this.resourceBundle);
            sb.append("]");
        }
        return sb.toString();
    }
}

