/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.mylinks;

import java.net.URI;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.mylinks.model.CategoryDetail;
import org.silverpeas.core.web.rs.WebEntity;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CategoryEntity
implements WebEntity {
    private static final long serialVersionUID = -4596241423551371699L;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement
    @NotNull
    private int catId;
    @XmlElement(defaultValue="-1")
    private int position = -1;
    @XmlElement
    @NotNull
    private String name;
    @XmlElement
    private String description;
    @XmlElement
    private String userId;

    public static CategoryEntity fromCategoryDetail(CategoryDetail category, URI uri) {
        return new CategoryEntity(category, uri);
    }

    protected CategoryEntity() {
    }

    public CategoryEntity(CategoryDetail category, URI uri) {
        this.uri = uri;
        this.name = category.getName();
        this.description = category.getDescription();
        this.catId = category.getId();
        this.position = category.hasPosition() ? category.getPosition() : -1;
        this.userId = category.getUserId();
    }

    public URI getURI() {
        return this.uri;
    }

    public CategoryDetail toCategoryDetail() {
        CategoryDetail categoryDetail = new CategoryDetail();
        categoryDetail.setId(this.catId);
        categoryDetail.setName(this.name);
        categoryDetail.setDescription(this.description);
        categoryDetail.setUserId(this.userId);
        if (this.position != -1) {
            categoryDetail.setHasPosition(true);
            categoryDetail.setPosition(this.position);
        } else {
            categoryDetail.setHasPosition(false);
        }
        return categoryDetail;
    }

    public int getCategoryId() {
        return this.catId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUserId() {
        return this.userId;
    }

    public int getPosition() {
        return this.position;
    }
}

