/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.calendar;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.component.model.PersonalComponent;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.admin.component.model.SilverpeasPersonalComponentInstance;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.calendar.Attendee;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.CalendarEventOccurrenceGenerator;
import org.silverpeas.core.calendar.CalendarEventUtil;
import org.silverpeas.core.calendar.EventOperationResult;
import org.silverpeas.core.calendar.ICalendarEventImportProcessor;
import org.silverpeas.core.calendar.ICalendarImportResult;
import org.silverpeas.core.calendar.PlannableOnCalendar;
import org.silverpeas.core.calendar.icalendar.ICalendarExporter;
import org.silverpeas.core.calendar.view.CalendarEventInternalParticipationView;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.importexport.ExportDescriptor;
import org.silverpeas.core.importexport.ExportException;
import org.silverpeas.core.importexport.ImportException;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.web.mvc.webcomponent.WebMessager;
import org.silverpeas.core.webapi.calendar.OccurrenceEventActionMethodType;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.Base;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Base
@Named(value="defaultCalendarWebManager")
public class CalendarWebManager {
    public static final String NAME_SUFFIX = "CalendarWebManager";
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.calendar.settings.calendar");
    private final SilverLogger silverLogger = SilverLogger.getLogger(PlannableOnCalendar.class);
    private static final int END_YEAR_OFFSET = 3;
    private static final int DEFAULT_NB_MAX_NEXT_OCC = 10;
    @Inject
    private ICalendarExporter iCalendarExporter;
    @Inject
    private CalendarEventOccurrenceGenerator generator;
    @Inject
    private ICalendarEventImportProcessor iCalendarEventImportProcessor;

    protected CalendarWebManager() {
    }

    public static CalendarWebManager get(String componentInstanceIdOrComponentName) {
        if (StringUtil.isNotDefined((String)componentInstanceIdOrComponentName)) {
            return (CalendarWebManager)ServiceProvider.getService(CalendarWebManager.class, (Annotation[])new Annotation[]{new AnnotationLiteral<Base>(){}});
        }
        return (CalendarWebManager)ServiceProvider.getService((String)componentInstanceIdOrComponentName, (String)NAME_SUFFIX);
    }

    static void assertDataConsistency(String componentInstanceId, Calendar originalCalendar) {
        CalendarWebManager.assertEntityIsDefined((IdentifiableEntity)originalCalendar);
        if (!originalCalendar.getComponentInstanceId().equals(componentInstanceId)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    static void assertDataConsistency(String componentInstanceId, Calendar originalCalendar, CalendarEvent event) {
        CalendarWebManager.assertDataConsistency(componentInstanceId, originalCalendar);
        CalendarWebManager.assertEntityIsDefined((IdentifiableEntity)event.asCalendarComponent());
        if (!originalCalendar.getComponentInstanceId().equals(componentInstanceId) || !event.getCalendar().getComponentInstanceId().equals(componentInstanceId)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (!event.getCalendar().getId().equals(originalCalendar.getId())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    static void assertDataConsistency(String componentInstanceId, Calendar originalCalendar, CalendarEvent previousOne, CalendarEventOccurrence occurrence) {
        CalendarWebManager.assertDataConsistency(componentInstanceId, originalCalendar, previousOne);
        CalendarWebManager.assertEntityIsDefined((IdentifiableEntity)occurrence);
        if (!occurrence.getCalendarEvent().getCalendar().getComponentInstanceId().equals(componentInstanceId)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (!previousOne.getId().equals(occurrence.getCalendarEvent().getId())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    static void assertEntityIsDefined(IdentifiableEntity entity) {
        if (entity == null || StringUtil.isNotDefined((String)entity.getId())) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    public CalendarEvent createEvent(Calendar calendar, CalendarEvent event, String volatileEventId) {
        if (!calendar.canBeAccessedBy(User.getCurrentRequester())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        event.planOn(calendar);
        String finalEventId = event.getId();
        String instanceId = calendar.getComponentInstanceId();
        ResourceReference volatileAttachmentSourcePK = new ResourceReference(volatileEventId, instanceId);
        ResourceReference finalAttachmentSourcePK = new ResourceReference(finalEventId, instanceId);
        List movedDocumentPks = AttachmentServiceProvider.getAttachmentService().moveAllDocuments(volatileAttachmentSourcePK, finalAttachmentSourcePK);
        if (!movedDocumentPks.isEmpty()) {
            WysiwygController.wysiwygPlaceHaveChanged((String)instanceId, (String)volatileEventId, (String)instanceId, (String)finalEventId);
        }
        this.successMessage("calendar.message.event.created", event.getTitle());
        return event;
    }

    public LocalizationBundle getLocalizationBundle(String locale) {
        return ResourceLocator.getLocalizationBundle((String)"org.silverpeas.calendar.multilang.calendarBundle", (String)locale);
    }

    public List<Calendar> getCalendarsHandledBy(String componentInstanceId) {
        return this.getCalendarsHandledBy(Collections.singleton(componentInstanceId));
    }

    public List<Calendar> getCalendarsHandledBy(Collection<String> componentInstanceIds) {
        return Calendar.getByComponentInstanceIds(componentInstanceIds);
    }

    protected Calendar saveCalendar(Calendar calendar) {
        String successfulMessageKey;
        User owner = User.getCurrentRequester();
        String string = successfulMessageKey = calendar.isPersisted() ? "calendar.message.calendar.updated" : "calendar.message.calendar.created";
        if (calendar.isPersisted() && !calendar.canBeModifiedBy(User.getCurrentRequester())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        calendar.save();
        String userLanguage = owner.getUserPreferences().getLanguage();
        this.getMessager().addSuccess(this.getLocalizationBundle(userLanguage).getString(successfulMessageKey), calendar.getTitle());
        return calendar;
    }

    protected void deleteCalendar(Calendar calendar) {
        User owner = User.getCurrentRequester();
        if (!calendar.canBeDeletedBy(User.getCurrentRequester())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        calendar.delete();
        String userLanguage = owner.getUserPreferences().getLanguage();
        this.getMessager().addSuccess(this.getLocalizationBundle(userLanguage).getString("calendar.message.calendar.deleted"), calendar.getTitle());
    }

    protected void exportCalendarAsICalendarFormat(Calendar calendar, ExportDescriptor descriptor) throws ExportException {
        Mutable currentUser = Mutable.ofNullable((Object)User.getCurrentRequester());
        if (!currentUser.isPresent()) {
            SilverpeasPersonalComponentInstance.getById((String)calendar.getComponentInstanceId()).ifPresent(i -> currentUser.set((Object)i.getUser()));
        }
        if (currentUser.isPresent() && calendar.isMainPersonalOf((User)currentUser.get())) {
            this.iCalendarExporter.exports(descriptor, () -> Stream.concat(Calendar.getEvents().filter(f -> f.onCalendar(new Calendar[]{calendar})).stream(), Calendar.getEvents().filter(f -> f.onParticipants(new User[]{(User)currentUser.get()})).stream()).distinct());
        } else {
            this.iCalendarExporter.exports(descriptor, () -> Calendar.getEvents().filter(f -> f.onCalendar(new Calendar[]{calendar})).stream());
        }
    }

    protected void synchronizeCalendar(Calendar calendar) throws ImportException {
        if (calendar.getExternalCalendarUrl() == null) {
            throw new WebApplicationException("aimed calendar is not a synchronized one", Response.Status.FORBIDDEN);
        }
        String calendarTitle = calendar.getTitle();
        String calendarId = calendar.getId();
        this.silverLogger.info("start event synchronization of calendar {0} (id={1})", new Object[]{calendarTitle, calendarId});
        ICalendarImportResult result = calendar.synchronize();
        this.silverLogger.info("end event synchronization of calendar {0} (id={1}), with {2} created events, {3} updated events and {4} deleted events", new Object[]{calendarTitle, calendarId, result.added(), result.updated(), result.deleted()});
        this.successMessage("calendar.message.calendar.synchronized", calendar.getTitle(), result.added(), result.updated(), result.deleted());
    }

    protected void importEventsAsICalendarFormat(Calendar calendar, InputStream inputStream) throws ImportException {
        String calendarTitle = calendar.getTitle();
        String calendarId = calendar.getId();
        this.silverLogger.info("start event import into calendar {0} (id={1})", new Object[]{calendarTitle, calendarId});
        ICalendarImportResult result = this.iCalendarEventImportProcessor.importInto(calendar, inputStream);
        this.silverLogger.info("end event import into calendar {0} (id={1}), with {2} created events and {3} updated events", new Object[]{calendarTitle, calendarId, result.added(), result.updated()});
        this.successMessage("calendar.message.event.imported", calendarTitle, result.added(), result.updated());
    }

    protected List<CalendarEvent> saveOccurrence(CalendarEventOccurrence occurrence, OccurrenceEventActionMethodType updateMethodType, ZoneId zoneId) {
        EventOperationResult result;
        if (!occurrence.getCalendarEvent().canBeModifiedBy(User.getCurrentRequester())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        OccurrenceEventActionMethodType methodType = updateMethodType == null ? OccurrenceEventActionMethodType.ALL : updateMethodType;
        String originalTitle = occurrence.getCalendarEvent().getTitle();
        Temporal originalStartDate = occurrence.getOriginalStartDate();
        switch (methodType) {
            case FROM: {
                result = occurrence.updateSinceMe();
                break;
            }
            case UNIQUE: {
                result = occurrence.update();
                break;
            }
            default: {
                CalendarEvent event = occurrence.getCalendarEvent();
                occurrence.asCalendarComponent().copyTo(event.asCalendarComponent());
                result = event.update();
            }
        }
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        Optional createdEvent = result.created();
        Optional updatedEvent = result.updated();
        Optional updatedOccurrence = result.instance();
        updatedOccurrence.ifPresent(o -> {
            CalendarEvent event = o.getCalendarEvent();
            this.successMessage("calendar.message.event.occurrence.updated.unique", originalTitle, this.getMessager().formatDate(CalendarEventUtil.getDateWithOffset((CalendarComponent)event.asCalendarComponent(), (Temporal)originalStartDate, (ZoneId)zoneId)));
            events.add(event);
        });
        updatedEvent.ifPresent(e -> {
            if (createdEvent.isEmpty()) {
                this.successMessage("calendar.message.event.updated", e.getTitle());
            } else {
                Temporal endDate = (Temporal)e.getRecurrence().getRecurrenceEndDate().get();
                this.successMessage("calendar.message.event.occurrence.updated.from", e.getTitle(), this.getMessager().formatDate(CalendarEventUtil.getDateWithOffset((CalendarComponent)e.asCalendarComponent(), (Temporal)endDate, (ZoneId)zoneId)));
            }
            events.add((CalendarEvent)e);
        });
        createdEvent.ifPresent(e -> {
            events.add((CalendarEvent)e);
            this.successMessage("calendar.message.event.created", e.getTitle());
        });
        return events;
    }

    protected CalendarEvent deleteOccurrence(CalendarEventOccurrence occurrence, OccurrenceEventActionMethodType deleteMethodType, ZoneId zoneId) {
        EventOperationResult result;
        if (!occurrence.getCalendarEvent().canBeDeletedBy(User.getCurrentRequester())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        OccurrenceEventActionMethodType methodType = deleteMethodType == null ? OccurrenceEventActionMethodType.ALL : deleteMethodType;
        switch (methodType) {
            case FROM: {
                result = occurrence.deleteSinceMe();
                break;
            }
            case UNIQUE: {
                result = occurrence.delete();
                break;
            }
            default: {
                result = occurrence.getCalendarEvent().delete();
            }
        }
        Optional updatedEvent = result.updated();
        if (updatedEvent.isEmpty() || !((CalendarEvent)updatedEvent.get()).isRecurrent()) {
            this.successMessage("calendar.message.event.deleted", occurrence.getTitle());
        } else {
            Temporal endDate;
            String bundleKey;
            if (methodType == OccurrenceEventActionMethodType.UNIQUE) {
                bundleKey = "calendar.message.event.occurrence.deleted.unique";
                endDate = occurrence.getOriginalStartDate();
            } else {
                bundleKey = "calendar.message.event.occurrence.deleted.from";
                endDate = (Temporal)((CalendarEvent)updatedEvent.get()).getRecurrence().getRecurrenceEndDate().orElseThrow(() -> new SilverpeasRuntimeException("No Recurrence end date!"));
            }
            this.successMessage(bundleKey, occurrence.getTitle(), this.getMessager().formatDate(CalendarEventUtil.getDateWithOffset((CalendarComponent)occurrence.asCalendarComponent(), (Temporal)endDate, (ZoneId)zoneId)));
        }
        return updatedEvent.orElse(null);
    }

    protected CalendarEvent updateOccurrenceAttendeeParticipation(CalendarEventOccurrence occurrence, String attendeeId, Attendee.ParticipationStatus participationStatus, OccurrenceEventActionMethodType answerMethodType, ZoneId zoneId) {
        OccurrenceEventActionMethodType methodType = answerMethodType == null ? OccurrenceEventActionMethodType.ALL : answerMethodType;
        Mutable modifiedEvent = Mutable.empty();
        if (methodType == OccurrenceEventActionMethodType.UNIQUE) {
            Optional<EventOperationResult> optionalResult = this.updateSingleOccurrenceAttendeeParticipation(occurrence, attendeeId, participationStatus);
            optionalResult.ifPresent(r -> {
                modifiedEvent.set((Object)((CalendarEventOccurrence)r.instance().orElseThrow(() -> new SilverpeasRuntimeException("No event occurrence in the operation result!"))).getCalendarEvent());
                this.successMessage("calendar.message.event.occurrence.attendee.participation.updated.unique", occurrence.getTitle(), this.getMessager().formatDate(CalendarEventUtil.getDateWithOffset((CalendarComponent)occurrence.asCalendarComponent(), (Temporal)occurrence.getOriginalStartDate(), (ZoneId)zoneId)));
            });
        } else if (methodType == OccurrenceEventActionMethodType.ALL) {
            Optional<EventOperationResult> optionalResult = this.updateEventAttendeeParticipation(occurrence, attendeeId, participationStatus);
            optionalResult.ifPresent(r -> {
                r.updated().ifPresentOrElse(arg_0 -> ((Mutable)modifiedEvent).set(arg_0), () -> modifiedEvent.set((Object)((CalendarEventOccurrence)r.instance().orElseThrow(() -> new SilverpeasRuntimeException("No event occurrence in the operation result!"))).getCalendarEvent()));
                this.successMessage("calendar.message.event.attendee.participation.updated", occurrence.getCalendarEvent().getTitle());
            });
        }
        return (CalendarEvent)modifiedEvent.orElseThrow(() -> new WebApplicationException(Response.Status.FORBIDDEN));
    }

    private Optional<EventOperationResult> updateEventAttendeeParticipation(CalendarEventOccurrence occurrence, String attendeeId, Attendee.ParticipationStatus participationStatus) {
        EventOperationResult result = null;
        Optional<Attendee> attendee = occurrence.getCalendarEvent().getAttendees().stream().filter(a -> a.getId().equals(attendeeId)).findFirst();
        if (attendee.isPresent()) {
            this.setAttendeeStatus(participationStatus, attendee.get());
            result = occurrence.getCalendarEvent().update();
        } else {
            List allOccurrences = occurrence.getCalendarEvent().getPersistedOccurrences();
            for (CalendarEventOccurrence eventOccurrence : allOccurrences) {
                Optional<EventOperationResult> optionalResult = this.updateSingleOccurrenceAttendeeParticipation(eventOccurrence, attendeeId, participationStatus);
                if (result != null || !optionalResult.isPresent()) continue;
                result = optionalResult.get();
            }
        }
        return Optional.ofNullable(result);
    }

    private Optional<EventOperationResult> updateSingleOccurrenceAttendeeParticipation(CalendarEventOccurrence occurrence, String attendeeId, Attendee.ParticipationStatus participationStatus) {
        Optional<Attendee> attendee = occurrence.getAttendees().stream().filter(a -> a.getId().equals(attendeeId)).findFirst();
        if (attendee.isPresent()) {
            this.setAttendeeStatus(participationStatus, attendee.get());
            return Optional.of(occurrence.update());
        }
        return Optional.empty();
    }

    private void setAttendeeStatus(Attendee.ParticipationStatus participationStatus, Attendee attendee) {
        switch (participationStatus) {
            case ACCEPTED: {
                attendee.accept();
                break;
            }
            case DECLINED: {
                attendee.decline();
                break;
            }
            case TENTATIVE: {
                attendee.tentativelyAccept();
                break;
            }
            default: {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
        }
    }

    public CalendarEventOccurrence getFirstCalendarEventOccurrenceFromEventId(String eventId) {
        CalendarEvent event = CalendarEvent.getById((String)eventId);
        Temporal startTemporal = event.getStartDate();
        Temporal endTemporal = !event.isRecurrent() ? event.getEndDate() : event.getEndDate().plus(3L, ChronoUnit.YEARS);
        return (CalendarEventOccurrence)this.generator.generateOccurrencesOf(Collections.singletonList(event), Period.between((Temporal)startTemporal, (Temporal)endTemporal)).get(0);
    }

    public List<CalendarEventOccurrence> getEventOccurrencesOf(LocalDate startDate, LocalDate endDate, List<Calendar> calendars) {
        return this.getEventOccurrencesOf(startDate, endDate, calendars, User.getCurrentRequester());
    }

    public List<CalendarEventOccurrence> getEventOccurrencesOf(LocalDate startDate, LocalDate endDate, List<Calendar> calendars, User currentRequester) {
        if (currentRequester == null) {
            throw new IllegalArgumentException("Current requester MUST be defined");
        }
        return calendars.isEmpty() ? Collections.emptyList() : Calendar.getTimeWindowBetween((LocalDate)startDate, (LocalDate)endDate).filter(f -> f.onCalendar(calendars)).getEventOccurrences();
    }

    protected Map<String, List<CalendarEventOccurrence>> getAllEventOccurrencesByUserIds(Pair<List<String>, User> currentUserAndComponentInstanceId, LocalDate startDate, LocalDate endDate, Collection<User> users) {
        ArrayList personalCalendars = new ArrayList();
        users.forEach(u -> personalCalendars.addAll(this.getCalendarsHandledBy(PersonalComponentInstance.from((User)u, (PersonalComponent)PersonalComponent.getByName((String)"userCalendar").orElse(null)).getId())));
        List entities = personalCalendars.isEmpty() ? Collections.emptyList() : Calendar.getTimeWindowBetween((LocalDate)startDate, (LocalDate)endDate).filter(f -> f.onCalendar(personalCalendars)).getEventOccurrences();
        entities.addAll(Calendar.getTimeWindowBetween((LocalDate)startDate, (LocalDate)endDate).filter(f -> f.onParticipants(users)).getEventOccurrences());
        Map result = new CalendarEventInternalParticipationView(users).apply(entities.stream().distinct().collect(Collectors.toList()));
        String currentUserId = ((User)currentUserAndComponentInstanceId.getRight()).getId();
        if (result.containsKey(currentUserId)) {
            List currentUserOccurrences = (List)result.get(currentUserId);
            currentUserOccurrences.removeIf(calendarEventOccurrence -> {
                CalendarEvent event = calendarEventOccurrence.getCalendarEvent();
                return ((List)currentUserAndComponentInstanceId.getLeft()).contains(event.getCalendar().getComponentInstanceId()) && event.getCreator().getId().equals(currentUserId);
            });
        } else {
            result.put(currentUserId, Collections.emptyList());
        }
        return result;
    }

    public Stream<CalendarEventOccurrence> getNextEventOccurrences(List<String> componentIds, Set<String> calendarIdsToExclude, Set<User> usersToInclude, Set<String> calendarIdsToInclude, ZoneId zoneId, Integer limit) {
        User currentRequester = User.getCurrentRequester();
        List<Calendar> calendars = this.getCalendarsHandledBy(componentIds);
        calendarIdsToInclude.removeAll(calendarIdsToExclude);
        calendars.removeIf(c -> calendarIdsToExclude.contains(c.getId()));
        if (!calendarIdsToInclude.isEmpty()) {
            calendars.forEach(c -> calendarIdsToInclude.remove(c.getId()));
            calendarIdsToInclude.forEach(i -> {
                Calendar calendarToInclude = Calendar.getById((String)i);
                if (calendarToInclude.canBeAccessedBy(currentRequester)) {
                    calendars.add(calendarToInclude);
                }
            });
        }
        int nbOccLimit = limit != null && limit > 0 && limit <= 500 ? limit : 10;
        LocalDate startDate = zoneId != null ? LocalDateTime.now(zoneId).toLocalDate() : LocalDate.now();
        HashSet<CalendarEventOccurrence> occurrences = new HashSet<CalendarEventOccurrence>();
        Integer[] integerArray = this.getNextEventTimeWindows();
        int n = integerArray.length;
        for (int j = 0; j < n; ++j) {
            int nbMonthsToAdd = integerArray[j];
            occurrences.clear();
            LocalDate endDate = startDate.plusMonths(nbMonthsToAdd);
            occurrences.addAll(this.getEventOccurrencesOf(startDate, endDate, calendars));
            if (!usersToInclude.isEmpty()) {
                this.getAllEventOccurrencesByUserIds((Pair<List<String>, User>)Pair.of(componentIds, (Object)currentRequester), startDate, endDate, usersToInclude).forEach((u, o) -> occurrences.addAll((Collection<CalendarEventOccurrence>)o));
            }
            if (occurrences.size() >= nbOccLimit) break;
        }
        return occurrences.stream().sorted(CalendarEventOccurrence.COMPARATOR_BY_DATE_ASC).limit(nbOccLimit);
    }

    protected Integer[] getNextEventTimeWindows() {
        String[] timeWindows = settings.getString("calendar.nextEvents.time.windows").split(",");
        return (Integer[])Arrays.stream(timeWindows).map(w -> Integer.parseInt(w.trim())).toArray(Integer[]::new);
    }

    private void successMessage(String messageKey, Object ... params) {
        User owner = User.getCurrentRequester();
        String userLanguage = owner.getUserPreferences().getLanguage();
        this.getMessager().addSuccess(this.getLocalizationBundle(userLanguage).getString(messageKey), params);
    }

    private WebMessager getMessager() {
        return WebMessager.getInstance();
    }
}

