/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.calendar;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.net.URI;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.calendar.Attendee;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CalendarEventAttendeeEntity
implements WebEntity {
    private URI uri;
    private String id;
    private String fullName;
    private Attendee.ParticipationStatus participationStatus;
    private Attendee.PresenceStatus presenceStatus;

    protected CalendarEventAttendeeEntity() {
    }

    public static CalendarEventAttendeeEntity from(Attendee attendee) {
        return new CalendarEventAttendeeEntity().decorate(attendee);
    }

    public <T extends CalendarEventAttendeeEntity> T withURI(URI uri) {
        this.uri = uri;
        return (T)this;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.withURI(uri);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Attendee.ParticipationStatus getParticipationStatus() {
        return this.participationStatus;
    }

    public void setParticipationStatus(Attendee.ParticipationStatus participationStatus) {
        this.participationStatus = participationStatus;
    }

    public Attendee.PresenceStatus getPresenceStatus() {
        return this.presenceStatus;
    }

    public void setPresenceStatus(Attendee.PresenceStatus presenceStatus) {
        this.presenceStatus = presenceStatus;
    }

    @XmlTransient
    Attendee addTo(CalendarComponent component) {
        Attendee attendee = null;
        for (Attendee anAttendee : component.getAttendees()) {
            if (!this.getId().equals(anAttendee.getId())) continue;
            attendee = anAttendee;
            break;
        }
        if (attendee == null) {
            attendee = StringUtil.isLong((String)this.getId()) ? component.getAttendees().add(User.getById((String)this.getId())) : component.getAttendees().add(this.getId());
        }
        attendee.withPresenceStatus(this.getPresenceStatus());
        return attendee;
    }

    protected CalendarEventAttendeeEntity decorate(Attendee attendee) {
        this.id = attendee.getId();
        this.fullName = attendee.getFullName();
        this.participationStatus = attendee.getParticipationStatus();
        this.presenceStatus = attendee.getPresenceStatus();
        return this;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("uri", (Object)this.getURI());
        builder.append("attendeeId", (Object)this.getId());
        builder.append("fullName", (Object)this.getFullName());
        builder.append("participationStatus", (Object)this.getParticipationStatus());
        builder.append("presenceStatus", (Object)this.getPresenceStatus());
        return builder.toString();
    }
}

