/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.pagination;

import java.util.Date;
import java.util.List;
import org.apache.ecs.html.IMG;
import org.silverpeas.core.web.util.viewgenerator.html.pagination.AbstractPagination;
import org.silverpeas.core.web.util.viewgenerator.html.pagination.PaginationUtil;
import org.silverpeas.kernel.util.StringUtil;

public class PaginationSP
extends AbstractPagination {
    private static final String INDEX_PARAM = "?Index=";

    @Override
    public String printCounter() {
        return PaginationUtil.formatFromFirstIndexOfItem(this.getNbItemsPerPage(), this.getNbItems(), this.getFirstItemIndex());
    }

    @Override
    public String printIndex() {
        return this.printIndex(null, true);
    }

    @Override
    public String printIndex(String javascriptFunc) {
        return this.printIndex(javascriptFunc, StringUtil.isNotDefined((String)javascriptFunc));
    }

    @Override
    public String printIndex(String javascriptFunc, boolean nbItemsPerPage) {
        StringBuilder result = new StringBuilder();
        if (this.getNbItems() > this.getIndexThreshold()) {
            result.append("<div class=\"pageNav\">");
            result.append("<div class=\"pageNavContent\">");
            int maxCurrentIndex = Math.min(this.getFirstItemIndex() + this.getNbItemsPerPage(), this.getNbItems());
            result.append("<div class=\"itemIndex\">");
            result.append(this.getFirstItemIndex() + 1).append("-").append(maxCurrentIndex);
            result.append("/").append(this.getNbItems());
            result.append("</div>");
            result.append(this.getPageIndexFragment());
            result.append(this.getPageBrowsingFragment(javascriptFunc));
            result.append(this.getNbItemsPerPageFragment(nbItemsPerPage, javascriptFunc));
            result.append(this.getJumperFragment("</div></div>", javascriptFunc));
        }
        return result.toString();
    }

    private String getPageBrowsingFragment(String javascriptFunc) {
        int index;
        boolean displayPreviousNext;
        StringBuilder result = new StringBuilder();
        result.append("<div class=\"pageClicToGo\">");
        int currentPage = this.getCurrentPage();
        int nbPage = this.getNbPage();
        boolean bl = displayPreviousNext = nbPage > this.getNumberPageThreshold();
        if (displayPreviousNext && this.getFirstItemIndex() >= this.getNbItemsPerPage()) {
            int nbHiddenOnLeft = currentPage - this.getNumberPageOnCurrentLeft(currentPage);
            if (nbHiddenOnLeft > 1) {
                result.append("<a class=\"pageOff\"");
                result.append(this.getLink(javascriptFunc, 0, this.getString("GEF.pagination.firstPage")));
                result.append(this.getImg("/arrows/arrowDoubleLeft.png", "GEF.pagination.firstPage"));
                result.append("</a>");
            }
            result.append("<a class=\"pageOff\"");
            index = this.getIndexForPreviousPage();
            result.append(this.getLink(javascriptFunc, index, this.getString("GEF.pagination.previousPage")));
            result.append(this.getImg("/arrows/arrowLeft.png", "GEF.pagination.previousPage"));
            result.append("</a>");
        }
        if (nbPage > 1) {
            for (int i = 1; i <= nbPage; ++i) {
                if (i == currentPage) {
                    result.append("<a class=\"pageOn\">");
                    result.append(i).append("</a>");
                    continue;
                }
                int nbLeftPages = this.getNumberPageOnCurrentLeft(currentPage);
                int nbRightPages = this.getNumberPageOnCurrentRight(currentPage);
                if (currentPage - nbLeftPages > i || i > currentPage + nbRightPages) continue;
                int index2 = this.getIndexForDirectPage(i);
                result.append("<a class=\"pageOff\"");
                result.append(this.getLink(javascriptFunc, index2, this.getStringWithParam("GEF.pagination.gotoPage", String.valueOf(i))));
                result.append(i).append("</a>");
            }
        }
        if (displayPreviousNext && !this.isLastPage()) {
            int nbHiddenOnRight = currentPage + this.getNumberPageOnCurrentRight(currentPage);
            index = this.getIndexForNextPage();
            result.append("<a class=\"pageOff\"");
            result.append(this.getLink(javascriptFunc, index, this.getString("GEF.pagination.nextPage")));
            result.append(this.getImg("/arrows/arrowRight.png", "GEF.pagination.nextPage"));
            result.append("</a>");
            if (nbHiddenOnRight < nbPage) {
                result.append("<a class=\"pageOff\"");
                result.append(this.getLink(javascriptFunc, this.getIndexForLastPage(), this.getString("GEF.pagination.lastPage")));
                result.append(this.getImg("/arrows/arrowDoubleRight.png", "GEF.pagination.lastPage"));
                result.append("</a>");
            }
        }
        result.append("</div>");
        return result.toString();
    }

    private String getPageIndexFragment() {
        StringBuilder fragment = new StringBuilder();
        if (this.displayTotalNumberOfPages() && this.getNbPage() > this.getNumberPageOnCurrentRight(this.getCurrentPage())) {
            fragment.append("<div class=\"pageIndex\">");
            fragment.append(this.getStringWithParam("GEF.pagination.pageOn", String.valueOf(this.getCurrentPage()), String.valueOf(this.getNbPage())));
            fragment.append("</div>");
        }
        return fragment.toString();
    }

    private String getJumperFragment(String beforeScript, String javascriptFunc) {
        StringBuilder fragment = new StringBuilder();
        boolean displayJumper = this.getNbPage() > this.getJumperThreshold();
        long timeStamp = new Date().getTime();
        String jumperName = "jumper" + timeStamp;
        if (displayJumper) {
            fragment.append("<div class=\"pageJumper\">");
            fragment.append("<a href=\"javascript:display").append(jumperName).append("()\" onfocus=\"this.blur()\" title=\"").append(this.getString("GEF.pagination.jumptoPage")).append("\">").append(this.getString("GEF.pagination.jumper")).append(" </a>");
            fragment.append("<input type=\"text\" class=\"jumper\" id=\"").append(jumperName).append("\" size=\"3\" onkeydown=\"check").append(jumperName).append("Submit(event)\"/>");
            fragment.append("</div>\n");
        }
        fragment.append(beforeScript);
        if (displayJumper) {
            fragment.append(this.getJumperScript(jumperName, javascriptFunc));
        }
        return fragment.toString();
    }

    private String getNbItemsPerPageFragment(boolean nbItemsPerPage, String javascriptFunc) {
        StringBuilder fragment = new StringBuilder();
        if (nbItemsPerPage && this.getNbItems() > this.getNumberPerPageThreshold()) {
            fragment.append("<div class=\"pageIndex numberPerPage\">");
            List<Integer> values = this.getNbItemPerPageList();
            for (int i = 0; i < values.size(); ++i) {
                int value = values.get(i);
                if (this.getNbItems() <= value && (i == 0 || this.getNbItems() <= values.get(i - 1))) continue;
                if (this.getNbItemsPerPage() == value) {
                    fragment.append("<a class=\"selected\">").append(value).append("</a>");
                    continue;
                }
                fragment.append("<a href=\"").append(this.getNbItemsPerPageLink(javascriptFunc, value)).append("\" title=\"").append(this.getStringWithParam("GEF.pagination.perPage", String.valueOf(value))).append("\">").append(value).append("</a>");
            }
            int allThreshold = this.getPaginationAllThreshold();
            if (this.getNbItems() < allThreshold) {
                if (this.getNbItemsPerPage() == allThreshold) {
                    fragment.append("<a class=\"selected\">").append(this.getString("GEF.pagination.all")).append("</a>");
                } else {
                    fragment.append("<a href=\"").append(this.getNbItemsPerPageLink(javascriptFunc, allThreshold)).append("\" title=\"").append(this.getString("GEF.pagination.all.title")).append("\">").append(this.getString("GEF.pagination.all")).append("</a>");
                }
            }
            fragment.append("</div>");
        }
        return fragment.toString();
    }

    private String getNbItemsPerPageLink(String javascriptFunc, int nbItems) {
        StringBuilder link2 = new StringBuilder();
        if (StringUtil.isNotDefined((String)javascriptFunc)) {
            if (this.getBaseURL() != null) {
                link2.append(this.getBaseURL()).append("0").append("&ItemsPerPage=").append(nbItems);
            }
        } else {
            link2.append("javascript:onclick=").append(javascriptFunc).append("(0, ").append(nbItems).append(")");
        }
        return link2.toString();
    }

    private String getLink(String javascriptFunc, int index, String title2) {
        StringBuilder link2 = new StringBuilder();
        link2.append(" title=\"").append(title2).append("\"").append(" href=\"");
        String action = "Pagination" + this.getActionSuffix();
        if (StringUtil.isNotDefined((String)javascriptFunc)) {
            if (this.getBaseURL() != null) {
                link2.append(this.getBaseURL()).append(index);
            } else {
                link2.append(action).append(INDEX_PARAM).append(index);
            }
        } else {
            link2.append("javascript:onClick=").append(javascriptFunc).append("(").append(index).append(")");
        }
        link2.append("\">");
        return link2.toString();
    }

    private String getImg(String imgSrc, String altKey) {
        IMG img = new IMG(this.getIconsPath() + imgSrc);
        img.setBorder(0);
        img.setAlign("absmiddle");
        img.setAlt(this.getString(altKey));
        return img.toString();
    }

    private String getJumperScript(String jumperName, String javascriptFunc) {
        StringBuilder result = new StringBuilder();
        result.append("<script type=\"text/javascript\">");
        result.append("function display").append(jumperName).append("() {");
        result.append("var $jumperInput = jQuery('#").append(jumperName).append("');");
        result.append("if ($jumperInput.css('visibility') !== 'visible') {");
        result.append("$jumperInput.css('visibility', 'visible');");
        result.append("$jumperInput.hide();$jumperInput.focus();");
        result.append("$jumperInput.show();$jumperInput.focus();");
        result.append("} else {");
        result.append("$jumperInput.css('visibility', 'hidden');");
        result.append("}");
        result.append("}");
        result.append("function check").append(jumperName).append("Submit(ev) {");
        result.append("var touche = ev.keyCode;");
        result.append("if (touche == 13) {");
        result.append("var index = parseInt(document.getElementById(\"").append(jumperName).append("\").value);");
        result.append("if (isNaN(index) || index <= 0) { index = 1; }");
        result.append("if (index > ").append(this.getNbPage()).append(") { index = ").append(this.getNbPage()).append("; }");
        result.append("index = (index-1)*").append(this.getNbItemsPerPage()).append(";");
        if (StringUtil.isDefined((String)javascriptFunc)) {
            result.append(javascriptFunc).append("(index);");
        } else if (this.getBaseURL() != null) {
            result.append("if (typeof ").append(jumperName).append(".ajax === 'function') {");
            result.append(jumperName).append(".ajax('").append(this.getBaseURL()).append("'+index").append(")");
            result.append("} else {location.href=\"").append(this.getBaseURL()).append("\"+index;}");
        } else {
            String action = "Pagination" + this.getActionSuffix();
            result.append("if (typeof ").append(jumperName).append(".ajax === 'function') {");
            result.append(jumperName).append(".ajax('").append(action).append(INDEX_PARAM).append("'+index").append(")");
            result.append("} else {location.href=\"").append(action).append(INDEX_PARAM).append("\"+index;}");
        }
        result.append("}");
        result.append("}");
        result.append("</script>\n");
        return result.toString();
    }

    @Override
    public String print() {
        return this.printIndex();
    }
}

