/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.arraypanes;

import java.util.Collections;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.AbstractArrayPane;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCell;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCellLink;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayCellText;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayColumn;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayEmptyCell;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayLine;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.pagination.WADataPage;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.pagination.WADataPaginator;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.pagination.WAItem;
import org.silverpeas.kernel.logging.SilverLogger;

public class ArrayPaneWithDataSource
extends AbstractArrayPane {
    WADataPaginator m_DataSource = null;
    ArrayLine m_ArrayLine = null;

    public ArrayPaneWithDataSource(String name, PageContext pageContext) {
        if (pageContext != null) {
            this.init(name, null, pageContext.getRequest(), pageContext.getSession());
        } else {
            this.init(name, null, null, null);
        }
    }

    public ArrayPaneWithDataSource(String name, ServletRequest request, HttpSession session) {
        this.init(name, null, request, session);
    }

    public void setDataSource(WADataPaginator p) {
        this.m_DataSource = p;
        this.m_ArrayLine = new ArrayLine(this);
    }

    public ArrayPaneWithDataSource(String name, String url, ServletRequest request, HttpSession session) {
        this.init(name, url, request, session);
    }

    private String printPseudoColumn() {
        return "<td>&nbsp;</td>";
    }

    @Override
    public String print() {
        if (this.m_DataSource == null) {
            return this.standardPrint();
        }
        return this.dataSourcePrint();
    }

    private String dataSourcePrint() {
        int i;
        int columnsCount = 0;
        int sortCol = 0;
        WADataPage page = null;
        String pageActionString = "none";
        try {
            columnsCount = this.m_DataSource.getHeader().getFieldCount();
            sortCol = this.getColumnToSort();
            if (sortCol != 0) {
                if (sortCol < 0) {
                    sortCol = -sortCol;
                }
                this.m_DataSource.getHeader().toggleFieldSortOrder(sortCol - 1);
                this.setColumnToSort(0);
            }
            if (this.getState() != null) {
                if (this.getState().getFirstVisibleLine() > 0) {
                    pageActionString = "next";
                    page = this.m_DataSource.getNextPage();
                } else if (this.getState().getFirstVisibleLine() < 0) {
                    pageActionString = "previous";
                    page = this.m_DataSource.getPreviousPage();
                } else {
                    pageActionString = "current";
                    page = this.m_DataSource.getCurrentPage();
                    if (page == null) {
                        pageActionString = "first";
                        page = this.m_DataSource.getFirstPage();
                    }
                }
                this.getState().setFirstVisibleLine(0);
            } else {
                pageActionString = "next";
                page = this.m_DataSource.getNextPage();
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return "";
        }
        if (page == null) {
            return "";
        }
        int pageNumber = this.m_DataSource.getCurrentPageNumber();
        int firstItemNumber = page.getStartItemDocumentIndex();
        int lastItemNumber = page.getEndItemDocumentIndex();
        int itemCount = this.m_DataSource.getItemCount();
        int pageItemCount = page.getItemCount();
        StringBuilder result = new StringBuilder();
        result.append("<table width=\"98%\" class=\"ArrayColumn\" cellspacing=0 cellpadding=2 border=0><tr><td>\n");
        result.append("<table bgcolor=\"ffffff\" width=\"100%\" cellspacing=\"").append(this.getCellSpacing()).append("\" cellpadding=\"").append(this.getCellPadding()).append("\">");
        if (this.getTitle() != null) {
            result.append("<tr>");
            result.append("<td class=\"txttitrecol\" colspan=\"").append(columnsCount).append("\">");
            result.append(this.getTitle());
            result.append("</td>");
            result.append("</tr>\n");
        }
        result.append("<tr>");
        for (i = 0; i < columnsCount; ++i) {
            ArrayColumn ac = new ArrayColumn(this.m_DataSource.getHeader().getFieldDisplayName(i), i + 1, this);
            String fra = this.m_DataSource.getHeader().getFieldRoutingAddress(i);
            if (fra == null) {
                ac.setRoutingAddress(this.getUrl());
            } else {
                ac.setRoutingAddress(fra);
                if ("".equals(fra)) {
                    ac.setSortable(false);
                }
            }
            if (this.getRequest() != null) {
                result.append(ac.print());
            }
            if (this.getCellSpacing() != 0) continue;
            result.append(this.printPseudoColumn());
        }
        result.append("</tr>\n");
        for (i = 0; i < pageItemCount; ++i) {
            WAItem item = null;
            item = i == 0 ? page.getFirstItem() : page.getNextItem();
            result.append("<tr id=\"" + i + "\">\n");
            result.append(result + "<!-- column count is + " + columnsCount + " -->\n");
            for (int j = 0; j < columnsCount; ++j) {
                ArrayCell ct;
                String name = this.m_DataSource.getHeader().getFieldName(j);
                String value = item.getFieldByName(name);
                String anchor = item.getAnchorByName(name);
                String style = item.getStyle();
                if (anchor == null) {
                    ct = new ArrayCellText(value, this.m_ArrayLine);
                    if (style != null) {
                        ct.setStyleSheet(style);
                    }
                    result.append(ct.print());
                } else {
                    ct = new ArrayCellLink(value, anchor, this.m_ArrayLine);
                    if (style != null) {
                        ct.setStyleSheet(style);
                    }
                    result.append(ct.print());
                }
                if (this.getCellSpacing() != 0) continue;
                result.append(new ArrayEmptyCell().print());
            }
            result.append("</tr>\n");
        }
        result.append("</table>\n");
        if (-1 != this.getState().getMaximumVisibleLine()) {
            Object url;
            String iconPath = this.getIconsPath();
            result.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"ArrayColumn\">\n").append("<tr align=\"center\" bgcolor=\"#999999\">\n").append("<td><img src=\"").append(iconPath).append("1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n").append("</tr>\n").append("<tr align=\"center\" bgcolor=\"#FFFFFF\">\n").append("<td><img src=\"").append(iconPath).append("1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n").append("</tr>\n").append("<tr align=\"center\"> \n").append("<td class=\"ArrayNavigation\" height=\"20\">");
            if (pageNumber > 0) {
                result.append("<a class=\"ArrayNavigation\" href=\"");
                url = this.getUrl();
                url = !((String)url).contains("?") ? (String)url + "?" : (String)url + "&";
                url = (String)url + "ArrayPaneAction=Previous&ArrayPaneTarget=" + this.getName();
                result.append((String)url).append("\"><< Pr&eacute;c&eacute;dent </a>  | ");
            }
            if (firstItemNumber != lastItemNumber) {
                result.append(firstItemNumber + 1).append(" - ").append(lastItemNumber);
            } else {
                result.append(firstItemNumber + 1);
            }
            result.append(" / ").append(itemCount);
            if (lastItemNumber + 1 < itemCount) {
                result.append(" | <a class=\"ArrayNavigation\" href=\"");
                url = this.getUrl();
                url = !((String)url).contains("?") ? (String)url + "?" : (String)url + "&";
                url = (String)url + "ArrayPaneAction=Next&ArrayPaneTarget=" + this.getName();
                result.append((String)url).append("\">Suivant >></a>");
            }
            result.append("</td></tr>\n").append("<tr align=\"center\" bgcolor=\"#999999\">\n<td><img src=\"").append(iconPath).append("1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n</tr>\n").append("<tr align=\"center\" bgcolor=\"#666666\">\n<td><img src=\"").append(iconPath).append("1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n</tr>\n").append("</table>");
        }
        result.append("</td></tr></table>\n");
        return result.toString();
    }

    private String standardPrint() {
        int first = -1;
        int last = -1;
        if (this.getColumnToSort() != 0) {
            Collections.sort(this.getLines());
        }
        int columnsCount = this.getColumns().size();
        if (this.getCellSpacing() == 0) {
            columnsCount *= 2;
        }
        StringBuilder result = new StringBuilder();
        result.append("<table width=\"98%\" class=\"ArrayColumn\" cellspacing=0 cellpadding=2 border=0><tr><td>\n");
        result.append("<table bgcolor=\"ffffff\" width=\"100%\" cellspacing=\"").append(this.getCellSpacing()).append("\" cellpadding=\"").append(this.getCellPadding()).append("\">");
        if (this.getTitle() != null) {
            result.append("<tr>");
            result.append("<td class=\"txttitrecol\" colspan=\"").append(columnsCount).append("\">");
            result.append(this.getTitle());
            result.append("</td>");
            result.append("</tr>\n");
        }
        result.append("<tr>");
        for (ArrayColumn column : this.getColumns()) {
            result.append(column.print());
            if (this.getCellSpacing() != 0) continue;
            result.append(this.printPseudoColumn());
        }
        result.append("</tr>\n");
        if (this.getLines().isEmpty()) {
            result.append("<tr><td>&nbsp;</td></tr>\n");
        } else {
            int max = this.getState().getMaximumVisibleLine();
            if (max == -1) {
                max = this.getLines().size();
            }
            if ((first = this.getState().getFirstVisibleLine()) > this.getLines().size() - max) {
                first = this.getLines().size() - max;
            }
            if (first < 0) {
                first = 0;
            }
            this.getState().setFirstVisibleLine(first);
            int i = first;
            while (i < this.getLines().size() && i < first + max) {
                if (this.getCellSpacing() == 0) {
                    result.append(this.getLines().get(i).printWithPseudoColumns());
                } else {
                    result.append(this.getLines().get(i).print());
                }
                last = i++;
            }
        }
        result.append("</table>\n");
        if (-1 != this.getState().getMaximumVisibleLine()) {
            String iconPath = this.getIconsPath();
            result.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"ArrayColumn\">\n").append("<tr align=\"center\" bgcolor=\"#999999\">\n").append("<td><img src=\"").append(iconPath).append("1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n").append("</tr>\n").append("<tr align=\"center\" bgcolor=\"#FFFFFF\">\n").append("<td><img src=\"").append(iconPath).append("1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n").append("</tr>\n").append("<tr align=\"center\"> \n").append("<td class=\"ArrayNavigation\" height=\"20\">");
            if (first > 0) {
                result.append("<a class=\"ArrayNavigation\" href=\"");
                Object url = this.getUrl();
                url = !((String)url).contains("?") ? (String)url + "?" : (String)url + "&";
                url = (String)url + "ArrayPaneAction=Previous&ArrayPaneTarget=" + this.getName();
                result.append((String)url).append("\"><< Pr&eacute;c&eacute;dent </a>  | ");
            }
            if (first != last) {
                result.append(first + 1).append(" - ").append(last + 1);
            } else {
                result.append(first + 1);
            }
            result.append(" / ").append(this.getLines().size());
            if (last + 1 < this.getLines().size()) {
                result.append(" | <a class=\"ArrayNavigation\" href=\"");
                Object url = this.getUrl();
                url = !((String)url).contains("?") ? (String)url + "?" : (String)url + "&";
                url = (String)url + "ArrayPaneAction=Next&ArrayPaneTarget=" + this.getName();
                result.append((String)url).append("\">Suivant >></a>");
            }
            result.append("</td></tr>\n").append("<tr align=\"center\" bgcolor=\"#999999\">\n<td><img src=\"").append(iconPath).append("1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n</tr>\n").append("<tr align=\"center\" bgcolor=\"#666666\">\n<td><img src=\"").append(iconPath).append("1px.gif\" width=\"1\" height=\"1\" alt=\"\"/></td>\n</tr>\n").append("</table>");
        }
        result.append("</td></tr></table>\n");
        return result.toString();
    }
}

