/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.arraypanes;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.portlet.RenderRequest;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.web.portlets.PortletUtil;
import org.silverpeas.core.web.util.viewgenerator.html.SimpleGraphicElement;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.AbstractArrayPane;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayColumn;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayLine;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayPaneStatusBean;
import org.silverpeas.core.web.util.viewgenerator.html.pagination.Pagination;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.util.StringUtil;

public interface ArrayPane
extends SimpleGraphicElement {
    public static final String ACTION_PARAMETER_NAME = "ArrayPaneAction";
    public static final String TARGET_PARAMETER_NAME = "ArrayPaneTarget";
    public static final String COLUMN_PARAMETER_NAME = "ArrayPaneColumn";
    public static final String CACHE_COLUMNS_KEY_SUFFIX = "_columns";
    public static final String CACHE_LINES_KEY_SUFFIX = "_lines";

    public static <O> O getOrderByFrom(RenderRequest renderRequest, Map<Integer, Pair<O, O>> orderBiesByColumnIndex) {
        return ArrayPane.getOrderByFrom(renderRequest, orderBiesByColumnIndex, null);
    }

    public static <O> O getOrderByFrom(RenderRequest renderRequest, Map<Integer, Pair<O, O>> orderBiesByColumnIndex, String defaultArrayPaneName) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        renderRequest.getParameterMap().forEach((key, value) -> parameters.put((String)key, value[0]));
        HttpServletRequest request = PortletUtil.getHttpServletRequest(renderRequest);
        return ArrayPane.getOrderByFrom(request, parameters, orderBiesByColumnIndex, defaultArrayPaneName);
    }

    public static <O> O getOrderByFrom(HttpServletRequest request, Map<Integer, Pair<O, O>> orderBiesByColumnIndex) {
        return ArrayPane.getOrderByFrom(request, orderBiesByColumnIndex, null);
    }

    public static <O> O getOrderByFrom(HttpServletRequest request, Map<Integer, Pair<O, O>> orderBiesByColumnIndex, String defaultArrayPaneName) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        request.getParameterMap().forEach((key, value) -> parameters.put((String)key, value[0]));
        return ArrayPane.getOrderByFrom(request, parameters, orderBiesByColumnIndex, defaultArrayPaneName);
    }

    public static <O> O getOrderByFrom(HttpServletRequest request, Map<String, String> params, Map<Integer, Pair<O, O>> orderBiesByColumnIndex, String defaultArrayPaneName) {
        ArrayPaneStatusBean state;
        String action = params.get(ACTION_PARAMETER_NAME);
        String column = params.get(COLUMN_PARAMETER_NAME);
        String name = params.get(TARGET_PARAMETER_NAME);
        if (name == null || !"Sort".equals(action)) {
            if (StringUtil.isDefined((String)defaultArrayPaneName)) {
                name = defaultArrayPaneName;
            } else {
                return null;
            }
        }
        if ((state = (ArrayPaneStatusBean)request.getSession(false).getAttribute(name)) == null) {
            return null;
        }
        return AbstractArrayPane.getOrderByFrom(state, column, orderBiesByColumnIndex);
    }

    public static PaginationPage getPaginationPageFrom(RenderRequest renderRequest) {
        return ArrayPane.getPaginationPageFrom(renderRequest, null);
    }

    public static PaginationPage getPaginationPageFrom(RenderRequest renderRequest, String defaultArrayPaneName) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        renderRequest.getParameterMap().forEach((key, value) -> parameters.put((String)key, value[0]));
        HttpServletRequest request = PortletUtil.getHttpServletRequest(renderRequest);
        return ArrayPane.getPaginationPageFrom(request, parameters, defaultArrayPaneName);
    }

    public static PaginationPage getPaginationPageFrom(HttpServletRequest request) {
        return ArrayPane.getPaginationPageFrom(request, null);
    }

    public static PaginationPage getPaginationPageFrom(HttpServletRequest request, String defaultArrayPaneName) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        request.getParameterMap().forEach((key, value) -> parameters.put((String)key, value[0]));
        return ArrayPane.getPaginationPageFrom(request, parameters, defaultArrayPaneName);
    }

    public static PaginationPage getPaginationPageFrom(HttpServletRequest request, Map<String, String> params, String defaultArrayPaneName) {
        PaginationPage currentPagination;
        String name = StringUtil.defaultStringIfNotDefined((String)params.get(TARGET_PARAMETER_NAME), (String)StringUtil.defaultStringIfNotDefined((String)defaultArrayPaneName, (String)"unknown-arraypane-state"));
        ArrayPaneStatusBean state = (ArrayPaneStatusBean)request.getSession(false).getAttribute(name);
        if (state == null) {
            currentPagination = null;
        } else {
            int maximumVisibleLine = state.getMaximumVisibleLine();
            if (maximumVisibleLine > 0) {
                int pageNumber = state.getFirstVisibleLine() / maximumVisibleLine + 1;
                currentPagination = new PaginationPage(pageNumber, maximumVisibleLine);
            } else {
                currentPagination = null;
            }
        }
        return Pagination.getPaginationPageFrom(params, currentPagination);
    }

    public static <T> T computeDataUserSessionIfAbsent(HttpServletRequest request, String cacheKey, Supplier<T> valueSupplier) {
        SimpleCache sessionCache = CacheAccessorProvider.getSessionCacheAccessor().getCache();
        if (request.getParameter("ajaxRequest") == null) {
            sessionCache.remove((Object)cacheKey);
        }
        return (T)sessionCache.computeIfAbsent((Object)cacheKey, Object.class, valueSupplier);
    }

    public void init(String var1, PageContext var2);

    public void init(String var1, ServletRequest var2, HttpSession var3);

    public void init(String var1, String var2, ServletRequest var3, HttpSession var4);

    public ArrayColumn addArrayColumn(String var1);

    public ArrayLine addArrayLine();

    public String getTitle();

    public void setTitle(String var1);

    public String getName();

    public void setVisibleLineNumber(int var1);

    public int getColumnToSort();

    public void setColumnToSort(int var1);

    @Override
    public String print();

    public HttpSession getSession();

    public ServletRequest getRequest();

    public void setRoutingAddress(String var1);

    public boolean getSortable();

    public void setSortable(boolean var1);

    public void setLineMoveCallback(String var1);

    public String getSummary();

    public void setSummary(String var1);

    public boolean isExportData();

    public void setExportData(boolean var1);

    public String getExportDataURL();

    public void setExportDataURL(String var1);

    public void setMovableLines(boolean var1);
}

