/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import org.apache.ecs.GenericElement;
import org.silverpeas.core.html.WebPlugin;
import org.silverpeas.core.web.mvc.controller.SilverpeasWebUtil;
import org.silverpeas.core.web.mvc.webcomponent.SilverpeasAuthenticatedHttpServlet;

public class IncludePlugin
extends SilverpeasAuthenticatedHttpServlet {
    private static final long serialVersionUID = 5315718492441997694L;
    @Inject
    protected SilverpeasWebUtil util;

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        res.setContentType("text/html");
        res.setHeader("Cache-Control", "no-store");
        res.setHeader("Pragma", "no-cache");
        res.setDateHeader("Expires", -1L);
        this.getPluginName(req).map(h -> WebPlugin.get().getHtml(h, this.util.getUserLanguage(req))).map(GenericElement::toString).ifPresentOrElse(h -> this.sendHtml(res, (String)h), () -> this.throwHttpForbiddenError("plugin not found"));
    }

    protected void sendHtml(HttpServletResponse res, String html2) {
        try {
            PrintWriter writer = res.getWriter();
            writer.write(html2);
            writer.flush();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected Optional<String> getPluginName(HttpServletRequest request) {
        return Optional.ofNullable(request.getPathInfo()).map(p -> p.substring(1));
    }
}

