/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.CharEncoding;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.web.mvc.controller.ComponentSessionController;
import org.silverpeas.core.web.mvc.util.RoutingException;
import org.silverpeas.kernel.util.StringUtil;

public class WysiwygRouting {
    private static final String EDITOR_PAGE_PATH = "/wysiwyg/jsp/htmlEditor.jsp";

    public String getWysiwygEditorPath(WysiwygRoutingContext context, HttpServletRequest request) throws RoutingException {
        if (request == null) {
            return this.getDestinationToWysiwygEditor(context);
        }
        try {
            request.setAttribute("SpaceName", (Object)URLEncoder.encode(context.spaceLabel, CharEncoding.UTF_8));
            request.setAttribute("ComponentId", (Object)context.contributionId.getComponentInstanceId());
            request.setAttribute("ComponentLabel", (Object)URLEncoder.encode(context.componentLabel, CharEncoding.UTF_8));
            request.setAttribute("ObjectId", (Object)context.contributionId.getLocalId());
            request.setAttribute("ObjectType", (Object)context.contributionId.getType());
            request.setAttribute("Language", (Object)context.language);
            request.setAttribute("BrowseInfo", (Object)context.browseInfo);
            request.setAttribute("ReturnUrl", (Object)context.comeBackUrl);
            request.setAttribute("UserId", (Object)User.getCurrentRequester().getId());
            request.setAttribute("IndexIt", (Object)String.valueOf(context.indexation));
            if (StringUtil.isDefined((String)context.contentLanguage)) {
                request.setAttribute("ContentLanguage", (Object)context.contentLanguage);
            }
            if (StringUtil.isDefined((String)context.browseInfo)) {
                request.setAttribute("BrowseInfo", (Object)context.browseInfo);
            }
            if (StringUtil.isDefined((String)context.fileName)) {
                request.setAttribute("FileName", (Object)context.fileName);
            }
            return EDITOR_PAGE_PATH;
        }
        catch (UnsupportedEncodingException e) {
            throw new RoutingException(e);
        }
    }

    public String getDestinationToWysiwygEditor(WysiwygRoutingContext context) throws RoutingException {
        try {
            StringBuilder destination = new StringBuilder(EDITOR_PAGE_PATH);
            destination.append("?").append("SpaceLabel=").append(URLEncoder.encode(context.spaceLabel, "UTF-8")).append("&ComponentId=").append(context.contributionId.getComponentInstanceId()).append("&ComponentLabel=").append(URLEncoder.encode(context.componentLabel, "UTF-8")).append("&ObjectId=").append(context.contributionId.getLocalId()).append("&ObjectType=").append(context.contributionId.getType()).append("&Language=").append(context.language).append("&ReturnUrl=").append(context.comeBackUrl);
            if (StringUtil.isDefined((String)context.contentLanguage)) {
                destination.append("&ContentLanguage=").append(context.contentLanguage);
            }
            if (StringUtil.isDefined((String)context.browseInfo)) {
                destination.append("&BrowseInfo=").append(context.browseInfo);
            }
            if (StringUtil.isDefined((String)context.fileName)) {
                destination.append("&FileName=").append(context.fileName);
            }
            return destination.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RoutingException(e);
        }
    }

    public static class WysiwygRoutingContext {
        private String spaceLabel;
        private String componentLabel;
        private ContributionIdentifier contributionId;
        private String language = I18NHelper.DEFAULT_LANGUAGE;
        private boolean indexation = true;
        private String comeBackUrl;
        private String browseInfo;
        private String contentLanguage;
        private String fileName;

        public static WysiwygRoutingContext fromComponentSessionController(ComponentSessionController controller) {
            return new WysiwygRoutingContext().withSpaceLabel(controller.getSpaceLabel()).withComponentLabel(controller.getComponentLabel()).withLanguage(controller.getLanguage());
        }

        public WysiwygRoutingContext withSpaceLabel(String spaceLabel) {
            this.spaceLabel = spaceLabel;
            return this;
        }

        public WysiwygRoutingContext withContributionId(ContributionIdentifier contributionId) {
            this.contributionId = contributionId;
            return this;
        }

        public WysiwygRoutingContext withComponentLabel(String componentLabel) {
            this.componentLabel = componentLabel;
            return this;
        }

        public WysiwygRoutingContext withLanguage(String language) {
            this.language = language;
            return this;
        }

        public WysiwygRoutingContext withIndexation(boolean indexation) {
            this.indexation = indexation;
            return this;
        }

        public WysiwygRoutingContext withComeBackUrl(String url) {
            this.comeBackUrl = url;
            return this;
        }

        public WysiwygRoutingContext withBrowseInfo(String browseInfo) {
            this.browseInfo = browseInfo;
            return this;
        }

        public WysiwygRoutingContext withContentLanguage(String language) {
            this.contentLanguage = language;
            return this;
        }

        public WysiwygRoutingContext withFileName(String wysiwygFileName) {
            this.fileName = wysiwygFileName;
            return this;
        }
    }
}

