/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.notification.message.Message;
import org.silverpeas.core.notification.message.MessageContainer;
import org.silverpeas.core.notification.message.MessageListener;
import org.silverpeas.core.notification.message.MessageManager;
import org.silverpeas.core.web.mvc.controller.MainSessionController;

public class MessageFilter
implements Filter {
    public static final String HTTP_MESSAGEKEY = "X-Silverpeas-MessageKey";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String registredKey = MessageManager.initialize();
            MessageManager.addListener((MessageListener)new RequestMessageListener(httpRequest, httpResponse, registredKey));
            try {
                chain.doFilter(request, response);
            }
            finally {
                MessageContainer container = MessageManager.getMessageContainer((String)registredKey);
                if (container != null && container.getMessages().isEmpty()) {
                    MessageManager.clear((String)registredKey);
                    httpResponse.setHeader(HTTP_MESSAGEKEY, null);
                }
                MessageManager.destroy();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private class RequestMessageListener
    implements MessageListener {
        private final HttpServletRequest httpRequest;
        private final HttpServletResponse httpResponse;
        private final String registredKeyOfMessages;

        public RequestMessageListener(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String registredKeyOfMessages) {
            this.httpRequest = httpRequest;
            this.httpResponse = httpResponse;
            this.registredKeyOfMessages = registredKeyOfMessages;
        }

        public void beforeGetLanguage(MessageContainer container) {
            MainSessionController mainSessionCtrl;
            HttpSession session = this.httpRequest.getSession(false);
            if (session != null && (mainSessionCtrl = (MainSessionController)session.getAttribute("SilverSessionController")) != null) {
                container.setLanguage(mainSessionCtrl.getFavoriteLanguage());
            }
        }

        public void beforeAddMessage(MessageContainer container, Message message) {
        }

        public void afterMessageAdded(MessageContainer container, Message message) {
            this.httpResponse.setHeader(MessageFilter.HTTP_MESSAGEKEY, this.registredKeyOfMessages);
        }
    }
}

