/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication;

import java.io.IOException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.AuthenticationResponse;
import org.silverpeas.core.security.authentication.AuthenticationService;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.security.authentication.exception.AuthenticationNoMoreUserConnectionAttemptException;
import org.silverpeas.core.security.authentication.exception.AuthenticationUserMustAcceptTermsOfService;
import org.silverpeas.core.security.authentication.verifier.AuthenticationUserVerifierFactory;
import org.silverpeas.core.security.authentication.verifier.UserCanTryAgainToLoginVerifier;
import org.silverpeas.core.security.authentication.verifier.UserMustAcceptTermsOfServiceVerifier;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.authentication.AuthenticationParameters;
import org.silverpeas.core.web.authentication.CredentialEncryption;
import org.silverpeas.core.web.authentication.MandatoryQuestionChecker;
import org.silverpeas.core.web.authentication.SilverpeasSessionOpener;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.mvc.webcomponent.SilverpeasHttpServlet;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class AuthenticationServlet
extends SilverpeasHttpServlet {
    private static final long serialVersionUID = -8695946617361150513L;
    private static final String SSO_NON_EXISTING_USER_ACCOUNT = "Error_SsoOnUnexistantUserAccount";
    private static final String LOGIN_ERROR_PAGE = "/Login?ErrorCode=";
    private static final int COOKIE_TIME_LIFE = 31536000;
    @Inject
    private AuthenticationService authService;
    @Inject
    private SilverpeasSessionOpener silverpeasSessionOpener;
    @Inject
    private CredentialEncryption credentialEncryption;
    @Inject
    private MandatoryQuestionChecker mandatoryQuestionChecker;
    private final SilverLogger logger = SilverLogger.getLogger((Object)((Object)this));

    public void doPost(HttpServletRequest servletRequest, HttpServletResponse response) {
        try {
            HttpRequest request = HttpRequest.decorate((HttpServletRequest)servletRequest);
            SilverpeasHttpServlet.UserSessionStatus userSessionStatus = this.existOpenedUserSession(servletRequest);
            AuthenticationParameters authenticationParameters = new AuthenticationParameters((HttpServletRequest)request);
            if (userSessionStatus.isValid()) {
                UserDetail connectedUser = userSessionStatus.getInfo().getUserDetail();
                if (authenticationParameters.isSsoMode() && connectedUser.getLogin().equals(authenticationParameters.getLogin()) && connectedUser.getDomainId().equals(authenticationParameters.getDomainId())) {
                    SilverLogger.getLogger((String)"silverpeas.sso").debug(() -> AuthenticationServlet.lambda$doPost$0((User)connectedUser, userSessionStatus));
                    this.forward((HttpServletRequest)request, response, "/Login");
                    return;
                }
                HttpSession session = servletRequest.getSession(false);
                this.silverpeasSessionOpener.closeSession(session);
            }
            request.getSession();
            if (!StringUtil.isDefined((String)request.getCharacterEncoding())) {
                request.setCharacterEncoding(Charsets.UTF_8.name());
            }
            if (!userSessionStatus.isValid() && request.isWithinAnonymousUserSession()) {
                this.renewHttpSession(request);
            }
            AuthenticationResponse result = this.authenticate((HttpServletRequest)request, authenticationParameters);
            UserCanTryAgainToLoginVerifier userCanTryAgainToLoginVerifier = AuthenticationUserVerifierFactory.getUserCanTryAgainToLoginVerifier((AuthenticationCredential)authenticationParameters.getCredential());
            userCanTryAgainToLoginVerifier.clearSession((HttpServletRequest)request);
            if (result == null || result.getStatus().isInError()) {
                this.processError(result, request, response, authenticationParameters, userCanTryAgainToLoginVerifier);
            } else {
                this.openNewSession(result.getToken(), request, response, authenticationParameters, userCanTryAgainToLoginVerifier);
            }
        }
        catch (IOException | ServletException e) {
            SilverLogger.getLogger((Object)((Object)this)).error(e);
            response.setStatus(500);
        }
    }

    private void openNewSession(String token, HttpRequest request, HttpServletResponse response, AuthenticationParameters authenticationParameters, UserCanTryAgainToLoginVerifier userCanTryAgainToLoginVerifier) throws ServletException, IOException {
        String destination;
        userCanTryAgainToLoginVerifier.clearCache();
        if (authenticationParameters.getDomainId() != null) {
            this.storeDomain(response, authenticationParameters);
        }
        this.storeLogin(response, authenticationParameters);
        if (request.getAttribute("skipTermsOfServiceAcceptance") == null) {
            UserMustAcceptTermsOfServiceVerifier verifier = AuthenticationUserVerifierFactory.getUserMustAcceptTermsOfServiceVerifier((AuthenticationCredential)authenticationParameters.getCredential());
            try {
                verifier.verify();
            }
            catch (AuthenticationUserMustAcceptTermsOfService authenticationUserMustAcceptTermsOfService) {
                this.logger.warn(authenticationUserMustAcceptTermsOfService.getMessage(), new Object[]{authenticationUserMustAcceptTermsOfService});
                this.forward((HttpServletRequest)request, response, verifier.getDestination((HttpServletRequest)request));
                return;
            }
        }
        if (StringUtil.isDefined((String)(destination = this.mandatoryQuestionChecker.check((HttpServletRequest)request, token)))) {
            this.forward((HttpServletRequest)request, response, destination);
            return;
        }
        String absoluteUrl = this.silverpeasSessionOpener.openSession(request, token);
        HttpSession session = request.getSession(false);
        session.setAttribute("Silverpeas_pwdForHyperlink", (Object)authenticationParameters.getPassword());
        response.sendRedirect(response.encodeRedirectURL(absoluteUrl));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processError(AuthenticationResponse error, HttpRequest request, HttpServletResponse response, AuthenticationParameters authenticationParameters, UserCanTryAgainToLoginVerifier userCanTryAgainToLoginVerifier) throws ServletException, IOException {
        Object url;
        if (authenticationParameters.isCasMode()) {
            url = "/admin/jsp/casAuthenticationError.jsp";
        } else if (error != null) {
            url = this.processUrlForError(error, request, response, authenticationParameters, userCanTryAgainToLoginVerifier);
            if (url == null) return;
            String paramDelimiter = ((String)url).contains("?") ? "&" : "?";
            url = (String)url + paramDelimiter + "DomainId=" + authenticationParameters.getDomainId();
        } else {
            url = LOGIN_ERROR_PAGE + AuthenticationResponse.Status.UNKNOWN_FAILURE;
        }
        response.sendRedirect(response.encodeRedirectURL(URLUtil.getFullApplicationURL((HttpServletRequest)request) + (String)url));
    }

    private String processUrlForError(AuthenticationResponse error, HttpRequest request, HttpServletResponse response, AuthenticationParameters authenticationParameters, UserCanTryAgainToLoginVerifier userCanTryAgainToLoginVerifier) throws ServletException, IOException {
        Object url;
        AuthenticationResponse.Status status = error.getStatus();
        if (status == AuthenticationResponse.Status.BAD_LOGIN_PASSWORD || status == AuthenticationResponse.Status.BAD_LOGIN_PASSWORD_DOMAIN) {
            url = this.processBadLogin(status, request, response, authenticationParameters, userCanTryAgainToLoginVerifier);
        } else if (status == AuthenticationResponse.Status.USER_ACCOUNT_BLOCKED || status == AuthenticationResponse.Status.USER_ACCOUNT_DEACTIVATED) {
            url = this.processBadAccountState(status, response, authenticationParameters, userCanTryAgainToLoginVerifier);
        } else if (status == AuthenticationResponse.Status.PASSWORD_EXPIRED || status == AuthenticationResponse.Status.PASSWORD_TO_CHANGE) {
            HttpSession session = request.getSession();
            url = this.processPasswordExpiration(authenticationParameters, session);
        } else {
            if (status == AuthenticationResponse.Status.PASSWORD_TO_CHANGE_ON_FIRST_LOGIN) {
                this.storeLogin(response, authenticationParameters);
                this.storeDomain(response, authenticationParameters);
                String url2 = AuthenticationUserVerifierFactory.getUserMustChangePasswordVerifier((AuthenticationCredential)authenticationParameters.getCredential()).getDestinationOnFirstLogin((HttpServletRequest)request);
                this.forward((HttpServletRequest)request, response, url2);
                return null;
            }
            if (authenticationParameters.isSsoMode()) {
                this.storeDomain(response, authenticationParameters);
                this.storeLogin(response, authenticationParameters);
                url = "/Login?ErrorCode=Error_SsoOnUnexistantUserAccount";
            } else {
                url = LOGIN_ERROR_PAGE + status.getCode();
            }
        }
        return url;
    }

    private String processPasswordExpiration(AuthenticationParameters authenticationParameters, HttpSession session) {
        String url;
        String allowPasswordChange = (String)session.getAttribute("Svp_Password_Change_Allowed");
        if (StringUtil.getBooleanValue((String)allowPasswordChange)) {
            SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.authentication.settings.passwordExpiration");
            url = settings.getString("passwordExpiredURL") + "?login=" + authenticationParameters.getLogin() + "&domainId=" + authenticationParameters.getDomainId();
        } else {
            url = LOGIN_ERROR_PAGE + AuthenticationResponse.Status.PASSWORD_EXPIRED;
        }
        return url;
    }

    private String processBadAccountState(AuthenticationResponse.Status error, HttpServletResponse response, AuthenticationParameters authenticationParameters, UserCanTryAgainToLoginVerifier userCanTryAgainToLoginVerifier) {
        Object url = null;
        if (userCanTryAgainToLoginVerifier.isActivated() || StringUtil.isDefined((String)userCanTryAgainToLoginVerifier.getUser().getId())) {
            this.storeLogin(response, authenticationParameters);
            this.storeDomain(response, authenticationParameters);
            url = AuthenticationUserVerifierFactory.getUserCanLoginVerifier((User)userCanTryAgainToLoginVerifier.getUser()).getErrorDestination();
        } else if (error == AuthenticationResponse.Status.BAD_LOGIN_PASSWORD || error == AuthenticationResponse.Status.BAD_LOGIN_PASSWORD_DOMAIN) {
            url = LOGIN_ERROR_PAGE + error;
        }
        return url;
    }

    private String processBadLogin(AuthenticationResponse.Status error, HttpRequest request, HttpServletResponse response, AuthenticationParameters authenticationParameters, UserCanTryAgainToLoginVerifier userCanTryAgainToLoginVerifier) {
        String url = null;
        try {
            if (userCanTryAgainToLoginVerifier.isActivated()) {
                this.storeLogin(response, authenticationParameters);
                this.storeDomain(response, authenticationParameters);
            }
            if (error == AuthenticationResponse.Status.BAD_LOGIN_PASSWORD || error == AuthenticationResponse.Status.BAD_LOGIN_PASSWORD_DOMAIN) {
                url = userCanTryAgainToLoginVerifier.verify().performRequestUrl((HttpServletRequest)request, LOGIN_ERROR_PAGE + error);
            }
        }
        catch (AuthenticationNoMoreUserConnectionAttemptException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            url = userCanTryAgainToLoginVerifier.getErrorDestination();
        }
        return url;
    }

    private void forward(HttpServletRequest request, HttpServletResponse response, String destination) throws ServletException, IOException {
        RequestDispatcher dispatcher = request.getRequestDispatcher(destination);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void storeLogin(HttpServletResponse response, AuthenticationParameters params) {
        if (this.isNotAnonymousAuthentication(params)) {
            String sLogin = params.getLogin();
            boolean secured = params.isSecuredAccess();
            if (params.isNewEncryptionMode()) {
                this.writeCookie(response, "var1", this.credentialEncryption.encode(sLogin), -1, secured);
                this.writeCookie(response, "var1", this.credentialEncryption.encode(sLogin), 31536000, secured);
            } else {
                this.writeCookie(response, "svpLogin", sLogin, -1, secured);
                this.writeCookie(response, "svpLogin", sLogin, 31536000, secured);
            }
        }
    }

    private void storeDomain(HttpServletResponse response, AuthenticationParameters params) {
        if (this.isNotAnonymousAuthentication(params)) {
            String sDomainId = params.getDomainId();
            boolean secured = params.isSecuredAccess();
            this.writeCookie(response, "defaultDomain", sDomainId, -1, secured);
            this.writeCookie(response, "defaultDomain", sDomainId, 31536000, secured);
        }
    }

    private boolean isNotAnonymousAuthentication(AuthenticationParameters params) {
        UserDetail anonymous = UserDetail.getAnonymousUser();
        return anonymous == null || !anonymous.getLogin().equals(params.getLogin());
    }

    private AuthenticationResponse authenticate(HttpServletRequest request, AuthenticationParameters authenticationParameters) {
        String key = request.getParameter("TestKey");
        if (StringUtil.isNotDefined((String)key)) {
            AuthenticationCredential credential = this.getAuthenticationCredential(authenticationParameters);
            if (credential == null) {
                return AuthenticationResponse.error((AuthenticationResponse.Status)AuthenticationResponse.Status.BAD_LOGIN_PASSWORD);
            }
            if (authenticationParameters.isUserByInternalAuthTokenMode() || authenticationParameters.isSsoMode() || authenticationParameters.isCasMode()) {
                credential.withAsDomainId(authenticationParameters.getDomainId()).setRemotelyAuthenticated();
            } else if (authenticationParameters.isSocialNetworkMode()) {
                credential.withAsDomainId(authenticationParameters.getDomainId()).setRemotelyAuthenticated();
            } else {
                credential.withAsPassword(authenticationParameters.getPassword()).withAsDomainId(authenticationParameters.getDomainId());
            }
            AuthenticationResponse result = this.authService.authenticate(credential);
            authenticationParameters.setCredential(credential);
            HttpSession session = request.getSession(false);
            for (Map.Entry capability : credential.getCapabilities().entrySet()) {
                session.setAttribute((String)capability.getKey(), capability.getValue());
            }
            return result;
        }
        return null;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    private void writeCookie(HttpServletResponse response, String name, String value, int duration, boolean secure) {
        String cookieValue = URLEncoder.encode(value, Charsets.UTF_8);
        Cookie cookie = new Cookie(name, cookieValue);
        cookie.setHttpOnly(true);
        cookie.setSecure(secure);
        cookie.setMaxAge(duration);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    private void renewHttpSession(HttpRequest request) {
        HttpSession session = request.getSession(false);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        session.getAttributeNames().asIterator().forEachRemaining(a2 -> {
            if (a2.startsWith("Redirect") || a2.equals("gotoNew")) {
                attrs.put((String)a2, session.getAttribute(a2));
            }
        });
        session.invalidate();
        HttpSession newSession = request.getSession(true);
        attrs.forEach((arg_0, arg_1) -> ((HttpSession)newSession).setAttribute(arg_0, arg_1));
    }

    private AuthenticationCredential getAuthenticationCredential(AuthenticationParameters parameters) {
        try {
            return AuthenticationCredential.newWithAsLogin((String)parameters.getLogin());
        }
        catch (AuthenticationException e) {
            return null;
        }
    }

    private static /* synthetic */ String lambda$doPost$0(User connectedUser, SilverpeasHttpServlet.UserSessionStatus userSessionStatus) {
        return MessageFormat.format("SSO Authentication of PRINCIPAL {0} on domain {1}, keeping existing user session alive {2}", connectedUser.getLogin(), connectedUser.getDomainId(), userSessionStatus.getInfo().getSessionId());
    }
}

