(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    define(["converse"], factory);
  } else {
    factory(converse);
  }
}(this, function(converse) {
  const MUC_INVITATION_MODAL_DIALOG = 'muc-invite-modal';
  let _converse, html, utils, spUtils,  __, Model, BootstrapModal;

  converse.plugins.add("silverpeas-muc-invitations", {
    dependencies : ["silverpeas-commons"],

    initialize : function() {
      _converse = this._converse;

      utils = converse.env.utils;
      spUtils = converse.env.spUtils;
      html = converse.env.html;
      Model = converse.env.Model;
      BootstrapModal = converse.env.BootstrapModal;
      __ = function(key) {
        switch (key) {
          // Handling here the msg override
          case 'Invite people to this groupchat':
            return sp.i18n.get('chat.client.web.muc.invite.title');
          case 'Selected people':
            return sp.i18n.get('chat.client.web.muc.invite.selected');
          case 'Person or XMPP Address':
            return sp.i18n.get('chat.client.web.muc.invite.personOrXmppAddress');
          default:
            return _converse.__(key);
        }
      };

      const i18n_invite_heading = __('Invite people to this groupchat');
      const newMucInvitationView = function(model) {
        const delete_icon = webContext + "/util/icons/delete.gif";
        const i18n_delete = __('Delete');
        const i18n_close = __('Close');
        const i18n_add = __('Add');
        const i18n_invite = __('Invite');
        const i18n_jid_placeholder = _converse.api.settings.get('jid');
        const i18n_error_message = __('Please enter a valid XMPP address');
        const i18n_invite_label = __('Person or XMPP Address');
        const i18n_reason = __('Optional reason for the invitation');
        const i18n_selected_jids = __('Selected people');
        const modal_close_button = html`
          <button type="button" class="btn btn-secondary" data-dismiss="modal">${i18n_close}</button>`;
        const modal_header_close_button = html`
          <button type="button" class="close" data-dismiss="modal" aria-label="${i18n_close}" title="${i18n_close}">
            <span aria-hidden="true">×</span>
          </button>`;
        const selected_jids = model.invitee_jids.length ? html`
          <div class="form-group">
            <label>${i18n_selected_jids}</label>
            <ul class="selected-jids">
              ${model.invitee_jids.map(function(item) {
                return html`
                  <li>
                    <span>
                      <converse-avatar
                          class="avatar align-self-center"
                          .data=${item.vcard?.attributes}
                          nonce=${item.vcard?.get('vcard_updated')}
                          height="40" width="40"></converse-avatar>
                    </span>
                    <span class="contact-name contact-name-- ">${item.label}</span>
                    <a @click="${item.remove}" class="delete-button" title="${i18n_delete}">
                      <img src="${delete_icon}" alt="">
                    </a>
                  </li>`;
              })}
            </ul>
          </div>` : '';
        return html`
          <div class="modal-dialog" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="add-chatroom-modal-label">${i18n_invite_heading}</h5>
                ${modal_header_close_button}
              </div>
              <div class="modal-body">
                <span class="modal-alert"></span>
                <div class="suggestion-box room-invite">
                  <form @submit=${model.selectContact} autocomplete="off">
                    <div class="suggestion-box form-group">
                      <label class="clearfix" for="invitee_jid">${i18n_invite_label}</label>
                      ${model.invalid_invite_jid ? html` <div class="error error-feedback">${i18n_error_message}</div>` : ''}
                      <div class="single-line">
                        <input class="form-control suggestion-box__input silverpeas-selectize"
                               required="required"
                               name="invitee_jid"
                               id="invitee_jid"
                               placeholder="${i18n_jid_placeholder}"
                               type="text"
                               @keydown=${model.onKeyDown}
                               @keyup=${model.onKeyUp}
                               autocomplete="off"/>
                        <button class="btn btn-primary dropdown-btn" type="button"
                                @keydown=${model.onKeyDown}
                                @keyup=${model.onKeyUp}
                                @click="${model.inputDropDown}">
                          <span class="caret"></span>
                        </button>
                        <button type="submit" class="btn btn-primary plus" aria-label="${i18n_add}" title="${i18n_add}">
                          <span aria-hidden="true">+</span>
                        </button>
                      </div>
                    </div>
                    <div class="form-group">
                      <label>${i18n_reason}</label>
                      <textarea class="form-control" name="reason"></textarea>
                    </div>
                    ${selected_jids}
                  </form>
                  <div class="form-group">
                    <button @click="${model.performInvitations}" class="btn btn-primary">${i18n_invite}</button>
                    ${modal_close_button}
                  </div>
                  <ul class="suggestion-box__results suggestion-box__results--below" hidden=""></ul>
                  <span class="suggestion-box__additions visually-hidden" role="status" aria-live="assertive" aria-relevant="additions"></span>
                </div>
              </div>
            </div>
          </div>
        `;
      }

      const autoCompleteManager = new function() {
        /**
         * Events:
         * - 'select'
         * - 'evaluate'
         */
        applyEventDispatchingBehaviorOn(this);
        let acInst;
        let contactList;
        const __closeAc = function(ev) {
          if (Array.isArray(ev.path) && ev.path.length && ev.path[0].tagName) {
            const tagName = ev.path[0].tagName.toLowerCase();
            if (tagName === 'button' || tagName === 'li' || tagName === 'input') {
              return;
            }
          }
          acInst.close({'reason' : 'esc'});
        }
        this.init = function($el) {
          $el.removeEventListener('click', __closeAc);
          $el.addEventListener('click', __closeAc);
          if (acInst) {
            acInst.destroy();
          }
          contactList = _converse.roster.map(function(i) {
            return {
              'label' : ' ' + i.getDisplayName(),
              'value' : i.get('jid')
            };
          });
          acInst = new _converse.AutoComplete($el, {
            'max_items' : 1000,
            'min_chars' : 1,
            'list' : contactList,
            'item' : spUtils.muc.getAutoCompleteListItem
          });
          /**
           * Listener to handle the selection.
           */
          acInst.on('suggestion-box-selectcomplete', function() {
            const selectedJid = acInst.input.value;
            acInst.__spLastSelected = selectedJid ? selectedJid.trim() : undefined;
            this.dispatchEvent('select', acInst.__spLastSelected);
          }.bind(this));
          /**
           * Adding the aria-value data which contains item value (so the jid) which permits
           * retrieving easily the right item against a jid.
           */
          acInst.on('suggestion-box-open', function() {
            Array.prototype.slice.call(acInst.ul.children).forEach(function($li) {
              if (!$li.getAttribute('aria-value')) {
                contactList.forEach(function(item) {
                  if (item.label.trim() === $li.getAttribute('aria-label')) {
                    $li.setAttribute('aria-value', item.value);
                  }
                });
              }
            });
          });
          /**
           * On open, select the first item automatically.
           * (this method is used instead the initialization parameter 'auto_first' because of bad
           * behaviors with some overrides)
           */
          acInst.on('suggestion-box-open', function() {
            const foundIndex = Array.prototype.slice.call(acInst.ul.children).map(function($li, index) {
              const liJid = $li.getAttribute('aria-value');
              if(liJid === acInst.__spLastSelected) {
                return index;
              }
              return undefined;
            }).filter(function(index) {
              return typeof index !== 'undefined';
            });
            acInst.goto(foundIndex.length > 0 ? foundIndex[0] : 0);
          });
          /**
           * Overriding the goto function in order to handle rightly the scroll into Silverpeas's
           * context.
           * @type {any}
           */
          acInst.goto = function(i) {
            const list = acInst.ul.children;
            if (acInst.selected) {
              list[acInst.index].setAttribute("aria-selected", "false");
            }
            acInst.index = i;
            if (i > -1 && list.length > 0) {
              const $li = list[i];
              $li.setAttribute("aria-selected", "true");
              $li.focus();
              acInst.status.textContent = $li.textContent;
              sp.element.scrollToIfNotFullyInView($li, acInst.ul);
              acInst.trigger("suggestion-box-highlight", {'text': acInst.suggestions[acInst.index]});
            }
          };
          /**
           * Overriding the close function in order to keep opened the dialog after a select.
           * @type {AutoComplete.close}
           */
          const __acInst_close = acInst.close;
          acInst.close = function(ev) {
            if (ev && (ev.reason === 'select' || ev.reason === 'submit')) {
              return;
            }
            return __acInst_close.call(acInst, ev);
          };
          /**
           * Overriding the onMouseDown function in order to stop event propagation.
           * @type {AutoComplete.close}
           */
          const __acInst_onMouseDown = acInst.onMouseDown;
          acInst.onMouseDown = function(ev) {
            if (acInst.opened) {
              __preventEscapeKey(ev);
              __acInst_onMouseDown.call(acInst, ev);
              acInst.evaluate(ev);
            }
          };
          /**
           * Overriding the evaluate function in order to dispatch an associated event.
           * @type {AutoComplete.close}
           */
          const __acInst_evaluate = acInst.evaluate;
          acInst.evaluate = function(ev) {
            this.resetInput(true);
            return __acInst_evaluate.call(acInst, ev).then(function() {
              this.dispatchEvent('evaluate');
            }.bind(this));
          }.bind(this);
        };
        const __preventEscapeKey = function(ev) {
          if (converse.keycodes.ESCAPE === ev.keyCode || ev.type.indexOf('click') >= 0 ||
              ev.type.indexOf('mouse') >= 0) {
            ev.preventDefault();
            ev.stopPropagation();
          }
        };
        /**
         * Handles keydown event on input or dropdown button.
         * @type {any}
         */
        this.onKeyDown = function(ev) {
          if (acInst.opened) {
            __preventEscapeKey(ev);
            acInst.onKeyDown(ev);
          } else {
            this.inputDropDown(ev);
          }
        }.bind(this);
        /**
         * Handles keyup event on input or dropdown button.
         * @param ev
         */
        this.onKeyUp = function(ev) {
          if (acInst.opened) {
            __preventEscapeKey(ev);
            acInst.evaluate(ev);
          }
        };
        /**
         * Handles the dropdown opening or closing according to context.
         * @type {any}
         */
        this.inputDropDown = function(ev) {
          __preventEscapeKey(ev);
          if (acInst.ul.childNodes.length === 0) {
            acInst.evaluate();
          } else if (acInst.ul.hasAttribute('hidden')) {
            this.resetInput();
            acInst.open();
          } else {
            acInst.close();
          }
        }.bind(this);
        /**
         * Updates the UI and the DOM data against given selected Jids
         */
        this.updateSelectedJids = function(selectedJids) {
          if (acInst) {
            Array.prototype.slice.call(acInst.ul.children).forEach(function($li) {
              const liJid = $li.getAttribute('aria-value');
              $li.setAttribute('aria-basket', selectedJids.filter(function(selectedJid) {
                return liJid === selectedJid;
              }).length > 0);
            });
          }
        };
        /**
         * Resets the input with a value that permits to keep the dropdown opened.
         * @param ifEmpty false to reset in any case, true to reset only if the input is empty.
         */
        this.resetInput = function(ifEmpty) {
          if (typeof ifEmpty === 'undefined' || (ifEmpty && !acInst.input.value.length)) {
            acInst.input.value = ' ';
          }
        }
      }

      /**
       * Modal dialog management.
       */
      class MucInvitationDialog extends BootstrapModal {
        initialize() {
          this.id = MUC_INVITATION_MODAL_DIALOG;
          this.invitee_jids = [];
          BootstrapModal.prototype.initialize.apply(this, arguments);
          this.listenTo(this.model, 'change', this.render);
          this.initInviteWidget();
        }

        toHTML() {
          const rosterContacts = _converse.roster
              .map(function(i) {
                const jid = i.get('jid');
                return {
                  'vcard' : i.vcard,
                  'label' : i.getDisplayName(),
                  'value' : jid,
                  'remove' : function() {
                    this.removeContact(jid);
                  }.bind(this)
                };
              }.bind(this));
          const selectedList = (this.invitee_jids || [])
              .map(function(jid) {
                const foundInRoster = rosterContacts.map(function(item) {
                  return item.value === jid ? item : undefined;
                }).filter(function(item) {
                  return typeof item !== 'undefined';
                });
                return foundInRoster.length > 0 ? foundInRoster[0] : {
                  'vcard' : undefined,
                  'label' : jid,
                  'value' : jid,
                  'remove' : function() {
                    this.removeContact(jid);
                  }.bind(this)
                };
              }.bind(this));
          return newMucInvitationView(Object.assign(this.model.toJSON(), {
            'invitee_jids' : selectedList,
            'onKeyDown' : autoCompleteManager.onKeyDown,
            'onKeyUp' : autoCompleteManager.onKeyUp,
            'inputDropDown' : autoCompleteManager.inputDropDown,
            'selectContact' : this.selectContact.bind(this),
            'performInvitations' : this.performInvitations.bind(this)
          }));
        }

        afterRender() {
          autoCompleteManager.updateSelectedJids(this.invitee_jids);
        }

        onHide () {
          super.onHide();
          _converse.api.modal.remove(MUC_INVITATION_MODAL_DIALOG);
        }

        initInviteWidget() {
          this.invitee_jids = [];
          const $el = this.el;
          autoCompleteManager.init($el);
          autoCompleteManager.addEventListener('select', function(e) {
            const selectedJid = e.detail.data;
            if (this.isSelectedContact(selectedJid)) {
              this.removeContact(selectedJid);
            } else {
              $el.querySelector('button.plus').click();
            }
          }.bind(this), 'select');
          autoCompleteManager.addEventListener('evaluate', function() {
            this.model.set({'invalid_invite_jid': false});
            this.afterRender();
          }.bind(this), 'evaluate');
        }

        isSelectedContact(jid) {
          return this.invitee_jids.indexOf(jid) >= 0;
        }

        removeContact(jid) {
          if(this.invitee_jids.removeElement(jid)) {
            this.model.set({'invalid_invite_jid': false});
            autoCompleteManager.resetInput();
            this.model.trigger('change');
          }
        }

        addContactFromFormData(data) {
          const jid = data.get('invitee_jid').trim();
          if (utils.isValidJID(jid)) {
            this.model.set({'invalid_invite_jid': false});
            if (this.invitee_jids.indexOf(jid) < 0) {
              this.invitee_jids.push(jid);
              autoCompleteManager.resetInput();
            }
            return true;
          }
          return false;
        }

        selectContact(ev) {
          ev.preventDefault();
          const data = new FormData(ev.target);
          if (this.addContactFromFormData(data)) {
            this.model.trigger('change');
          } else {
            this.model.set({'invalid_invite_jid': true});
          }
        }

        performInvitations(ev) {
          ev.preventDefault();
          const $el = this.el;
          const data = new FormData($el.querySelector('form'));
          this.addContactFromFormData(data);
          const reason = data.get('reason');
          this.invitee_jids.forEach(function(jid) {
            this.chatroomview.model.directInvite(jid, reason);
            this.modal.hide();
          }.bind(this));
        }
      };
      _converse.api.elements.define(MUC_INVITATION_MODAL_DIALOG, MucInvitationDialog);

      _converse.api.listen.on('getHeadingButtons', function(heading_el, buttons) {
        sp.log.debug("getHeadingButtons", heading_el.model.get("jid"));
        if (heading_el.model.get("type") === "chatroom") {
          buttons.filter(function(button) {
            return button.name === 'invite';
          }).forEach(function(button) {
            button.i18n_title = i18n_invite_heading;
            button.handler = performMucInvitation;
          });
        }
        return buttons;
      });

      function performMucInvitation(ev) {
        ev.preventDefault();
        const chatView = spUtils.getChatViewFromElement(ev.currentTarget);
        const mucInvitationModel = new Model();
        _converse.api.modal.show(MUC_INVITATION_MODAL_DIALOG, {
          'model': mucInvitationModel,
          'chatroomview': chatView
        }, ev);
      }

      sp.log.debug("MUC invitation plugin is ready");
    }
  });
}));
