/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.server.utility;

import edu.psu.swe.scim.spec.annotation.ScimResourceType;
import edu.psu.swe.scim.spec.exception.InvalidScimResourceException;
import edu.psu.swe.scim.spec.resources.ScimResource;
import java.net.URI;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

@RequestScoped
public class EndpointUtil {
    private URI baseUri;

    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((URI)this.baseUri);
    }

    public UriBuilder getEndpointUriBuilder(Class<? extends ScimResource> resource) {
        ScimResourceType[] sr = (ScimResourceType[])resource.getAnnotationsByType(ScimResourceType.class);
        if (this.baseUri == null) {
            throw new IllegalStateException("BaseUri for Resource " + resource + " was null");
        }
        if (sr.length == 0 || sr.length > 1) {
            throw new InvalidScimResourceException("ScimResource class must have a ScimResourceType annotation");
        }
        String resourceName = sr[0].name() + "s";
        return UriBuilder.fromUri((URI)this.baseUri).path(resourceName);
    }

    public void process(UriInfo uriInfo) {
        this.baseUri = uriInfo.getBaseUri();
    }
}

