/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.personalization;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.persistence.datasource.model.identifier.ExternalStringIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.personalization.UserMenuDisplay;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@Table(name="personalization")
@NamedQuery(name="UserPreferences.findByDefaultSpace", query="select p from UserPreferences p WHERE p.collaborativeWorkSpaceId = :space")
public class UserPreferences
extends BasicJpaEntity<UserPreferences, ExternalStringIdentifier>
implements Serializable {
    private static final long serialVersionUID = 9192830552642027995L;
    @Column(name="languages")
    private String language = null;
    @Column(name="zoneId")
    private String zoneId = null;
    @Column(name="look")
    private String look = null;
    @Column(name="personalwspace")
    private String collaborativeWorkSpaceId;
    @Column(name="thesaurusstatus")
    private int thesaurusStatus = 0;
    @Column(name="draganddropstatus")
    private int dragAndDropStatus = 0;
    @Column(name="webdaveditingstatus")
    private int webdavEditionStatus = 0;
    @Column(name="menuDisplay")
    private String menuDisplay = UserMenuDisplay.DEFAULT.name();

    public UserPreferences() {
    }

    public UserPreferences(String userId, String language, ZoneId zoneId) {
        this.setId(userId);
        this.language = language;
        this.zoneId = zoneId.toString();
    }

    public User getUser() {
        return User.getById(this.getId());
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public ZoneId getZoneId() {
        return ZoneId.of(this.zoneId);
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId.toString();
    }

    public String getLook() {
        return this.look;
    }

    public void setLook(String look) {
        this.look = !StringUtil.isDefined((String)look) ? "Initial" : look;
    }

    public String getPersonalWorkSpaceId() {
        return this.collaborativeWorkSpaceId;
    }

    public void setPersonalWorkSpaceId(String collaborativeWorkSpaceId) {
        this.collaborativeWorkSpaceId = collaborativeWorkSpaceId;
    }

    public boolean isThesaurusEnabled() {
        return 1 == this.thesaurusStatus;
    }

    public void enableThesaurus(boolean thesaurusEnabled) {
        this.thesaurusStatus = thesaurusEnabled ? 1 : 0;
    }

    public boolean isDragAndDropEnabled() {
        return 1 == this.dragAndDropStatus;
    }

    public void enableDragAndDrop(boolean dragAndDropEnabled) {
        this.dragAndDropStatus = dragAndDropEnabled ? 1 : 0;
    }

    public boolean isWebdavEditionEnabled() {
        return 1 == this.webdavEditionStatus;
    }

    public void enableWebdavEdition(boolean webdavEditionEnabled) {
        this.webdavEditionStatus = webdavEditionEnabled ? 1 : 0;
    }

    public UserMenuDisplay getDisplay() {
        if (!StringUtil.isDefined((String)this.menuDisplay)) {
            this.menuDisplay = UserMenuDisplay.DISABLE.name();
        }
        return UserMenuDisplay.valueOf(this.menuDisplay);
    }

    public void setDisplay(UserMenuDisplay display) {
        this.menuDisplay = display.name();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserPreferences other = (UserPreferences)obj;
        if (this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId())) {
            return false;
        }
        if (!Objects.equals(this.language, other.language)) {
            return false;
        }
        if (!Objects.equals(this.zoneId, other.zoneId)) {
            return false;
        }
        if (!Objects.equals(this.look, other.look)) {
            return false;
        }
        if (!Objects.equals(this.collaborativeWorkSpaceId, other.collaborativeWorkSpaceId)) {
            return false;
        }
        if (this.thesaurusStatus != other.thesaurusStatus) {
            return false;
        }
        if (this.dragAndDropStatus != other.dragAndDropStatus) {
            return false;
        }
        if (this.webdavEditionStatus != other.webdavEditionStatus) {
            return false;
        }
        return this.getDisplay() == other.getDisplay();
    }

    @Override
    public int hashCode() {
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        result = 31 * result + (this.zoneId != null ? this.zoneId.hashCode() : 0);
        result = 31 * result + (this.look != null ? this.look.hashCode() : 0);
        result = 31 * result + (this.collaborativeWorkSpaceId != null ? this.collaborativeWorkSpaceId.hashCode() : 0);
        result = 31 * result + this.thesaurusStatus;
        result = 31 * result + this.dragAndDropStatus;
        result = 31 * result + this.webdavEditionStatus;
        result = 31 * result + (this.menuDisplay != null ? this.menuDisplay.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "UserSettings{id=" + this.getId() + ", language=" + this.language + ", look=" + this.look + ", collaborativeWorkSpaceId=" + this.collaborativeWorkSpaceId + ", thesaurusStatus=" + this.isThesaurusEnabled() + ", dragDropStatus=" + this.isDragAndDropEnabled() + ", webdavEditingStatus=" + this.isWebdavEditionEnabled() + ", display=" + this.getDisplay() + "}";
    }
}

