/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.bundlor;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.document.bundlor.CompositeMatcher;
import org.apache.jackrabbit.oak.plugins.document.bundlor.Include;
import org.apache.jackrabbit.oak.plugins.document.bundlor.Matcher;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class DocumentBundlor {
    public static final String BUNDLOR_META_PROP_PREFIX = ":doc-";
    public static final String META_PROP_PATTERN = ":doc-pattern";
    public static final String META_PROP_BUNDLING_PATH = ":doc-self-path";
    public static final String HAS_CHILD_PROP_PREFIX = ":doc-has-child-";
    public static final String META_PROP_BUNDLED_CHILD = ":doc-has-child-bundled";
    public static final String META_PROP_NON_BUNDLED_CHILD = ":doc-has-child-non-bundled";
    public static final String PROP_DISABLED = "disabled";
    public static final String PROP_PATTERN = "pattern";
    private final List<Include> includes;

    public static DocumentBundlor from(NodeState nodeState) {
        Validate.checkArgument((boolean)nodeState.hasProperty(PROP_PATTERN), (String)"NodeState [%s] does not have required property [%s]", (Object[])new Object[]{nodeState, PROP_PATTERN});
        return DocumentBundlor.from(nodeState.getStrings(PROP_PATTERN));
    }

    public static DocumentBundlor from(Iterable<String> includeStrings) {
        ArrayList<Include> includes = new ArrayList<Include>();
        for (String i : includeStrings) {
            includes.add(new Include(i));
        }
        return new DocumentBundlor(includes);
    }

    public static DocumentBundlor from(PropertyState prop) {
        Validate.checkArgument((boolean)META_PROP_PATTERN.equals(prop.getName()));
        return DocumentBundlor.from((Iterable)prop.getValue(Type.STRINGS));
    }

    private DocumentBundlor(List<Include> includes) {
        Validate.checkArgument((!includes.isEmpty() ? 1 : 0) != 0, (String)"Include list cannot be empty");
        this.includes = List.copyOf(includes);
    }

    public boolean isBundled(String relativePath) {
        Matcher m = this.createMatcher();
        for (String e : PathUtils.elements((String)relativePath)) {
            m = m.next(e);
        }
        return m.isMatch();
    }

    public PropertyState asPropertyState() {
        ArrayList<String> includePatterns = new ArrayList<String>(this.includes.size());
        for (Include i : this.includes) {
            includePatterns.add(i.getPattern());
        }
        return PropertyStates.createProperty((String)META_PROP_PATTERN, includePatterns, (Type)Type.STRINGS);
    }

    public Matcher createMatcher() {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>(this.includes.size());
        for (Include include : this.includes) {
            matchers.add(include.createMatcher());
        }
        return CompositeMatcher.compose(matchers);
    }

    public String toString() {
        return this.includes.toString();
    }
}

