/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.control;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.util.AttachmentSettings;
import org.silverpeas.core.contribution.content.form.XMLField;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygContentTransformer;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.importexport.attachment.AttachmentDetail;
import org.silverpeas.core.importexport.attachment.AttachmentImportExport;
import org.silverpeas.core.importexport.control.DirectoryUtils;
import org.silverpeas.core.importexport.control.GEDImportExport;
import org.silverpeas.core.importexport.control.ImportExportFactory;
import org.silverpeas.core.importexport.control.ImportExportHelper;
import org.silverpeas.core.importexport.control.ImportSettings;
import org.silverpeas.core.importexport.control.PublicationImportExport;
import org.silverpeas.core.importexport.coordinates.CoordinateImportExport;
import org.silverpeas.core.importexport.coordinates.CoordinatePointType;
import org.silverpeas.core.importexport.coordinates.CoordinatesPositionsType;
import org.silverpeas.core.importexport.form.XMLModelContentType;
import org.silverpeas.core.importexport.model.ImportExportException;
import org.silverpeas.core.importexport.model.PublicationType;
import org.silverpeas.core.importexport.publication.PublicationContentType;
import org.silverpeas.core.importexport.report.ExportPDFReport;
import org.silverpeas.core.importexport.report.ExportReport;
import org.silverpeas.core.importexport.report.HtmlExportPublicationGenerator;
import org.silverpeas.core.importexport.report.ImportReportManager;
import org.silverpeas.core.importexport.report.UnitReport;
import org.silverpeas.core.importexport.versioning.Document;
import org.silverpeas.core.importexport.versioning.DocumentVersion;
import org.silverpeas.core.importexport.versioning.VersioningImport;
import org.silverpeas.core.importexport.wysiwyg.WysiwygContentType;
import org.silverpeas.core.io.media.MetaData;
import org.silverpeas.core.io.media.MetadataExtractor;
import org.silverpeas.core.node.coordinates.model.Coordinate;
import org.silverpeas.core.node.importexport.NodeImportExport;
import org.silverpeas.core.node.importexport.NodePositionType;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.pdc.pdc.importexport.PdcImportExport;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.WAAttributeValuePair;
import org.silverpeas.core.util.error.SilverpeasTransverseErrorUtil;
import org.silverpeas.core.util.file.FileFolderManager;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class PublicationsTypeManager {
    @Inject
    private CoordinateImportExport coordinateImportExport;
    @Inject
    private NodeImportExport nodeImportExport;
    @Inject
    private PdcImportExport pdcImportExport;

    protected PublicationsTypeManager() {
    }

    public List<PublicationType> processExport(ExportReport exportReport, UserDetail userDetail, List<WAAttributeValuePair> listItemsToExport, String exportPath, boolean useNameForFolders, boolean bExportPublicationPath, NodePK rootPK) throws ImportExportException {
        AttachmentImportExport attachmentIE = new AttachmentImportExport(userDetail);
        ArrayList<PublicationType> listPubType = new ArrayList<PublicationType>();
        String wysiwygText = null;
        for (WAAttributeValuePair attValue : listItemsToExport) {
            String exportPublicationPath;
            String exportPublicationRelativePath;
            String pubId = attValue.getName();
            String componentId = attValue.getValue();
            ComponentInstLight componentInst = OrganizationControllerProvider.getOrganisationController().getComponentInstLight(componentId);
            GEDImportExport gedIE = ImportExportFactory.createGEDImportExport(userDetail, componentId);
            PublicationType publicationType = gedIE.getPublicationCompleteById(pubId, componentId);
            PublicationDetail publicationDetail = publicationType.getPublicationDetail();
            listPubType.add(publicationType);
            if (gedIE.isKmax()) {
                publicationType.setCoordinatesPositionsType(new CoordinatesPositionsType());
                try {
                    exportPublicationRelativePath = this.createPathDirectoryForKmaxPublicationExport(exportPath, componentId, componentInst.getLabel(), publicationDetail, useNameForFolders);
                }
                catch (IOException e) {
                    throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", e);
                }
                exportPublicationPath = exportPath + File.separator + exportPublicationRelativePath;
            } else {
                this.fillPublicationType(gedIE, publicationType, rootPK);
                NodePositionType nodePositionType = publicationType.getNodePositionsType().get(0);
                String nodeInstanceId = componentId;
                if (rootPK != null && !(nodeInstanceId = rootPK.getInstanceId()).equals(componentId)) {
                    componentInst = OrganizationControllerProvider.getOrganisationController().getComponentInstLight(nodeInstanceId);
                }
                exportPublicationRelativePath = this.createPathDirectoryForPublicationExport(exportPath, nodePositionType.getId(), nodeInstanceId, componentInst.getLabel(), publicationDetail, useNameForFolders, bExportPublicationPath);
                exportPublicationPath = exportPath + File.separator + exportPublicationRelativePath;
            }
            PublicationContentType pubContent = publicationType.getPublicationContentType();
            if (pubContent != null) {
                WysiwygContentType wysiwygContent = pubContent.getWysiwygContentType();
                XMLModelContentType xmlModel = pubContent.getXMLModelContentType();
                if (wysiwygContent != null) {
                    wysiwygText = this.exportWysiwygContent(pubId, publicationDetail.getInstanceId(), gedIE, exportPublicationRelativePath, exportPublicationPath, wysiwygContent, publicationType.getPublicationDetail().getLanguage());
                } else if (xmlModel != null) {
                    this.exportXmlForm(new PublicationPK(pubId, publicationDetail.getInstanceId()), gedIE, exportPublicationRelativePath, exportPublicationPath, xmlModel);
                }
            }
            this.exportAttachments(attachmentIE, publicationType, publicationDetail.getPK(), exportPublicationRelativePath, exportPublicationPath);
            this.exportPdc(this.pdcImportExport, publicationDetail.getPK(), gedIE, publicationType);
            int nbThemes = 1;
            if (!gedIE.isKmax()) {
                nbThemes = this.getNbThemes(gedIE, publicationType, rootPK);
            }
            if (!this.writePublicationHtml(exportReport, wysiwygText, pubId, publicationType, exportPublicationRelativePath, exportPublicationPath, nbThemes)) {
                return Collections.emptyList();
            }
            wysiwygText = null;
        }
        return listPubType;
    }

    private String exportWysiwygContent(String pubId, String componentId, GEDImportExport gedIE, String exportPublicationRelativePath, String exportPublicationPath, WysiwygContentType wysiwygContent, String language) throws ImportExportException {
        String wysiwygText;
        String wysiwygFileName = wysiwygContent.getPath();
        gedIE.copyWysiwygImageForExport(pubId, componentId, exportPublicationPath);
        try {
            wysiwygText = WysiwygController.load((String)componentId, (String)pubId, (String)language);
            wysiwygText = HtmlExportPublicationGenerator.replaceImagesPathForExport(wysiwygText);
            wysiwygText = WysiwygContentTransformer.on((String)wysiwygText).resolveVariablesDirective().transform();
            if (wysiwygText == null) {
                wysiwygText = "";
            }
            FileFolderManager.createFile((String)exportPublicationPath, (String)wysiwygFileName, (String)wysiwygText);
        }
        catch (Exception e) {
            throw new ImportExportException("importExport", "importExport.EX_CANT_GET_WYSIWYG", e);
        }
        wysiwygContent.setPath(exportPublicationRelativePath + File.separator + wysiwygFileName);
        return wysiwygText;
    }

    private boolean writePublicationHtml(ExportReport exportReport, String wysiwygText, String pubId, PublicationType publicationType, String exportPublicationRelativePath, String exportPublicationPath, int nbThemes) {
        String htmlNameIndex = "index.html";
        HtmlExportPublicationGenerator s = new HtmlExportPublicationGenerator(publicationType, wysiwygText, exportPublicationRelativePath + File.separator + htmlNameIndex, nbThemes);
        exportReport.addHtmlIndex(pubId, s);
        File fileHTML = new File(exportPublicationPath + File.separator + htmlNameIndex);
        try {
            fileHTML.createNewFile();
            FileUtils.write((File)fileHTML, (CharSequence)s.toHtml(), (Charset)Charsets.UTF_8);
        }
        catch (IOException ex) {
            SilverLogger.getLogger((Object)this).silent((Throwable)ex);
            return false;
        }
        return true;
    }

    private void exportPdc(PdcImportExport pdcImpExp, PublicationPK pk, GEDImportExport gedIE, PublicationType publicationType) {
        try {
            List listClassifyPosition = pdcImpExp.getPositions(gedIE.getSilverObjectId(pk.getId()), pk.getInstanceId());
            if (listClassifyPosition != null && !listClassifyPosition.isEmpty()) {
                publicationType.setPdcPositionsType(listClassifyPosition);
            }
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).silent((Throwable)ex).warn("Cannot get PdC positions: {0}", new Object[]{ex.getMessage()});
        }
    }

    private void exportAttachments(AttachmentImportExport attachmentIE, PublicationType publicationType, PublicationPK publicationPK, String exportRelativePath, String exportPath) throws ImportExportException {
        List<AttachmentDetail> attachments = attachmentIE.getAttachments(publicationPK.toResourceReference(), exportPath, exportRelativePath, null);
        if (attachments != null && !attachments.isEmpty() && publicationType != null) {
            publicationType.setAttachmentsType(attachments);
        }
    }

    private void exportXmlForm(PublicationPK publicationPk, GEDImportExport gedIE, String exportPublicationRelativePath, String exportPublicationPath, XMLModelContentType xmlModel) {
        List<XMLField> xmlFields = xmlModel.getFields();
        for (XMLField xmlField : xmlFields) {
            SimpleDocument attachment;
            String value = xmlField.getValue();
            if (!StringUtil.isDefined((String)value)) continue;
            if (value.startsWith("xmlWysiwygField")) {
                String wysiwygFile = value.substring(value.indexOf(95) + 1);
                try {
                    String fromPath = FileRepositoryManager.getAbsolutePath((String)publicationPk.getInstanceId()) + "xmlWysiwyg" + File.separator + wysiwygFile;
                    FileRepositoryManager.copyFile((String)fromPath, (String)(exportPublicationPath + File.separator + wysiwygFile));
                    gedIE.copyWysiwygImageForExport(publicationPk.getId(), publicationPk.getInstanceId(), exportPublicationPath);
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).silent((Throwable)e).warn("Cannot write WYSIWYG content: {0}", new Object[]{e.getMessage()});
                }
                continue;
            }
            if (value.startsWith("image_") || value.startsWith("file_")) {
                String imageId = value.substring(value.indexOf(95) + 1, value.length());
                attachment = null;
                try {
                    attachment = AttachmentServiceProvider.getAttachmentService().searchDocumentById(new SimpleDocumentPK(imageId, publicationPk.getInstanceId()), null);
                }
                catch (Exception e1) {
                    SilverLogger.getLogger((Object)this).error(new SilverpeasExceptionMessages.LightExceptionMessage((Object)this, e1).singleLineWith(MessageFormat.format("Cannot get file #{0} of publication #{1} on instanceId #{2} ({3})", imageId, publicationPk.getId(), publicationPk.getInstanceId(), e1.getMessage())), new Object[0]);
                }
                if (attachment == null) continue;
                try {
                    String fromPath = attachment.getAttachmentPath();
                    FileRepositoryManager.copyFile((String)fromPath, (String)(exportPublicationPath + File.separator + attachment.getFilename()));
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error(new SilverpeasExceptionMessages.LightExceptionMessage((Object)this, e).singleLineWith(MessageFormat.format("Cannot write file #{0} ({1}) of publication #{2} on instanceId #{3} ({4})", imageId, attachment.getNodeName(), publicationPk.getId(), publicationPk.getInstanceId(), e.getMessage())), new Object[0]);
                }
                xmlField.setValue(exportPublicationRelativePath + File.separator + attachment.getFilename());
                continue;
            }
            if (!value.startsWith("file")) continue;
            String fileId = value.substring(value.indexOf(95) + 1, value.length());
            attachment = null;
            try {
                attachment = AttachmentServiceProvider.getAttachmentService().searchDocumentById(new SimpleDocumentPK(fileId, publicationPk.getInstanceId()), null);
            }
            catch (Exception e1) {
                SilverLogger.getLogger((Object)this).error(new SilverpeasExceptionMessages.LightExceptionMessage((Object)this, e1).singleLineWith(MessageFormat.format("Cannot get file #{0} of publication #{1} on instanceId #{2} ({3})", fileId, publicationPk.getId(), publicationPk.getInstanceId(), e1.getMessage())), new Object[0]);
            }
            if (attachment == null) continue;
            xmlField.setValue(exportPublicationRelativePath + File.separator + attachment.getFilename());
        }
    }

    private String createDirectoryPathForExport(String exportPath, NodePK rootPK, NodePK pk, boolean useNameForFolders) throws IOException {
        StringBuilder pathToCreate = new StringBuilder(exportPath);
        ArrayList listNodes = new ArrayList(this.nodeImportExport.getPathOfNode(pk));
        Collections.reverse(listNodes);
        boolean rootFound = false;
        for (NodeDetail nodeDetail : listNodes) {
            if (nodeDetail.getNodePK().equals((Object)rootPK)) {
                rootFound = true;
            }
            if (!rootFound) continue;
            String nodeNameForm = nodeDetail.getNodePK().getId();
            if (useNameForFolders) {
                nodeNameForm = DirectoryUtils.formatToDirectoryNamingCompliant(nodeDetail.getName());
            }
            pathToCreate.append(File.separator).append(nodeNameForm);
        }
        return this.createASCIIPath(pathToCreate.toString());
    }

    private String createASCIIPath(String path) throws IOException {
        boolean creationOK;
        String pathToCreateAscii = FileServerUtils.replaceAccentChars((String)path);
        File dir = new File(pathToCreateAscii);
        if (!dir.exists() && !(creationOK = dir.mkdirs())) {
            IOException ioException = new IOException(MessageFormat.format("Cannot create folder {0}", dir));
            SilverLogger.getLogger((Object)this).error(new SilverpeasExceptionMessages.LightExceptionMessage((Object)this, (Exception)ioException).singleLineWith(ioException.getMessage()), new Object[0]);
            throw ioException;
        }
        return pathToCreateAscii;
    }

    private String createPathDirectoryForPublicationExport(String exportPath, int topicId, String componentId, String componentLabel, PublicationDetail pub, boolean useNameForFolders, boolean exportPublicationPath) throws ImportExportException {
        String pubNameForm = pub.getPK().getId();
        if (useNameForFolders) {
            pubNameForm = DirectoryUtils.formatToDirectoryNamingCompliant(pub.getName());
        }
        StringBuilder relativeExportPath = new StringBuilder();
        StringBuilder pathToCreate = new StringBuilder(exportPath);
        if (exportPublicationPath) {
            String componentLabelForm = componentId;
            if (useNameForFolders || this.isKmax(componentId)) {
                componentLabelForm = DirectoryUtils.formatToDirectoryNamingCompliant(componentLabel);
            }
            relativeExportPath.append(componentLabelForm);
            pathToCreate.append(File.separatorChar).append(componentLabelForm);
            ArrayList listNodes = new ArrayList(this.nodeImportExport.getPathOfNode(new NodePK(String.valueOf(topicId), "useless", componentId)));
            Collections.reverse(listNodes);
            for (NodeDetail nodeDetail : listNodes) {
                String nodeNameForm = nodeDetail.getNodePK().getId();
                if (useNameForFolders) {
                    nodeNameForm = DirectoryUtils.formatToDirectoryNamingCompliant(nodeDetail.getName());
                }
                pathToCreate.append(File.separator).append(nodeNameForm);
                relativeExportPath.append(File.separator).append(nodeNameForm);
            }
        }
        relativeExportPath.append(File.separator).append(pubNameForm);
        pathToCreate.append(File.separator).append(pubNameForm);
        String relativeExportPathAscii = FileServerUtils.replaceAccentChars((String)relativeExportPath.toString());
        try {
            this.createASCIIPath(pathToCreate.toString());
        }
        catch (IOException e) {
            throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", e);
        }
        return relativeExportPathAscii;
    }

    public void processExportOfFilesOnly(ExportReport exportReport, UserDetail userDetail, List<WAAttributeValuePair> listItemsToExport, String exportPath, NodePK nodeRootPK, boolean useNameForFolders) throws ImportExportException, IOException {
        AttachmentImportExport attachmentIE = new AttachmentImportExport(userDetail);
        GEDImportExport gedIE = null;
        if (listItemsToExport != null && !listItemsToExport.isEmpty()) {
            String componentId = listItemsToExport.get(0).getValue();
            gedIE = ImportExportFactory.createGEDImportExport(userDetail, componentId);
        }
        block0: for (WAAttributeValuePair attValue : listItemsToExport) {
            String pubId = attValue.getName();
            String componentId = attValue.getValue();
            PublicationPK pk = new PublicationPK(pubId, componentId);
            if (nodeRootPK == null || !StringUtil.isDefined((String)nodeRootPK.getId())) {
                this.exportAttachments(attachmentIE, null, pk, "", exportPath);
                continue;
            }
            List<Location> folderPKs = gedIE.getAllTopicsOfPublicationInSameComponentInstance(pk);
            folderPKs.addAll(gedIE.getAliases(pk));
            NodePK rightFolderPK = null;
            for (NodePK nodePK : folderPKs) {
                if (!nodePK.getInstanceId().equals(nodeRootPK.getInstanceId())) continue;
                ArrayList listNodes = new ArrayList(this.nodeImportExport.getPathOfNode(nodePK));
                Collections.reverse(listNodes);
                for (NodeDetail nodeDetail : listNodes) {
                    if (!nodeDetail.getNodePK().equals((Object)nodeRootPK)) continue;
                    rightFolderPK = nodePK;
                    break;
                }
                if (rightFolderPK == null) continue;
                String attachmentsExportPath = this.createDirectoryPathForExport(exportPath, nodeRootPK, rightFolderPK, useNameForFolders);
                this.exportAttachments(attachmentIE, null, pk, "", attachmentsExportPath);
                continue block0;
            }
        }
    }

    public List<AttachmentDetail> processPDFExport(ExportPDFReport exportReport, UserDetail userDetail, List<WAAttributeValuePair> listItemsToExport, String exportPath, boolean useNameForFolders, NodePK rootPK) throws ImportExportException, IOException {
        AttachmentImportExport attachmentIE = new AttachmentImportExport(userDetail);
        ArrayList<AttachmentDetail> result = new ArrayList<AttachmentDetail>();
        for (WAAttributeValuePair attValue : listItemsToExport) {
            String pubId = attValue.getName();
            String componentId = attValue.getValue();
            GEDImportExport gedIE = ImportExportFactory.createGEDImportExport(userDetail, componentId);
            PublicationType publicationType = gedIE.getPublicationCompleteById(pubId, componentId);
            PublicationDetail publicationDetail = publicationType.getPublicationDetail();
            this.fillPublicationType(gedIE, publicationType, rootPK);
            List<AttachmentDetail> attachments = attachmentIE.getAttachments(publicationDetail.getPK().toResourceReference(), exportPath, null, "pdf");
            if (attachments == null || attachments.isEmpty()) continue;
            result.addAll(attachments);
        }
        return result;
    }

    private String createPathDirectoryForKmaxPublicationExport(String exportPath, String componentId, String componentLabel, PublicationDetail pub, boolean useNameForFolders) throws IOException {
        String pubNameForm = useNameForFolders ? DirectoryUtils.formatToDirectoryNamingCompliant(pub.getName()) : pub.getPK().getId();
        String componentLabelForm = useNameForFolders || this.isKmax(componentId) ? DirectoryUtils.formatToDirectoryNamingCompliant(componentLabel) : componentId;
        String relativeExportPathAscii = FileServerUtils.replaceAccentChars((String)(componentLabelForm + File.separator + pubNameForm));
        this.createASCIIPath(exportPath + File.separatorChar + componentLabelForm + File.separator + pubNameForm);
        return relativeExportPathAscii;
    }

    public void processImport(List<PublicationType> publicationTypes, ImportSettings settings, ImportReportManager reportManager) {
        GEDImportExport gedIE = ImportExportFactory.createGEDImportExport(settings.getUser(), settings.getComponentId());
        AttachmentImportExport attachmentIE = new AttachmentImportExport(gedIE.getCurrentUserDetail());
        VersioningImport versioningIE = new VersioningImport(settings.getUser());
        ArrayList<Integer> nodesKmax = new ArrayList<Integer>();
        ArrayList<NodePositionType> nodes = new ArrayList();
        UserDetail userDetail = settings.getUser();
        for (PublicationType pubType : publicationTypes) {
            Object listCoordinatePointsType;
            String componentId = pubType.getComponentId() == null || pubType.getComponentId().length() == 0 ? settings.getComponentId() : pubType.getComponentId();
            gedIE.setCurrentComponentId(componentId);
            UnitReport unitReport = new UnitReport();
            reportManager.addUnitReport(unitReport, componentId);
            ComponentInst componentInst = OrganizationControllerProvider.getOrganisationController().getComponentInst(componentId);
            if (componentInst == null) {
                unitReport.setError(1);
                unitReport.setStatus(3);
                continue;
            }
            reportManager.setComponentName(componentId, componentInst.getLabel());
            PublicationDetail pubDetailToCreate = pubType.getPublicationDetail();
            List<AttachmentDetail> attachments = pubType.getAttachmentsType();
            List<Document> documents = pubType.getDocumentsType();
            if (pubDetailToCreate == null) {
                if (pubType.getId() == -1) {
                    if (attachments != null && !attachments.isEmpty()) {
                        AttachmentDetail attachment = attachments.get(0);
                        File file = new File(attachment.getPhysicalName());
                        pubDetailToCreate = PublicationImportExport.convertFileInfoToPublicationDetail(file, settings);
                    } else {
                        pubDetailToCreate = PublicationDetail.builder().setNameAndDescription("pub temp", "description").created(new Date(), userDetail.getId()).setImportance(1).setBeginDateTime(new Date(), "").build();
                    }
                } else {
                    pubDetailToCreate = PublicationDetail.builder().build();
                }
            }
            if (pubDetailToCreate == null) continue;
            pubDetailToCreate.setPk(new PublicationPK(null, "useless", componentId));
            if (pubType.getId() != -1) {
                pubDetailToCreate.getPK().setId(Integer.toString(pubType.getId()));
            }
            this.checkPublication(pubDetailToCreate, userDetail);
            if (this.isKmax(componentId)) {
                List coordinates = pubType.getCoordinatesPositionsType().getCoordinatesPositions();
                boolean createCoordinateAllowed = pubType.getCoordinatesPositionsType().getCreateEnable();
                if (coordinates != null) {
                    for (Coordinate coordinate : coordinates) {
                        if (coordinate == null || (listCoordinatePointsType = coordinate.getCoordinatePoints()) == null) continue;
                        StringBuilder coordinatePointsPath = new StringBuilder("");
                        boolean first = true;
                        Iterator iterator = listCoordinatePointsType.iterator();
                        while (iterator.hasNext()) {
                            CoordinatePointType coordinatePointType = (CoordinatePointType)iterator.next();
                            if (!StringUtil.isDefined((String)coordinatePointType.getValue())) continue;
                            NodeDetail nodeDetail = this.coordinateImportExport.getNodeDetailByName(coordinatePointType.getValue(), coordinatePointType.getAxisId(), componentId);
                            if (nodeDetail == null && createCoordinateAllowed) {
                                NodeDetail position = new NodeDetail("toDefine", coordinatePointType.getValue(), "", Integer.valueOf("0").intValue(), String.valueOf(coordinatePointType.getAxisId()));
                                position.setCreatorId(userDetail.getId());
                                nodeDetail = this.coordinateImportExport.addPosition(position, String.valueOf(coordinatePointType.getAxisId()), componentId);
                            }
                            if (nodeDetail == null) continue;
                            if (first) {
                                coordinatePointsPath.append(nodeDetail.getPath()).append(nodeDetail.getId());
                                first = false;
                                continue;
                            }
                            coordinatePointsPath.append(",").append(nodeDetail.getPath()).append(nodeDetail.getId());
                        }
                        int coordinateId = this.coordinateImportExport.addPositions(componentId, coordinatePointsPath.toString());
                        if (coordinateId == 0) {
                            unitReport.setError(8);
                            continue;
                        }
                        nodesKmax.add(coordinateId);
                    }
                }
            } else {
                nodes = pubType.getNodePositionsType();
            }
            PublicationDetail pubDetail = gedIE.createPublicationForUnitImport(unitReport, settings, pubDetailToCreate, nodes);
            try {
                block40: {
                    if (pubDetail == null) continue;
                    unitReport.setLabel(pubDetail.getPK().getId());
                    if (this.isKmax(componentId)) {
                        PublicationImportExport.addNodesToPublication(pubDetail.getPK(), nodesKmax);
                    }
                    if (pubType.getPublicationContentType() != null) {
                        try {
                            gedIE.createPublicationContent(reportManager, unitReport, Integer.parseInt(pubDetail.getId()), pubType.getPublicationContentType(), userDetail.getId(), pubDetail.getLanguage());
                        }
                        catch (ImportExportException ex) {
                            SilverLogger.getLogger((Object)this).silent((Throwable)((Object)ex));
                            if (unitReport.getError() != -1) break block40;
                            unitReport.setError(9);
                        }
                    }
                }
                long maximumFileSize = FileRepositoryManager.getUploadMaximumFileSize();
                if (attachments != null) {
                    ArrayList<AttachmentDetail> attachmentsSizeOk = new ArrayList<AttachmentDetail>();
                    listCoordinatePointsType = attachments.iterator();
                    while (listCoordinatePointsType.hasNext()) {
                        AttachmentDetail attdetail = (AttachmentDetail)listCoordinatePointsType.next();
                        long fileSize = attdetail.getSize();
                        if (fileSize > maximumFileSize) {
                            unitReport.setError(13);
                            continue;
                        }
                        MetaData metaData = null;
                        if (AttachmentSettings.isUseFileMetadataForAttachmentDataEnabled() && settings.isPoiUsed()) {
                            metaData = MetadataExtractor.get().extractMetadata(attdetail.getAttachmentPath());
                            if (!StringUtil.isDefined((String)attdetail.getTitle()) && StringUtil.isDefined((String)metaData.getTitle())) {
                                attdetail.setTitle(metaData.getTitle());
                            }
                            if (!StringUtil.isDefined((String)attdetail.getDescription()) && StringUtil.isDefined((String)metaData.getSubject())) {
                                attdetail.setDescription(metaData.getSubject());
                            }
                        }
                        if (AttachmentSettings.isUseFileMetadataForAttachmentDataEnabled() && settings.useFileDates()) {
                            if (metaData == null) {
                                metaData = MetadataExtractor.get().extractMetadata(attdetail.getAttachmentPath());
                            }
                            if (metaData.getCreationDate() != null) {
                                attdetail.setCreationDate(metaData.getCreationDate());
                            }
                        }
                        attachmentsSizeOk.add(attdetail);
                    }
                    List<Pair<AttachmentDetail, SimpleDocument>> importedDocuments = ImportExportHelper.isVersioningUsed(componentInst) ? versioningIE.importDocuments(pubDetail.getId(), componentId, attachmentsSizeOk, pubDetail.isIndexable()) : attachmentIE.importAttachments(pubDetail.getId(), componentId, attachmentsSizeOk, pubDetail.isIndexable());
                    if (importedDocuments.size() != attachmentsSizeOk.size()) {
                        unitReport.setError(2);
                    }
                    reportManager.addNumberOfFilesProcessed(importedDocuments.size());
                    reportManager.addNumberOfFilesNotImported(attachments.size() - importedDocuments.size());
                    importedDocuments.stream().map(Pair::getFirst).forEach(d -> reportManager.addImportedFileSize(d.getSize(), componentId));
                }
                if (CollectionUtil.isNotEmpty(documents)) {
                    int nbFiles = 0;
                    ArrayList<Document> documentsSizeOk = new ArrayList<Document>();
                    for (Document documentDetail : documents) {
                        ArrayList<DocumentVersion> documentVersionsSizeOk = new ArrayList<DocumentVersion>();
                        List<DocumentVersion> documentVersions = documentDetail.getVersionsType();
                        nbFiles += documentVersions.size();
                        for (DocumentVersion documentVersionDetail : documentVersions) {
                            long fileSize = documentVersionDetail.getSize();
                            if (fileSize > maximumFileSize) {
                                unitReport.setError(13);
                                continue;
                            }
                            documentVersionsSizeOk.add(documentVersionDetail);
                        }
                        documentDetail.setVersionsType(documentVersionsSizeOk);
                        documentsSizeOk.add(documentDetail);
                    }
                    List<SimpleDocument> copiedFiles = versioningIE.importDocuments(new ResourceReference(pubDetail.getId(), componentId), documentsSizeOk, Integer.parseInt(userDetail.getId()), ImportExportHelper.isIndexable(pubDetail));
                    reportManager.addNumberOfFilesProcessed(copiedFiles.size());
                    reportManager.addNumberOfFilesNotImported(nbFiles - copiedFiles.size());
                    for (SimpleDocument version : copiedFiles) {
                        reportManager.addImportedFileSize(version.getSize(), componentId);
                    }
                }
                try {
                    List positions;
                    boolean pdcOK;
                    int silverObjectId = gedIE.getSilverObjectId(pubDetail.getId());
                    if (pubType.getPdcPositionsType() != null && !(pdcOK = this.pdcImportExport.addPositions(silverObjectId, componentId, pubType.getPdcPositionsType()))) {
                        unitReport.setError(8);
                    }
                    if ((positions = this.pdcImportExport.getPositions(silverObjectId, componentId)) != null || !this.pdcImportExport.isClassifyingMandatory(componentId) || !ImportExportHelper.isDraftUsed(componentInst)) continue;
                    gedIE.publicationNotClassifiedOnPDC(pubDetail.getId());
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).silent((Throwable)e);
                    unitReport.setError(8);
                }
            }
            catch (Exception ex) {
                SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
                unitReport.setError(0);
                SilverpeasTransverseErrorUtil.throwTransverseErrorIfAny((Exception)ex, (String)userDetail.getUserPreferences().getLanguage());
            }
        }
    }

    private void checkPublication(PublicationDetail publication, UserDetail userDetail) {
        if (publication.getCreationDate() == null) {
            publication.setCreationDate(new Date());
        }
        publication.setCreatorId(ImportExportHelper.checkUserId(publication.getCreatorId(), userDetail));
        publication.setUpdaterId(ImportExportHelper.checkUserId(publication.getUpdaterId(), userDetail));
        if (publication.getImportance() == 0) {
            publication.setImportance(5);
        }
    }

    private boolean isKmax(String currentComponentId) {
        return currentComponentId.startsWith("kmax");
    }

    public void fillPublicationType(GEDImportExport gedIE, PublicationType publicationType, NodePK rootPK) throws ImportExportException {
        PublicationPK pk = new PublicationPK(String.valueOf(publicationType.getId()), publicationType.getComponentId());
        ArrayList<NodePositionType> listNodePos = new ArrayList<NodePositionType>();
        List<Location> listNodePK = gedIE.getAllTopicsOfPublicationInSameComponentInstance(pk);
        if (rootPK != null && !rootPK.getInstanceId().equals(pk.getInstanceId())) {
            listNodePK = gedIE.getAliases(pk);
        }
        for (NodePK nodePK : listNodePK) {
            if (rootPK != null && !nodePK.getInstanceId().equals(rootPK.getInstanceId())) continue;
            NodePositionType nodePos = new NodePositionType();
            nodePos.setId(Integer.parseInt(nodePK.getId()));
            listNodePos.add(nodePos);
        }
        if (listNodePos.isEmpty()) {
            NodePositionType nodePos = new NodePositionType();
            nodePos.setId(Integer.parseInt("2"));
            listNodePos.add(nodePos);
        }
        publicationType.setNodePositionsType(listNodePos);
    }

    public int getNbThemes(GEDImportExport gedIE, PublicationType publicationType, NodePK rootPK) throws ImportExportException {
        int nbThemes = 1;
        List<NodePositionType> positions = publicationType.getNodePositionsType();
        if (positions != null && !positions.isEmpty()) {
            String instanceId = publicationType.getComponentId();
            if (rootPK != null) {
                instanceId = rootPK.getInstanceId();
            }
            NodePK pk = new NodePK(String.valueOf(positions.get(0).getId()), instanceId);
            nbThemes = gedIE.getTopicTree(pk).size();
        }
        return nbThemes;
    }
}

