/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.appengine.filter;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.appengine.filter.FilterChainImpl;
import com.sun.portal.portletcontainer.appengine.filter.FilterConfigImpl;
import com.sun.portal.portletcontainer.appengine.filter.PortletFilterMapInfo;
import com.sun.portal.portletcontainer.common.PortletActions;
import com.sun.portal.portletcontainer.common.descriptor.FilterDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.FilterMappingDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.portlet.Portlet;
import javax.portlet.PortletContext;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.PortletFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterChainFactory {
    private Map<String, Object> filterObjectMap = null;
    private Map<String, Set<String>> filterNameAndLifecycleMap = null;
    private Map<String, PortletFilterMapInfo> portletFilterMapInfoMap = new HashMap<String, PortletFilterMapInfo>();
    private static Logger logger = ContainerLogger.getLogger(FilterChainFactory.class, (String)"PAELogMessages");

    public FilterChainFactory(PortletAppDescriptor portletAppDescriptor, PortletContext context) {
        if (portletAppDescriptor.getFilterDescriptors() != null && portletAppDescriptor.getFilterMappingDescriptors() != null) {
            this.createFilters(portletAppDescriptor, context);
            this.populatePortletFilterMapInfoMap(portletAppDescriptor);
        }
    }

    private void createFilters(PortletAppDescriptor portletAppDescriptor, PortletContext context) {
        List<FilterDescriptor> filterDescriptorList = portletAppDescriptor.getFilterDescriptors();
        this.filterNameAndLifecycleMap = new HashMap<String, Set<String>>(filterDescriptorList.size());
        this.filterObjectMap = new HashMap<String, Object>(filterDescriptorList.size());
        for (FilterDescriptor filterDescriptor : filterDescriptorList) {
            Object filter = this.createFilter(filterDescriptor, context);
            if (filter == null) continue;
            this.filterObjectMap.put(filterDescriptor.getFilterName(), filter);
            this.filterNameAndLifecycleMap.put(filterDescriptor.getFilterName(), filterDescriptor.getFilterLifecycles());
        }
    }

    private List<String> getMatchingPortletNames(PortletAppDescriptor portletAppDescriptor, String portletNameWithWildCharacter) {
        if (portletNameWithWildCharacter.equals("*")) {
            return portletAppDescriptor.getPortletsDescriptor().getPortletNames();
        }
        ArrayList<String> matchingPortletList = new ArrayList<String>();
        String portletNameStartsWith = portletNameWithWildCharacter.substring(0, portletNameWithWildCharacter.length() - 1);
        for (String portletName : portletAppDescriptor.getPortletsDescriptor().getPortletNames()) {
            if (!portletName.startsWith(portletNameStartsWith)) continue;
            matchingPortletList.add(portletName);
        }
        return matchingPortletList;
    }

    private Object createFilter(FilterDescriptor filterDescriptor, PortletContext context) {
        String filterName = filterDescriptor.getFilterName();
        String filterClassName = filterDescriptor.getFilterClass();
        Set<String> lifecycleMethods = filterDescriptor.getFilterLifecycles();
        try {
            if (filterClassName == null || filterClassName.equals("")) {
                logger.log(Level.WARNING, "PSPL_PAECSPPAF0001", filterName);
                return null;
            }
            this.validateFilterLifecycleNames(lifecycleMethods);
            if (lifecycleMethods == null || lifecycleMethods.isEmpty()) {
                logger.log(Level.WARNING, "PSPL_PAECSPPAF0002", filterName);
                return null;
            }
            logger.log(Level.FINEST, "PSPL_PAECSPPAF0003", filterName);
            Class<?> filterClass = Thread.currentThread().getContextClassLoader().loadClass(filterClassName);
            Object filter = filterClass.newInstance();
            if (filter instanceof PortletFilter) {
                ((PortletFilter)filter).init((FilterConfig)new FilterConfigImpl(context, filterDescriptor));
            } else {
                logger.log(Level.SEVERE, "PSPL_PAECSPPAF0004", filterName);
            }
            logger.log(Level.INFO, "PSPL_PAECSPPAF0005", filterName);
            return filter;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSPL_PAECSPPAF0006");
                record.setThrown(e);
                record.setParameters(new String[]{filterName});
                logger.log(record);
            }
            return null;
        }
    }

    public FilterChain getPortletFilterChain(String portletName, Portlet p, String lifecyclePhase) {
        List<Object> applicableFilters = this.getApplicableFiltersForPortlet(portletName, lifecyclePhase);
        if (applicableFilters != null) {
            return new FilterChainImpl(p, applicableFilters);
        }
        return null;
    }

    private void populatePortletFilterMapInfoMap(PortletAppDescriptor portletAppDescriptor) {
        List<FilterMappingDescriptor> filterMappingDescriptorList = portletAppDescriptor.getFilterMappingDescriptors();
        for (FilterMappingDescriptor filterMappingDescriptor : filterMappingDescriptorList) {
            String filterName = filterMappingDescriptor.getFilterName();
            Set portletNames = filterMappingDescriptor.getPortletNames();
            if (this.filterObjectMap.containsKey(filterName) && portletNames != null) {
                for (String portletName : portletNames) {
                    if (portletName.endsWith("*")) {
                        this.addFilterToPortlets(filterName, this.getMatchingPortletNames(portletAppDescriptor, portletName), this.filterObjectMap.get(filterName));
                        continue;
                    }
                    this.addFilterToPortlet(filterName, portletName, this.filterObjectMap.get(filterName));
                }
                continue;
            }
            logger.log(Level.WARNING, "PSPL_PAECSPPAF0008", filterName);
        }
    }

    private List<Object> getApplicableFiltersForPortlet(String portletName, String lifecyclePhase) {
        if (this.portletFilterMapInfoMap.containsKey(portletName)) {
            return this.portletFilterMapInfoMap.get(portletName).getApplicableFilters(lifecyclePhase);
        }
        return null;
    }

    private void addFilterToPortlets(String filterName, List<String> portletList, Object filter) {
        for (String portletName : portletList) {
            this.addFilterToPortlet(filterName, portletName, filter);
        }
    }

    private void addFilterToPortlet(String filterName, String portletName, Object filter) {
        if (this.portletFilterMapInfoMap.containsKey(portletName)) {
            this.portletFilterMapInfoMap.get(portletName).addFilter(filter, this.filterNameAndLifecycleMap.get(filterName));
        } else {
            PortletFilterMapInfo filterMapInfo = new PortletFilterMapInfo(portletName);
            filterMapInfo.addFilter(filter, this.filterNameAndLifecycleMap.get(filterName));
            this.portletFilterMapInfoMap.put(portletName, filterMapInfo);
        }
    }

    public void clear() {
        if (this.filterObjectMap != null) {
            for (Object filter : this.filterObjectMap.values()) {
                ((PortletFilter)filter).destroy();
            }
        }
        this.filterObjectMap = null;
    }

    private void validateFilterLifecycleNames(Set lifecycleMethods) {
        if (lifecycleMethods != null) {
            Iterator iter = lifecycleMethods.iterator();
            while (iter.hasNext()) {
                if (PortletActions.isValidLifecyclePhase((String)iter.next())) continue;
                iter.remove();
            }
        }
    }
}

