/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.util;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlUtils.class);

    public static Document newDocument(String xml) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", true);
        features.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        for (Map.Entry entry : features.entrySet()) {
            try {
                factory.setFeature((String)entry.getKey(), (Boolean)entry.getValue());
            }
            catch (ParserConfigurationException e) {
                LOGGER.warn("Failed setting XML feature {}: {}", entry.getKey(), (Object)e);
            }
        }
        factory.setNamespaceAware(true);
        try {
            return factory.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new RuntimeException("XML parsing error: " + e);
        }
    }

    public static XMLReader getXmlReader() {
        try {
            XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return reader;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create XMLReader", e);
        }
    }

    public static List<String> getTextForElements(String xmlAsString, final String element) {
        final ArrayList<String> elements = new ArrayList<String>(2);
        XMLReader reader = XmlUtils.getXmlReader();
        DefaultHandler handler = new DefaultHandler(){
            private boolean foundElement = false;
            private StringBuilder buffer = new StringBuilder();

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (localName.equals(element)) {
                    this.foundElement = true;
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (localName.equals(element)) {
                    this.foundElement = false;
                    elements.add(this.buffer.toString());
                    this.buffer = new StringBuilder();
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.foundElement) {
                    this.buffer.append(ch, start, length);
                }
            }
        };
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        try {
            reader.parse(new InputSource(new StringReader(xmlAsString)));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return elements;
    }

    public static String getTextForElement(String xmlAsString, final String element) {
        XMLReader reader = XmlUtils.getXmlReader();
        final StringBuilder builder = new StringBuilder();
        DefaultHandler handler = new DefaultHandler(){
            private boolean foundElement = false;

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (localName.equals(element)) {
                    this.foundElement = true;
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (localName.equals(element)) {
                    this.foundElement = false;
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.foundElement) {
                    builder.append(ch, start, length);
                }
            }
        };
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        try {
            reader.parse(new InputSource(new StringReader(xmlAsString)));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return builder.toString();
    }
}

