/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.wbe;

import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.silverpeas.core.wbe.WbeFile;
import org.silverpeas.core.wbe.WbeLogger;
import org.silverpeas.core.wbe.WbeUser;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

public class WbeCache {
    private final Map<String, Element<WbeUser>> wbeUserCache = new ConcurrentHashMap<String, Element<WbeUser>>();
    private final Map<String, String> wbeAccessTokenUserMapping = new ConcurrentHashMap<String, String>();
    private final Map<String, Set<String>> wbeUserIdUserMapping = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Element<WbeFile>> wbeFileCache = new ConcurrentHashMap<String, Element<WbeFile>>();
    private final Map<String, String> silverpeasResourceWbeFileMapping = new ConcurrentHashMap<String, String>();
    private final Map<String, Set<String>> wbeFileUsersEditionCache = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> wbeUserFilesEditionCache = new ConcurrentHashMap<String, Set<String>>();

    List<WbeUser> listAllUsers() {
        return this.getConsistentWbeUserCache().values().stream().map(Element::get).collect(Collectors.toList());
    }

    List<WbeFile> listAllFiles() {
        return this.getConsistentWbeFileCache().values().stream().map(Element::get).collect(Collectors.toList());
    }

    Optional<Pair<String, WbeUser>> getFileFromAccessToken(String accessToken) {
        return Optional.ofNullable(this.wbeAccessTokenUserMapping.get(accessToken)).map(j -> Pair.of((Object)j, this.wbeUserCache.get(j))).filter(p -> p.getSecond() != null).map(p -> Pair.of((Object)((String)p.getFirst()), (Object)((WbeUser)((Element)p.getSecond()).get())));
    }

    Optional<WbeFile> getFileFromId(String fileId) {
        return Optional.ofNullable(this.wbeFileCache.get(fileId)).map(Element::get);
    }

    WbeUser computeUserIfAbsent(String spSessionId, Supplier<WbeUser> userSupplier) {
        return (WbeUser)this.wbeUserCache.computeIfAbsent(spSessionId, j -> {
            WbeUser wbeUser = (WbeUser)userSupplier.get();
            this.wbeAccessTokenUserMapping.putIfAbsent(wbeUser.getAccessToken(), spSessionId);
            this.wbeUserIdUserMapping.computeIfAbsent(wbeUser.getId(), k -> Collections.synchronizedSet(new HashSet())).add(spSessionId);
            return new Element<WbeUser>(wbeUser, w -> {
                String wuId = this.wbeAccessTokenUserMapping.remove(w.getAccessToken());
                Set<String> spSessionIds = this.wbeUserIdUserMapping.get(w.getId());
                spSessionIds.remove(w.getSilverpeasSessionId());
                if (spSessionIds.isEmpty()) {
                    this.wbeUserIdUserMapping.remove(w.getId());
                }
                this.wbeUserFilesEditionCache.remove(wuId);
                this.wbeFileUsersEditionCache.forEach((k, v) -> v.remove(wuId));
            });
        }).get();
    }

    WbeFile computeFileIfAbsent(WbeFile file) {
        String silverpeasId = file.silverpeasId();
        String fileId = file.id();
        String existingFileId = this.silverpeasResourceWbeFileMapping.get(silverpeasId);
        if (existingFileId != null && !existingFileId.equals(fileId)) {
            try {
                this.wbeFileCache.remove(existingFileId).notifyRemove();
            }
            catch (NullPointerException e) {
                this.silverpeasResourceWbeFileMapping.remove(silverpeasId);
                WbeLogger.logger().warn("file {0} was altered into cache... Cache has been cleaned", new Object[]{existingFileId});
            }
        }
        return (WbeFile)this.wbeFileCache.computeIfAbsent(fileId, i -> {
            this.silverpeasResourceWbeFileMapping.putIfAbsent(silverpeasId, fileId);
            return new Element<WbeFile>(file, f -> {
                String wfId = this.silverpeasResourceWbeFileMapping.remove(silverpeasId);
                this.wbeFileUsersEditionCache.remove(wfId);
                this.wbeUserFilesEditionCache.forEach((key, value) -> value.remove(wfId));
            });
        }).get();
    }

    void removeUser(WbeUser user) {
        String sessionId = user.getSilverpeasSessionId();
        Element<WbeUser> wbeUser = this.wbeUserCache.get(sessionId);
        if (wbeUser != null) {
            wbeUser.notifyRemove();
            this.wbeUserCache.remove(sessionId);
            WbeLogger.logger().debug(() -> MessageFormat.format("releasing user with sessionId {0} (user {1})", sessionId, wbeUser));
        } else {
            WbeLogger.logger().debug("releasing user with sessionId {0} which was not into context", new Object[]{sessionId});
        }
    }

    void removeFile(WbeFile file) {
        String wbeFileId = this.silverpeasResourceWbeFileMapping.get(file.silverpeasId());
        if (wbeFileId != null) {
            Element<WbeFile> wbeFileElement = this.wbeFileCache.get(wbeFileId);
            if (wbeFileElement != null) {
                wbeFileElement.notifyRemove();
                this.wbeFileCache.remove(wbeFileId);
                WbeLogger.logger().debug(() -> MessageFormat.format("releasing silverpeas file with id {0} (WBE id {1})", file.silverpeasId(), wbeFileId));
            } else {
                WbeLogger.logger().warn("releasing document {0} from cache which was altered for this document", new Object[]{file.silverpeasId()});
            }
        }
    }

    void clear() {
        this.wbeAccessTokenUserMapping.clear();
        this.wbeUserCache.clear();
        this.silverpeasResourceWbeFileMapping.clear();
        this.wbeFileCache.clear();
        this.wbeFileUsersEditionCache.clear();
        this.wbeUserFilesEditionCache.clear();
    }

    void clearAllBefore(OffsetDateTime offset) {
        this.wbeFileCache.entrySet().removeIf(e -> {
            boolean toRemove;
            boolean bl = toRemove = offset.compareTo(((Element)e.getValue()).getLastAccess()) > 0;
            if (toRemove) {
                WbeLogger.logger().debug(() -> MessageFormat.format("removing from cache {0}", e));
                ((Element)e.getValue()).notifyRemove();
            }
            return toRemove;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerEdition(WbeFile file, Set<String> userIds) {
        Set userIdsInCache;
        Set<String> spSessionIds = userIds.stream().flatMap(i -> this.wbeUserIdUserMapping.get(i).stream()).filter(StringUtil::isDefined).collect(Collectors.toSet());
        String fileId = file.id();
        Set set = userIdsInCache = this.wbeFileUsersEditionCache.computeIfAbsent(fileId, s -> Collections.synchronizedSet(new HashSet()));
        synchronized (set) {
            HashSet removed = new HashSet(userIdsInCache.size());
            HashSet added = new HashSet(userIdsInCache.size());
            spSessionIds.forEach(i -> {
                if (!userIdsInCache.contains(i)) {
                    added.add(i);
                }
            });
            userIdsInCache.forEach(i -> {
                if (!spSessionIds.contains(i)) {
                    removed.add(i);
                }
            });
            userIdsInCache.removeAll(removed);
            userIdsInCache.addAll(added);
            removed.forEach(i -> this.wbeUserFilesEditionCache.computeIfPresent((String)i, (s, l) -> {
                l.remove(fileId);
                return l;
            }));
            added.forEach(i -> {
                Set fileIdsInCache = this.wbeUserFilesEditionCache.computeIfAbsent((String)i, s -> Collections.synchronizedSet(new HashSet()));
                fileIdsInCache.add(fileId);
            });
        }
    }

    List<WbeFile> getEditedFilesBy(WbeUser user) {
        return this.wbeUserIdUserMapping.get(user.getId()).stream().flatMap(s -> this.wbeUserFilesEditionCache.getOrDefault(s, Collections.emptySet()).stream()).map(this.wbeFileCache::get).filter(Objects::nonNull).map(Element::get).distinct().collect(Collectors.toList());
    }

    List<WbeUser> getEditorsOfFile(WbeFile file) {
        return this.wbeFileUsersEditionCache.getOrDefault(file.id(), Collections.emptySet()).stream().map(this.wbeUserCache::get).filter(Objects::nonNull).map(Element::get).collect(Collectors.toList());
    }

    private Map<String, Element<WbeUser>> getConsistentWbeUserCache() {
        return this.wbeUserCache;
    }

    private Map<String, Element<WbeFile>> getConsistentWbeFileCache() {
        Iterator<Map.Entry<String, Element<WbeFile>>> it = this.wbeFileCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Element<WbeFile>> entry = it.next();
            try {
                entry.getValue().get().id();
            }
            catch (Exception e) {
                it.remove();
                WbeLogger.logger().warn("removing WBE file indexed by id {0}", new Object[]{entry.getKey()});
            }
        }
        return this.wbeFileCache;
    }

    private static class Element<T> {
        private final T value;
        private final Consumer<T> onRemove;
        private OffsetDateTime lastAccess = OffsetDateTime.now();

        private Element(T value, Consumer<T> onRemove) {
            this.value = value;
            this.onRemove = onRemove;
        }

        T get() {
            this.lastAccess = OffsetDateTime.now();
            return this.value;
        }

        OffsetDateTime getLastAccess() {
            return this.lastAccess;
        }

        void notifyRemove() {
            this.onRemove.accept(this.value);
        }

        public String toString() {
            return new StringJoiner(", ", Element.class.getSimpleName() + "[", "]").add("element=" + this.value).add("lastAccess=" + this.lastAccess).toString();
        }
    }
}

