/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.wbe;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.wbe.WbeFile;
import org.silverpeas.kernel.util.StringUtil;

public class SimpleWbeFile
extends WbeFile {
    protected static final Object MUTEX = new Object();
    private final File file;

    public SimpleWbeFile(File file) {
        this.file = file;
    }

    public Optional<ResourceReference> linkedToResource() {
        return Optional.empty();
    }

    public String silverpeasId() {
        return StringUtil.asBase64((byte[])this.name().getBytes(Charsets.UTF_8)).replace("=", "-");
    }

    public User owner() {
        return User.getById((String)"0");
    }

    public String name() {
        return this.file.getName();
    }

    public String mimeType() {
        return FileUtil.getMimeType(this.file.getPath());
    }

    public long size() {
        return this.file.length();
    }

    public OffsetDateTime lastModificationDate() {
        return OffsetDateTime.ofInstant(new Date(this.file.lastModified()).toInstant(), ZoneId.systemDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFrom(InputStream input) throws IOException {
        Object object = MUTEX;
        synchronized (object) {
            try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(this.file));){
                IOUtils.copy((InputStream)input, (OutputStream)stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInto(OutputStream output) throws IOException {
        Object object = MUTEX;
        synchronized (object) {
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.file));){
                IOUtils.copy((InputStream)stream, (OutputStream)output);
            }
        }
    }

    public boolean canBeAccessedBy(User user) {
        return true;
    }
}

