/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class MailSettings {
    private static final String SMTP_SERVER = "SMTPServer";
    private static final String SMTP_AUTH = "SMTPAuthentication";
    private static final String SMTP_PORT = "SMTPPort";
    private static final String SMTP_LOGIN = "SMTPUser";
    private static final String SMTP_PASSWORD = "SMTPPwd";
    private static final String SMTP_DEBUG = "SMTPDebug";
    private static final String SMTP_SECURE = "SMTPSecure";
    private static Set<String> domains;
    public static final SettingBundle configuration;

    public static boolean isForceReplyToSenderField() {
        return configuration.getBoolean("ForceReplyToSenderField", false);
    }

    static void reloadConfiguration(String domainsList) {
        if (StringUtil.isDefined((String)domainsList)) {
            String[] authorizedDomains = StringUtil.split((String)domainsList, (char)',');
            domains = new HashSet<String>(authorizedDomains.length);
            for (String domain : authorizedDomains) {
                if (!StringUtil.isDefined((String)domain)) continue;
                domains.add(domain.trim());
            }
        } else {
            domains = Set.of();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized boolean isDomainAuthorized(String email) {
        if (!StringUtil.isDefined((String)email)) return false;
        String emailAddress = email.toLowerCase(I18NHelper.defaultLocale);
        if (domains.isEmpty()) return true;
        if (!domains.stream().map(d -> d.toLowerCase(I18NHelper.defaultLocale)).anyMatch(emailAddress::endsWith)) return false;
        return true;
    }

    public static synchronized InternetAddress getAuthorizedEmailAddress(String pFrom, String personalName) throws AddressException, UnsupportedEncodingException {
        String personal;
        String senderAddress = MailSettings.getAuthorizedEmail(pFrom);
        InternetAddress address = new InternetAddress(senderAddress, true);
        String string = personal = senderAddress.equals(pFrom) ? personalName : configuration.getString("NotificationPersonalName");
        if (StringUtil.isDefined((String)personal)) {
            address.setPersonal(personal, Charsets.UTF_8.name());
        }
        return address;
    }

    public static synchronized String getAuthorizedEmail(String email) {
        if (MailSettings.isDomainAuthorized(email)) {
            return email;
        }
        return configuration.getString("NotificationAddress");
    }

    public static String getMailServer() {
        return configuration.getString(SMTP_SERVER);
    }

    public static boolean isAuthenticated() {
        return configuration.getBoolean(SMTP_AUTH, false);
    }

    public static boolean isDebug() {
        return configuration.getBoolean(SMTP_DEBUG, false);
    }

    public static String getLogin() {
        return configuration.getString(SMTP_LOGIN);
    }

    public static String getPassword() {
        return configuration.getString(SMTP_PASSWORD);
    }

    public static int getPort() {
        return configuration.getInteger(SMTP_PORT, 25);
    }

    public static boolean isSecure() {
        return configuration.getBoolean(SMTP_SECURE, false);
    }

    private MailSettings() {
    }

    static {
        configuration = ResourceLocator.getSettingBundle((String)"org.silverpeas.notificationserver.channel.smtp.smtpSettings");
        MailSettings.reloadConfiguration(configuration.getString("AuthorizedDomains", ""));
    }
}

