/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.subscription.ResourceSubscriptionService;
import org.silverpeas.core.subscription.SubscriberDirective;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.subscription.constant.CommonSubscriptionResourceConstants;
import org.silverpeas.core.subscription.service.AbstractResourceSubscriptionService;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;

public class ResourceSubscriptionProvider {
    private static final Map<String, ResourceSubscriptionService> componentImplementations = new HashMap<String, ResourceSubscriptionService>();

    private ResourceSubscriptionProvider() {
    }

    public static void registerResourceSubscriptionService(AbstractResourceSubscriptionService service) {
        componentImplementations.put(service.getHandledComponentName(), service);
    }

    public static SubscriptionSubscriberList getSubscribersOfComponent(String componentInstanceId) {
        return ResourceSubscriptionProvider.getSubscribersOfComponentAndTypedResource(componentInstanceId, CommonSubscriptionResourceConstants.COMPONENT, null, new SubscriberDirective[0]);
    }

    public static SubscriptionSubscriberList getSubscribersOfComponentAndTypedResource(String componentInstanceId, SubscriptionResourceType resourceType, String resourceId, SubscriberDirective ... directives) {
        return ResourceSubscriptionProvider.getService(componentInstanceId).getSubscribersOfComponentAndTypedResource(componentInstanceId, resourceType, resourceId, directives);
    }

    public static SubscriptionSubscriberList getSubscribersOfSubscriptionResource(SubscriptionResource subscriptionResource, SubscriberDirective ... directives) {
        return ResourceSubscriptionProvider.getService(subscriptionResource.getInstanceId()).getSubscribersOfSubscriptionResource(subscriptionResource, directives);
    }

    private static ResourceSubscriptionService getService(String componentInstanceId) {
        Optional<SilverpeasComponentInstance> componentInstance = OrganizationController.get().getComponentInstance(componentInstanceId);
        if (!componentInstance.isPresent()) {
            throw new IllegalStateException("Component instance " + componentInstanceId + " is not valid.");
        }
        return componentInstance.map(i -> componentImplementations.get(i.getName())).orElseGet(() -> componentImplementations.get("default"));
    }
}

