/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.model;

import java.util.Date;
import java.util.Objects;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.date.DateTime;
import org.silverpeas.core.socialnetwork.model.SocialInformation;

public abstract class AbstractSocialInformation
implements SocialInformation {
    protected final ResourceReference resourceReference;
    protected String title;
    protected String description;
    protected String author;
    protected String url;
    protected Date date;
    protected boolean socialInformationWasupdated;
    protected String type;
    protected String icon;

    protected AbstractSocialInformation(ResourceReference resourceReference) {
        this.resourceReference = resourceReference;
    }

    @Override
    public ResourceReference getResourceReference() {
        return this.resourceReference;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public boolean isUpdated() {
        return this.socialInformationWasupdated;
    }

    @Override
    public void setUpdated(boolean updated) {
        this.socialInformationWasupdated = updated;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        if (this.isUpdated()) {
            return this.type + "_update.gif";
        }
        return this.type + "_new.gif";
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSocialInformation other = (AbstractSocialInformation)obj;
        if (!Objects.equals(this.title, other.title)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.author, other.author)) {
            return false;
        }
        if (!Objects.equals(this.url, other.url)) {
            return false;
        }
        if (!Objects.equals(this.date, other.date)) {
            return false;
        }
        return Objects.equals(this.resourceReference, other.resourceReference);
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + (this.title != null ? this.title.hashCode() : 0);
        hash = 71 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 71 * hash + (this.author != null ? this.author.hashCode() : 0);
        hash = 71 * hash + (this.url != null ? this.url.hashCode() : 0);
        hash = 71 * hash + (this.date != null ? this.date.hashCode() : 0);
        hash = 71 * hash + (this.resourceReference != null ? this.resourceReference.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(SocialInformation socialInfo) {
        DateTime myDate = new DateTime(this.getDate());
        DateTime otherDate = new DateTime(socialInfo.getDate());
        int result = ((DateTime)otherDate.getBeginOfDay()).compareTo((Date)myDate.getBeginOfDay());
        if (result == 0) {
            result = this.compareByUrl(socialInfo);
        }
        if (result == 0) {
            result = this.isUpdated() && !socialInfo.isUpdated() ? -1 : (!this.isUpdated() && socialInfo.isUpdated() ? 1 : socialInfo.getResourceReference().asString().compareTo(this.getResourceReference().asString()));
        }
        return result;
    }

    protected int compareByUrl(SocialInformation socialInfo) {
        int result = this.getUrl().compareTo(socialInfo.getUrl());
        if (result == 0) {
            boolean myIsComment = this.getType().contains("COMMENT");
            boolean otherIsComment = socialInfo.getType().contains("COMMENT");
            if (!myIsComment && otherIsComment || myIsComment && !otherIsComment) {
                result = myIsComment ? -1 : 1;
            }
        }
        return result;
    }
}

