/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.encryption.cipher;

import java.util.EnumMap;
import java.util.Map;
import org.silverpeas.core.security.encryption.cipher.AESCipher;
import org.silverpeas.core.security.encryption.cipher.BlowfishCipher;
import org.silverpeas.core.security.encryption.cipher.CAST5Cipher;
import org.silverpeas.core.security.encryption.cipher.CMSCipher;
import org.silverpeas.core.security.encryption.cipher.Cipher;
import org.silverpeas.core.security.encryption.cipher.CryptographicAlgorithmName;
import org.silverpeas.kernel.logging.SilverLogger;

public class CipherFactory {
    private static CipherFactory instance;
    private final Map<CryptographicAlgorithmName, Cipher> ciphers = new EnumMap<CryptographicAlgorithmName, Cipher>(CryptographicAlgorithmName.class);

    private CipherFactory() {
        try {
            this.ciphers.put(CryptographicAlgorithmName.BLOWFISH, new BlowfishCipher());
        }
        catch (Exception ex) {
            SilverLogger.getLogger(CipherFactory.class).error(ex.getMessage(), (Throwable)ex);
        }
        this.ciphers.put(CryptographicAlgorithmName.CMS, new CMSCipher());
        this.ciphers.put(CryptographicAlgorithmName.CAST5, new CAST5Cipher());
        this.ciphers.put(CryptographicAlgorithmName.AES, new AESCipher());
    }

    public static synchronized CipherFactory getFactory() {
        if (instance == null) {
            instance = new CipherFactory();
        }
        return instance;
    }

    public Cipher getCipher(CryptographicAlgorithmName cipherName) {
        return this.ciphers.get((Object)cipherName);
    }
}

