/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authorization;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.RemovedSpaceAndComponentInstanceChecker;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.security.authorization.AbstractAccessController;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.authorization.ComponentInstanceAccessControlExtension;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
public class ComponentAccessController
extends AbstractAccessController<String>
implements ComponentAccessControl {
    private static final String DATA_MANAGER_CONTEXT_KEY = "ComponentAccessControllerDataManager";
    private static final String RIGHTS_ON_TOPICS_PARAM_NAME = "rightsOnTopics";
    private final OrganizationController controller;

    @Inject
    ComponentAccessController(OrganizationController controller) {
        this.controller = controller;
    }

    public boolean isGroupAuthorized(String groupId, String instanceId) {
        try {
            Object group = this.controller.getGroup(groupId);
            return Optional.ofNullable(group).filter(Predicate.not(Group::isRemovedState).and(g -> this.controller.isComponentAvailableToGroup(instanceId, g.getId()))).isPresent();
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    static DataManager getDataManager(AccessControlContext context) {
        DataManager manager = (DataManager)context.get(DATA_MANAGER_CONTEXT_KEY, DataManager.class);
        if (manager == null) {
            manager = new DataManager();
            context.put(DATA_MANAGER_CONTEXT_KEY, (Object)manager);
        }
        return manager;
    }

    public boolean isRightOnTopicsEnabled(String instanceId) {
        return this.isTopicTrackerSupported(instanceId) && StringUtil.getBooleanValue((String)this.controller.getComponentParameterValue(instanceId, RIGHTS_ON_TOPICS_PARAM_NAME));
    }

    private boolean isTopicTrackerSupported(String componentId) {
        return this.controller.getComponentInstance(componentId).filter(SilverpeasComponentInstance::isTopicTracker).isPresent();
    }

    @Override
    public Stream<String> filterAuthorizedByUser(Collection<String> instanceIds, String userId, AccessControlContext context) {
        ComponentAccessController.getDataManager(context).loadCaches(userId, instanceIds);
        return instanceIds.stream().filter(p -> this.isUserAuthorized(userId, (String)p, context));
    }

    public boolean isUserAuthorized(String userId, String componentId, AccessControlContext context) {
        return this.isUserAuthorized(this.getUserRoles(userId, componentId, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fillUserRoles(Set<SilverpeasRole> userRoles, AccessControlContext context, String userId, String componentId) {
        DataManager dataManager;
        block21: {
            User user;
            block20: {
                block19: {
                    Predicate<String> isTool;
                    block18: {
                        block17: {
                            boolean userHasReadAccessAtLeast;
                            dataManager = ComponentAccessController.getDataManager(context);
                            try {
                                if (!dataManager.isRemoved(componentId)) break block17;
                                userHasReadAccessAtLeast = false;
                            }
                            catch (Throwable throwable) {
                                boolean userHasReadAccessAtLeast2 = false;
                                if (AccessControlOperation.isPersistActionFrom((Collection)context.getOperations())) {
                                    userHasReadAccessAtLeast2 = userRoles.remove(SilverpeasRole.USER);
                                }
                                dataManager.setUserHasReadAccessAtLeast(componentId, userHasReadAccessAtLeast2 |= !userRoles.isEmpty());
                                throw throwable;
                            }
                            if (AccessControlOperation.isPersistActionFrom((Collection)context.getOperations())) {
                                userHasReadAccessAtLeast = userRoles.remove(SilverpeasRole.USER);
                            }
                            dataManager.setUserHasReadAccessAtLeast(componentId, userHasReadAccessAtLeast |= !userRoles.isEmpty());
                            return;
                        }
                        Predicate<User> isUserNotValidState = u -> u == null || !u.isActivatedState() && !u.isAnonymous();
                        isTool = c -> c == null || dataManager.isToolAvailable((String)c);
                        user = User.getById((String)userId);
                        if (!isUserNotValidState.test(user)) break block18;
                        boolean userHasReadAccessAtLeast = false;
                        if (AccessControlOperation.isPersistActionFrom((Collection)context.getOperations())) {
                            userHasReadAccessAtLeast = userRoles.remove(SilverpeasRole.USER);
                        }
                        dataManager.setUserHasReadAccessAtLeast(componentId, userHasReadAccessAtLeast |= !userRoles.isEmpty());
                        return;
                    }
                    if (!isTool.test(componentId)) break block19;
                    userRoles.add(SilverpeasRole.ADMIN);
                    boolean userHasReadAccessAtLeast = false;
                    if (AccessControlOperation.isPersistActionFrom((Collection)context.getOperations())) {
                        userHasReadAccessAtLeast = userRoles.remove(SilverpeasRole.USER);
                    }
                    dataManager.setUserHasReadAccessAtLeast(componentId, userHasReadAccessAtLeast |= !userRoles.isEmpty());
                    return;
                }
                if (!"ADMIN".equals(componentId)) break block20;
                if (user.isAccessAdmin()) {
                    userRoles.add(SilverpeasRole.ADMIN);
                }
                boolean userHasReadAccessAtLeast = false;
                if (AccessControlOperation.isPersistActionFrom((Collection)context.getOperations())) {
                    userHasReadAccessAtLeast = userRoles.remove(SilverpeasRole.USER);
                }
                dataManager.setUserHasReadAccessAtLeast(componentId, userHasReadAccessAtLeast |= !userRoles.isEmpty());
                return;
            }
            if (!this.getComponentExtension(componentId).fillUserRolesFromComponentInstance(dataManager, user, componentId, context, userRoles)) break block21;
            boolean userHasReadAccessAtLeast = false;
            if (AccessControlOperation.isPersistActionFrom((Collection)context.getOperations())) {
                userHasReadAccessAtLeast = userRoles.remove(SilverpeasRole.USER);
            }
            dataManager.setUserHasReadAccessAtLeast(componentId, userHasReadAccessAtLeast |= !userRoles.isEmpty());
            return;
        }
        if (dataManager.isComponentAvailableToUser(componentId, userId)) {
            String[] userProfiles = dataManager.getUserProfiles(componentId, userId);
            userRoles.addAll(SilverpeasRole.fromStrings((String[])userProfiles));
            if (userRoles.isEmpty() && userProfiles != null && userProfiles.length > 0) {
                userRoles.add(SilverpeasRole.USER);
            }
        }
        boolean userHasReadAccessAtLeast = false;
        if (AccessControlOperation.isPersistActionFrom((Collection)context.getOperations())) {
            userHasReadAccessAtLeast = userRoles.remove(SilverpeasRole.USER);
        }
        dataManager.setUserHasReadAccessAtLeast(componentId, userHasReadAccessAtLeast |= !userRoles.isEmpty());
    }

    ComponentInstanceAccessControlExtension getComponentExtension(String instanceId) {
        return ComponentInstanceAccessControlExtension.getByInstanceId(instanceId);
    }

    public static class DataManager {
        private static final List<String> HANDLED_PARAM_NAMES = Arrays.asList("rightsOnTopics", "usePublicationSharing", "useFileSharing", "useFolderSharing", "coWriting", "publicFiles");
        private final OrganizationController controller;
        private final RemovedSpaceAndComponentInstanceChecker removedChecker;
        private final Map<String, Set<String>> manageableSpaceIdsCache = new HashMap<String, Set<String>>(1);
        private Map<String, Optional<SilverpeasComponentInstance>> componentInstancesCache = new HashMap<String, Optional<SilverpeasComponentInstance>>(1);
        private Map<String, Boolean> isPublicationSharingEnabledForRoleCache = new HashMap<String, Boolean>(1);
        private Map<String, Boolean> isFileSharingEnabledForRoleCache = new HashMap<String, Boolean>(1);
        private Map<String, Boolean> isFolderSharingEnabledForRoleCache = new HashMap<String, Boolean>(1);
        private Map<String, Boolean> isCoWritingEnabledCache = new HashMap<String, Boolean>(1);
        private Map<String, Boolean> isTopicTrackerSupportedCache = new HashMap<String, Boolean>(1);
        private Map<String, Boolean> hasUserReadAccessAtLeast = new HashMap<String, Boolean>(1);
        Map<String, Boolean> isRightOnTopicsEnabledCache = new HashMap<String, Boolean>(1);
        Set<String> availableComponentCache = null;
        Map<String, Set<String>> userProfiles = null;
        Map<String, Map<String, String>> componentParameterValueCache = null;

        DataManager() {
            this.controller = OrganizationController.get();
            this.removedChecker = RemovedSpaceAndComponentInstanceChecker.create().resetWithCacheSizeOf(1);
        }

        void loadCaches(String userId, Collection<String> instanceIds) {
            if (this.availableComponentCache != null || instanceIds.isEmpty()) {
                return;
            }
            int nbElements = instanceIds.size();
            this.componentInstancesCache = new HashMap<String, Optional<SilverpeasComponentInstance>>(nbElements);
            this.isRightOnTopicsEnabledCache = new HashMap<String, Boolean>(nbElements);
            this.isPublicationSharingEnabledForRoleCache = new HashMap<String, Boolean>(nbElements);
            this.isFileSharingEnabledForRoleCache = new HashMap<String, Boolean>(nbElements);
            this.isFolderSharingEnabledForRoleCache = new HashMap<String, Boolean>(nbElements);
            this.isCoWritingEnabledCache = new HashMap<String, Boolean>(nbElements);
            this.isTopicTrackerSupportedCache = new HashMap<String, Boolean>(nbElements);
            this.hasUserReadAccessAtLeast = new HashMap<String, Boolean>(nbElements);
            this.removedChecker.resetWithCacheSizeOf(nbElements);
            this.availableComponentCache = new HashSet<String>(this.controller.getAvailableComponentsByUser(userId));
            this.completeCaches(userId, instanceIds);
        }

        void completeCaches(String userId, Collection<String> instanceIds) {
            boolean firstLoad;
            boolean bl = firstLoad = this.userProfiles == null;
            if (firstLoad) {
                this.userProfiles = this.controller.getUserProfilesByComponentId(userId, instanceIds);
            } else {
                this.userProfiles.putAll(this.controller.getUserProfilesByComponentId(userId, instanceIds));
            }
            if (firstLoad) {
                this.componentParameterValueCache = this.controller.getParameterValuesByComponentIdThenByParamName(instanceIds, HANDLED_PARAM_NAMES);
            } else {
                this.componentParameterValueCache.putAll(this.controller.getParameterValuesByComponentIdThenByParamName(instanceIds, HANDLED_PARAM_NAMES));
            }
        }

        boolean isRightOnTopicsEnabled(String instanceId) {
            return this.isRightOnTopicsEnabledCache.computeIfAbsent(instanceId, s -> this.isTopicTrackerSupported(instanceId) && StringUtil.getBooleanValue((String)this.getComponentParameterValue(instanceId, ComponentAccessController.RIGHTS_ON_TOPICS_PARAM_NAME)));
        }

        boolean isPublicationSharingEnabledForRole(String componentId, SilverpeasRole greatestUserRole) {
            return this.isPublicationSharingEnabledForRoleCache.computeIfAbsent(componentId + "@" + greatestUserRole, s -> this.isSharingEnabledForRole(componentId, greatestUserRole, "usePublicationSharing"));
        }

        boolean isFileSharingEnabledForRole(String componentId, SilverpeasRole greatestUserRole) {
            return this.isFileSharingEnabledForRoleCache.computeIfAbsent(componentId + "@" + greatestUserRole, s -> this.isSharingEnabledForRole(componentId, greatestUserRole, "useFileSharing"));
        }

        boolean isFolderSharingEnabledForRole(String componentId, SilverpeasRole greatestUserRole) {
            return this.isFolderSharingEnabledForRoleCache.computeIfAbsent(componentId + "@" + greatestUserRole, s -> this.isSharingEnabledForRole(componentId, greatestUserRole, "useFolderSharing"));
        }

        boolean isCoWritingEnabled(String componentId) {
            return this.isCoWritingEnabledCache.computeIfAbsent(componentId, s -> this.isTopicTrackerSupported((String)s) && StringUtil.getBooleanValue((String)this.getComponentParameterValue((String)s, "coWriting")));
        }

        boolean isTopicTrackerSupported(String componentId) {
            return this.isTopicTrackerSupportedCache.computeIfAbsent(componentId, s -> this.getComponentInstance((String)s).filter(SilverpeasComponentInstance::isTopicTracker).isPresent());
        }

        boolean isPublicFilesEnabled(String componentId) {
            return StringUtil.getBooleanValue((String)this.getComponentParameterValue(componentId, "publicFiles"));
        }

        boolean isToolAvailable(String componentId) {
            return this.controller.isToolAvailable(componentId);
        }

        boolean isRemoved(String componentId) {
            return this.removedChecker.isRemovedComponentInstanceById(componentId);
        }

        Optional<SilverpeasComponentInstance> getComponentInstance(String componentId) {
            return this.componentInstancesCache.computeIfAbsent(componentId, s -> this.controller.getComponentInstance(componentId));
        }

        boolean isComponentAvailableToUser(String componentId, String userId) {
            if (this.availableComponentCache != null) {
                return this.availableComponentCache.contains(componentId);
            }
            return this.controller.isComponentAvailableToUser(componentId, userId);
        }

        public Set<String> getManageableSpaceIds(String userId) {
            return this.manageableSpaceIdsCache.computeIfAbsent(userId, s -> Stream.of(this.controller.getUserManageableSpaceIds((String)s)).collect(Collectors.toSet()));
        }

        String[] getUserProfiles(String componentId, String userId) {
            if (this.userProfiles != null) {
                return this.userProfiles.getOrDefault(componentId, Collections.emptySet()).toArray(new String[0]);
            }
            return this.controller.getUserProfiles(userId, componentId);
        }

        void setUserHasReadAccessAtLeast(String componentId, boolean hasAccess) {
            this.hasUserReadAccessAtLeast.put(componentId, hasAccess);
        }

        boolean hasUserHasReadAccessAtLeast(String componentId) {
            Boolean hasAccess = this.hasUserReadAccessAtLeast.get(componentId);
            Objects.requireNonNull(hasAccess, "setUserHasReadAccessAtLeast MUST have been called before using hasUserHasReadAccessAtLeast one");
            return hasAccess;
        }

        private boolean isSharingEnabledForRole(String componentId, SilverpeasRole greatestUserRole, String parameterName) {
            if (!this.isTopicTrackerSupported(componentId)) {
                return false;
            }
            String value = this.getComponentParameterValue(componentId, parameterName);
            if ("1".equals(value)) {
                return greatestUserRole.isGreaterThanOrEquals(SilverpeasRole.ADMIN);
            }
            if ("2".equals(value)) {
                return greatestUserRole.isGreaterThanOrEquals(SilverpeasRole.WRITER);
            }
            return "3".equals(value);
        }

        private String getComponentParameterValue(String componentId, String parameterName) {
            if (this.componentParameterValueCache != null) {
                return this.componentParameterValueCache.getOrDefault(componentId, Collections.emptyMap()).getOrDefault(parameterName, "");
            }
            return this.controller.getComponentParameterValue(componentId, parameterName);
        }
    }
}

