/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.verifier;

import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.verifier.AbstractAuthenticationVerifier;
import org.silverpeas.core.security.authentication.verifier.UserCanLoginVerifier;
import org.silverpeas.core.security.authentication.verifier.UserCanTryAgainToLoginVerifier;
import org.silverpeas.core.security.authentication.verifier.UserMustAcceptTermsOfServiceVerifier;
import org.silverpeas.core.security.authentication.verifier.UserMustChangePasswordVerifier;

public class AuthenticationUserVerifierFactory {
    private AuthenticationUserVerifierFactory() {
        throw new IllegalStateException("Factory class");
    }

    public static void removeFromRequestCache(User user) {
        AbstractAuthenticationVerifier.removeFromRequestCache(user);
    }

    public static UserCanLoginVerifier getUserCanLoginVerifier(User user) {
        return new UserCanLoginVerifier(user);
    }

    public static UserCanLoginVerifier getUserCanLoginVerifier(String userId) {
        return AuthenticationUserVerifierFactory.getUserCanLoginVerifier(AbstractAuthenticationVerifier.getUserById(userId));
    }

    public static UserCanLoginVerifier getUserCanLoginVerifier(AuthenticationCredential credential) {
        return AuthenticationUserVerifierFactory.getUserCanLoginVerifier(AbstractAuthenticationVerifier.getUserByCredential(credential));
    }

    public static UserCanTryAgainToLoginVerifier getUserCanTryAgainToLoginVerifier(AuthenticationCredential credential) {
        User user = AbstractAuthenticationVerifier.getUserByCredential(credential);
        if (user == null && credential != null) {
            UserDetail dummy = new UserDetail();
            dummy.setLogin(credential.getLogin());
            dummy.setDomainId(credential.getDomainId());
            user = dummy;
        }
        return AuthenticationUserVerifierFactory.getUserCanTryAgainToLoginVerifier(user);
    }

    public static synchronized UserCanTryAgainToLoginVerifier getUserCanTryAgainToLoginVerifier(User user) {
        return UserCanTryAgainToLoginVerifier.get(user);
    }

    public static UserMustChangePasswordVerifier getUserMustChangePasswordVerifier(User user) {
        return new UserMustChangePasswordVerifier(user);
    }

    public static UserMustChangePasswordVerifier getUserMustChangePasswordVerifier(AuthenticationCredential credential) {
        return AuthenticationUserVerifierFactory.getUserMustChangePasswordVerifier(AbstractAuthenticationVerifier.getUserByCredential(credential));
    }

    public static UserMustAcceptTermsOfServiceVerifier getUserMustAcceptTermsOfServiceVerifier(AuthenticationCredential credential) {
        return new UserMustAcceptTermsOfServiceVerifier(AbstractAuthenticationVerifier.getUserByCredential(credential));
    }

    public static synchronized UserMustAcceptTermsOfServiceVerifier getUserMustAcceptTermsOfServiceVerifier(String tosToken) {
        return UserMustAcceptTermsOfServiceVerifier.get(tosToken);
    }
}

