/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.password.rule;

import org.silverpeas.core.security.authentication.password.constant.PasswordRuleType;
import org.silverpeas.core.security.authentication.password.rule.AbstractPasswordRule;
import org.silverpeas.kernel.util.StringUtil;

public class AtLeastXSpecialCharPasswordRule
extends AbstractPasswordRule {
    private Integer nb;
    private String value;
    private String regexValue;
    private boolean required = settings.getBoolean(this.getType().getSettingKey(), false);
    private boolean combined = settings.getBoolean(this.getType().getSettingKey() + ".combined", false);

    public AtLeastXSpecialCharPasswordRule() {
        super(PasswordRuleType.AT_LEAST_X_SPECIAL_CHAR);
        this.nb = this.getIntegerFromSettings(this.getType().getSettingKey() + ".X", 0);
        this.value = settings.getString("password.rule.specialChars", "%*!?$-+#&=.,;");
        this.regexValue = "[" + this.value.replace("^", "\\^").replace("-", "\\-").replace("[]", "\\[").replace("]", "\\]") + "]";
        if (this.nb == 0) {
            this.required = false;
            this.combined = false;
        }
    }

    @Override
    public String getDescription(String language) {
        return this.getString(this.getType().getBundleKey(), language, this.nb.toString(), this.value);
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isCombined() {
        return this.combined;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean check(String password) {
        return StringUtil.isDefined((String)password) && this.countRegexOccur(password, this.regexValue) >= this.nb;
    }

    @Override
    public String random() {
        StringBuilder random = new StringBuilder();
        for (int i = 0; i < this.nb; ++i) {
            random.append(this.value.charAt(this.random(this.value.length())));
        }
        return random.toString();
    }
}

