/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.channel.silvermail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.notification.user.server.channel.silvermail.SilvermailCriteriaProcessor;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.util.StringUtil;

public class SilvermailCriteria {
    private List<Long> ids = new ArrayList<Long>();
    private Long userId;
    private Long folderId;
    private Integer readState;
    private PaginationPage pagination;
    private final List<QUERY_ORDER_BY> orderByList = new ArrayList<QUERY_ORDER_BY>();

    private SilvermailCriteria() {
    }

    public static SilvermailCriteria get() {
        return new SilvermailCriteria();
    }

    public SilvermailCriteria byId(Long ... ids) {
        this.ids.addAll(Arrays.stream(ids).collect(Collectors.toList()));
        return this;
    }

    public SilvermailCriteria aboutUser(String userId) {
        this.userId = Long.valueOf(userId);
        return this;
    }

    public SilvermailCriteria into(String folderName) {
        this.folderId = SilvermailCriteria.convertFolderNameToId(folderName);
        return this;
    }

    private static long convertFolderNameToId(String folderName) {
        long result = -1L;
        if ("INBOX".equals(folderName)) {
            result = 0L;
        } else if (StringUtil.isLong((String)folderName)) {
            result = Long.parseLong(folderName);
        }
        return result;
    }

    public SilvermailCriteria read() {
        this.readState = 1;
        return this;
    }

    public SilvermailCriteria unread() {
        this.readState = 0;
        return this;
    }

    public SilvermailCriteria paginatedBy(PaginationPage pagination) {
        this.pagination = pagination;
        return this;
    }

    public SilvermailCriteria orderedBy(QUERY_ORDER_BY ... orderBies) {
        CollectionUtil.addAllIgnoreNull(this.orderByList, (Object[])orderBies);
        return this;
    }

    Long getUserId() {
        return this.userId;
    }

    public void processWith(SilvermailCriteriaProcessor processor) {
        processor.startProcessing();
        if (!this.ids.isEmpty()) {
            processor.then().processByIds(this.ids);
        }
        if (this.userId != null) {
            processor.then().processUserId(this.userId);
        }
        if (this.folderId != null) {
            processor.then().processFolderId(this.folderId);
        }
        if (this.readState != null) {
            processor.then().processReadState(this.readState);
        }
        if (this.orderByList.isEmpty()) {
            this.orderByList.add(QUERY_ORDER_BY.RECEPTION_DATE_DESC);
        }
        processor.then().processOrdering(this.orderByList);
        if (this.pagination != null) {
            processor.then().processPagination(this.pagination);
        }
        processor.endProcessing();
    }

    public static enum QUERY_ORDER_BY {
        RECEPTION_DATE_ASC("id", true),
        RECEPTION_DATE_DESC("id", false),
        SOURCE_ASC("lower(source)", true),
        SOURCE_DESC("lower(source)", false),
        FROM_ASC("lower(senderName)", true),
        FROM_DESC("lower(senderName)", false),
        SUBJECT_ASC("lower(subject)", true),
        SUBJECT_DESC("lower(subject)", false);

        private final String propertyName;
        private final boolean asc;

        private QUERY_ORDER_BY(String propertyName, boolean asc) {
            this.propertyName = propertyName;
            this.asc = asc;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean isAsc() {
            return this.asc;
        }
    }
}

