/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.delayed;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.notification.user.client.constant.NotifChannel;
import org.silverpeas.core.notification.user.delayed.DelayedNotification;
import org.silverpeas.core.notification.user.delayed.constant.DelayedNotificationFrequency;
import org.silverpeas.core.notification.user.delayed.model.DelayedNotificationData;
import org.silverpeas.core.notification.user.delayed.model.DelayedNotificationUserSetting;
import org.silverpeas.core.notification.user.delayed.repository.DelayedNotificationDataRepository;
import org.silverpeas.core.notification.user.delayed.repository.DelayedNotificationUserSettingJpaRepository;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.notification.user.repository.NotificationResourceDataRepository;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.MapUtil;

@Service
@Transactional
public class DelayedNotificationManager
implements DelayedNotification {
    private static final Set<NotifChannel> WIRED_CHANNELS = new HashSet<NotifChannel>();
    @Inject
    private DelayedNotificationDataRepository dnRepository;
    @Inject
    private NotificationResourceDataRepository nrRepository;
    @Inject
    private DelayedNotificationUserSettingJpaRepository dnUserSettingManager;

    @Override
    public Map<NotifChannel, List<DelayedNotificationData>> findDelayedNotificationByUserIdGroupByChannel(int userId, Set<NotifChannel> aimedChannels) {
        LinkedHashMap<NotifChannel, List<DelayedNotificationData>> result = new LinkedHashMap<NotifChannel, List<DelayedNotificationData>>();
        for (DelayedNotificationData data : this.dnRepository.findByUserId(userId, NotifChannel.toIds(aimedChannels))) {
            MapUtil.putAddList(result, data.getChannel(), data);
        }
        return result;
    }

    @Override
    public List<Integer> findAllUsersToBeNotified(Set<NotifChannel> aimedChannels) {
        return this.dnRepository.findAllUsersToBeNotified(NotifChannel.toIds(aimedChannels));
    }

    @Override
    public List<Integer> findUsersToBeNotified(Date date, Set<NotifChannel> aimedChannels, DelayedNotificationFrequency defaultDelayedNotificationFrequency) {
        Date dateOfDay = DateUtil.getBeginOfDay((Date)date);
        HashSet<DelayedNotificationFrequency> aimedFrequencies = new HashSet<DelayedNotificationFrequency>();
        aimedFrequencies.add(DelayedNotificationFrequency.DAILY);
        if (2 == DateUtil.getDayNumberInWeek((Date)dateOfDay)) {
            aimedFrequencies.add(DelayedNotificationFrequency.WEEKLY);
        }
        if (DateUtil.getFirstDateOfMonth((Date)dateOfDay).compareTo(dateOfDay) == 0) {
            aimedFrequencies.add(DelayedNotificationFrequency.MONTHLY);
        }
        return this.dnRepository.findUsersToBeNotified(aimedChannels, aimedFrequencies, aimedFrequencies.contains(defaultDelayedNotificationFrequency));
    }

    @Override
    public void saveDelayedNotification(DelayedNotificationData delayedNotificationData) {
        if (delayedNotificationData.getResource().getId() == null) {
            NotificationResourceData existingResource = this.getExistingResource(delayedNotificationData.getResource().getResourceId(), delayedNotificationData.getResource().getResourceType(), delayedNotificationData.getResource().getComponentInstanceId());
            if (existingResource != null) {
                existingResource.fillFrom(delayedNotificationData.getResource());
                this.nrRepository.saveAndFlush((IdentifiableEntity)existingResource);
                delayedNotificationData.setResource(existingResource);
                if (delayedNotificationData.getId() == null) {
                    List<DelayedNotificationData> exists = this.dnRepository.findDelayedNotification(delayedNotificationData);
                    if (exists.size() == 1) {
                        delayedNotificationData.setId(Long.valueOf(exists.get(0).getId()));
                    } else {
                        this.dnRepository.saveAndFlush((IdentifiableEntity)delayedNotificationData);
                    }
                } else {
                    this.dnRepository.saveAndFlush((IdentifiableEntity)delayedNotificationData);
                }
            } else {
                this.nrRepository.save((IdentifiableEntity)delayedNotificationData.getResource());
                this.dnRepository.saveAndFlush((IdentifiableEntity)delayedNotificationData);
            }
        } else {
            this.dnRepository.saveAndFlush((IdentifiableEntity)delayedNotificationData);
        }
    }

    @Override
    public int deleteDelayedNotifications(Collection<Long> ids) {
        int nbDeletes = 0;
        if (CollectionUtil.isNotEmpty(ids)) {
            for (Collection idLot : CollectionUtil.split(ids)) {
                nbDeletes = (int)((long)nbDeletes + this.dnRepository.deleteByIds(idLot));
            }
            this.nrRepository.deleteResources();
            this.dnRepository.flush();
        }
        return nbDeletes;
    }

    @Override
    public NotificationResourceData getExistingResource(String resourceId, String resourceType, String componentInstanceId) {
        return this.nrRepository.getExistingResource(resourceId, resourceType, componentInstanceId);
    }

    @Override
    public DelayedNotificationUserSetting getDelayedNotificationUserSetting(int id) {
        return (DelayedNotificationUserSetting)this.dnUserSettingManager.getById(Integer.toString(id));
    }

    @Override
    public List<DelayedNotificationUserSetting> findDelayedNotificationUserSettingByUserId(int userId) {
        return this.dnUserSettingManager.findByUserId(userId);
    }

    @Override
    @Transactional(value=Transactional.TxType.SUPPORTS)
    public DelayedNotificationUserSetting getDelayedNotificationUserSettingByUserIdAndChannel(int userId, NotifChannel channel) {
        List<DelayedNotificationUserSetting> userSettings = this.dnUserSettingManager.findByUserIdAndChannel(userId, channel.getId());
        DelayedNotificationUserSetting result = null;
        if (!userSettings.isEmpty()) {
            result = userSettings.iterator().next();
        }
        return result;
    }

    @Override
    public DelayedNotificationUserSetting saveDelayedNotificationUserSetting(int userId, NotifChannel channel, DelayedNotificationFrequency frequency) {
        DelayedNotificationUserSetting userSettings = this.getDelayedNotificationUserSettingByUserIdAndChannel(userId, channel);
        if (userSettings == null) {
            userSettings = new DelayedNotificationUserSetting();
            userSettings.setUserId(Integer.valueOf(userId));
            userSettings.setChannel(channel);
        }
        userSettings.setFrequency(frequency);
        this.dnUserSettingManager.save((IdentifiableEntity)userSettings);
        return userSettings;
    }

    @Override
    public void deleteDelayedNotificationUserSetting(int id) {
        this.dnUserSettingManager.deleteById(Integer.toString(id));
        this.dnUserSettingManager.flush();
    }

    @Override
    public void deleteDelayedNotificationUserSetting(DelayedNotificationUserSetting delayedNotificationUserSetting) {
        this.dnUserSettingManager.delete((IdentifiableEntity[])new DelayedNotificationUserSetting[]{delayedNotificationUserSetting});
        this.dnUserSettingManager.flush();
    }

    @Override
    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    public Set<NotifChannel> getWiredChannels() {
        return WIRED_CHANNELS;
    }

    @Override
    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    public Set<DelayedNotificationFrequency> getPossibleFrequencies() {
        return NotificationManagerSettings.getDelayedNotificationFrequencyChoiceList();
    }

    @Override
    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    public DelayedNotificationFrequency getDefaultDelayedNotificationFrequency() {
        return NotificationManagerSettings.getDefaultDelayedNotificationFrequency();
    }

    @Override
    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    public DelayedNotificationFrequency getUserFrequency(Integer userId, NotifChannel channel) {
        DelayedNotificationFrequency result = DelayedNotificationFrequency.NONE;
        if (this.getWiredChannels().contains(channel)) {
            DelayedNotificationUserSetting dnus = userId != null ? this.getDelayedNotificationUserSettingByUserIdAndChannel(userId, channel) : null;
            result = dnus == null || !this.getPossibleFrequencies().contains(dnus.getFrequency()) ? this.getDefaultDelayedNotificationFrequency() : dnus.getFrequency();
        }
        return result;
    }

    static {
        WIRED_CHANNELS.add(NotifChannel.SMTP);
    }
}

