/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.node.model;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.silverpeas.core.clipboard.ClipboardSelection;
import org.silverpeas.core.clipboard.SilverpeasKeyData;
import org.silverpeas.core.index.indexing.model.IndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.util.URLUtil;

public class NodeSelection
extends ClipboardSelection
implements Serializable {
    private static final long serialVersionUID = -6462797069972573255L;
    public static final DataFlavor NodeDetailFlavor = new DataFlavor(NodeDetail.class, "Node");
    private final NodeDetail nodeDetail;

    public NodeSelection(NodeDetail node) {
        this.nodeDetail = node;
        super.addFlavor(NodeDetailFlavor);
    }

    @Override
    @Nonnull
    public synchronized Object getTransferData(DataFlavor parFlavor) throws UnsupportedFlavorException {
        Object transferedData;
        try {
            transferedData = super.getTransferData(parFlavor);
        }
        catch (UnsupportedFlavorException e) {
            if (parFlavor.equals(NodeDetailFlavor)) {
                transferedData = this.nodeDetail;
            }
            throw e;
        }
        return transferedData;
    }

    @Override
    public IndexEntry getIndexEntry() {
        NodePK pk = this.nodeDetail.getNodePK();
        IndexEntry indexEntry = new IndexEntry(new IndexEntryKey(pk.getInstanceId(), "Node", pk.getId()));
        indexEntry.setTitle(this.nodeDetail.getName());
        return indexEntry;
    }

    @Override
    public SilverpeasKeyData getKeyData() {
        SilverpeasKeyData keyData = new SilverpeasKeyData(this.nodeDetail.getId(), this.nodeDetail.getNodePK().getComponentInstanceId());
        keyData.setTitle(this.nodeDetail.getName());
        keyData.setAuthor(this.nodeDetail.getCreatorId());
        keyData.setCreationDate(this.nodeDetail.getCreationDate());
        keyData.setDesc(this.nodeDetail.getDescription());
        keyData.setType("Node");
        keyData.setLink(URLUtil.getSimpleURL(3, this.nodeDetail.getId(), this.nodeDetail.getNodePK().getInstanceId()));
        return keyData;
    }
}

