/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.upload;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.io.upload.UploadSessionFile;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class UploadSession {
    static final String X_UPLOAD_SESSION = "X-UPLOAD-SESSION";
    private static final String SESSION_CACHE_KEY = "@@@_" + UploadSession.class.getName();
    private static final String UPLOAD_SESSION_CACHE_KEY_PREFIX = "@@@_instance_for_";
    private final String uploadSessionId;
    private File uploadSessionFolder;
    private String componentInstanceId;
    private final Map<String, String> componentInstanceParameters = new HashMap<String, String>();
    private final Map<String, Boolean> currentFileWritings = new ConcurrentHashMap<String, Boolean>();

    private UploadSession(String uploadSessionId) {
        this.uploadSessionId = uploadSessionId;
    }

    public UploadSession forComponentInstanceId(String componentInstanceId) {
        this.componentInstanceId = componentInstanceId;
        return this;
    }

    public boolean isUserAuthorized(String componentInstanceId) {
        return StringUtil.isDefined((String)this.getComponentInstanceId()) && this.getComponentInstanceId().equals(componentInstanceId) && ComponentAccessControl.get().isUserAuthorized(UserDetail.getCurrentRequester().getId(), (Object)componentInstanceId);
    }

    public String getId() {
        return this.uploadSessionId;
    }

    public String getComponentInstanceId() {
        return this.componentInstanceId;
    }

    public String getComponentInstanceParameterValue(String parameterName) {
        String parameterValue = null;
        if (StringUtil.isDefined((String)this.getComponentInstanceId())) {
            if (!this.componentInstanceParameters.containsKey(parameterName)) {
                parameterValue = OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(this.getComponentInstanceId(), parameterName);
                this.componentInstanceParameters.put(parameterName, parameterValue);
            } else {
                parameterValue = this.componentInstanceParameters.get(parameterName);
            }
        }
        return parameterValue;
    }

    private boolean isHandledOnFileSystem() {
        return this.uploadSessionFolder != null;
    }

    public void clear() {
        if (this.isHandledOnFileSystem()) {
            FileUtils.deleteQuietly((File)this.uploadSessionFolder);
            UploadSession.removeSessionFromCache(this);
            this.uploadSessionFolder = null;
        }
    }

    public synchronized boolean remove(String fullPath) {
        boolean removed = false;
        if (this.isHandledOnFileSystem()) {
            UploadSessionFile uploadSessionFile = this.getUploadSessionFile(fullPath);
            if (!this.currentFileWritings.containsKey(fullPath)) {
                removed = FileUtils.deleteQuietly((File)uploadSessionFile.getServerFile());
            }
        }
        return removed;
    }

    public synchronized UploadSessionFile getUploadSessionFile(String fullPath) {
        this.initialize();
        return new UploadSessionFile(this, fullPath, new File(this.uploadSessionFolder, fullPath));
    }

    public File getRootFolder() {
        this.initialize();
        return this.uploadSessionFolder;
    }

    public File[] getRootFolderFiles() {
        File[] files = this.getRootFolder().listFiles();
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }

    private synchronized void initialize() {
        if (!this.isHandledOnFileSystem()) {
            boolean created;
            this.uploadSessionFolder = new File(FileRepositoryManager.getTemporaryPath(), this.uploadSessionId);
            if (!this.uploadSessionFolder.exists() && !(created = this.uploadSessionFolder.mkdirs())) {
                SilverLogger.getLogger((Object)this).warn("The root folder of the session " + this.uploadSessionId + " cannot be created!", new Object[0]);
            }
        }
    }

    void markFileWritingInProgress(UploadSessionFile uploadSessionFile) throws IOException {
        String fullPath = uploadSessionFile.getFullPath();
        if (this.currentFileWritings.containsKey(fullPath)) {
            throw new IOException("An other file with the same name is currently updated (" + fullPath + ")");
        }
        this.currentFileWritings.put(fullPath, true);
    }

    void markFileWritingDone(UploadSessionFile uploadSessionFile) {
        this.currentFileWritings.remove(uploadSessionFile.getFullPath());
    }

    public static UploadSession from(HttpServletRequest request) {
        String uploadSessionId = request.getHeader(X_UPLOAD_SESSION);
        if (StringUtil.isNotDefined((String)uploadSessionId)) {
            uploadSessionId = request.getParameter(X_UPLOAD_SESSION);
        }
        return UploadSession.from(uploadSessionId);
    }

    public static UploadSession from(String uploadSessionId) {
        UploadSession uploadSession = UploadSession.getSessionFromCache(uploadSessionId);
        if (uploadSession == null) {
            uploadSession = new UploadSession(UploadSession.handleUploadSessionId(uploadSessionId));
            UploadSession.registerSessionInCache(uploadSession);
        }
        return uploadSession;
    }

    private static String handleUploadSessionId(String uploadSessionId) {
        return StringUtil.isDefined((String)uploadSessionId) ? uploadSessionId : UUID.randomUUID().toString();
    }

    private static UploadSession getSessionFromCache(String uploadSessionId) {
        return (UploadSession)CacheAccessorProvider.getSessionCacheAccessor().getCache().get((Object)(UPLOAD_SESSION_CACHE_KEY_PREFIX + uploadSessionId), UploadSession.class);
    }

    private static void registerSessionInCache(UploadSession uploadSession) {
        HashSet<String> sessionIds = (HashSet<String>)CacheAccessorProvider.getSessionCacheAccessor().getCache().get((Object)SESSION_CACHE_KEY, Set.class);
        if (sessionIds == null) {
            sessionIds = new HashSet<String>();
            CacheAccessorProvider.getSessionCacheAccessor().getCache().put((Object)SESSION_CACHE_KEY, sessionIds);
        }
        sessionIds.add(uploadSession.uploadSessionId);
        CacheAccessorProvider.getSessionCacheAccessor().getCache().put((Object)(UPLOAD_SESSION_CACHE_KEY_PREFIX + uploadSession.getId()), (Object)uploadSession);
    }

    private static void removeSessionFromCache(UploadSession uploadSession) {
        Set sessionIds = (Set)CacheAccessorProvider.getSessionCacheAccessor().getCache().get((Object)SESSION_CACHE_KEY, Set.class);
        if (sessionIds != null) {
            sessionIds.remove(uploadSession.getId());
            CacheAccessorProvider.getSessionCacheAccessor().getCache().remove((Object)(UPLOAD_SESSION_CACHE_KEY_PREFIX + uploadSession.getId()));
        }
    }

    public static void clearFrom(SessionInfo sessionInfo) {
        Set sessionIds = (Set)sessionInfo.getCache().get((Object)SESSION_CACHE_KEY, Set.class);
        if (sessionIds != null) {
            for (String uploadSessionId : new ArrayList(sessionIds)) {
                try {
                    UploadSession.from(uploadSessionId).clear();
                }
                catch (NegativeArraySizeException e) {
                    SilverLogger.getLogger(UploadSession.class).error("On jSessionId={0}, with {1} uploadSessionIds (user {2})", new Object[]{sessionInfo.getSessionId(), String.valueOf(sessionIds.size()), sessionInfo.getUserDetail().getId()}, (Throwable)e);
                }
                catch (Exception e) {
                    SilverLogger.getLogger(UploadSession.class).silent((Throwable)e);
                }
            }
            sessionInfo.getCache().remove((Object)SESSION_CACHE_KEY);
        }
    }
}

