/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing.model;

import java.lang.annotation.Annotation;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.index.indexing.model.IndexerTask;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
@Singleton
public final class IndexEngineProxy {
    private IndexEngineProxy() {
    }

    public void add(FullIndexEntry entry) {
        IndexerTask.addIndexEntry(entry);
    }

    public void delete(IndexEntryKey entryKey) {
        IndexerTask.removeIndexEntry(entryKey);
    }

    public void deleteByScope(String scope) {
        IndexerTask.removeIndexEntriesByScope(scope);
    }

    public void deleteAll() {
        IndexerTask.removeAllIndexEntries();
    }

    public static IndexEngineProxy get() {
        return (IndexEngineProxy)ServiceProvider.getService(IndexEngineProxy.class, (Annotation[])new Annotation[0]);
    }

    public static void addIndexEntry(FullIndexEntry indexEntry) {
        IndexEngineProxy.get().add(indexEntry);
    }

    public static void removeIndexEntry(IndexEntryKey indexEntry) {
        IndexEngineProxy.get().delete(indexEntry);
    }

    public static void removeScopedIndexEntries(String scope) {
        IndexEngineProxy.get().deleteByScope(scope);
    }

    public static void removeAllIndexEntries() {
        IndexEngineProxy.get().deleteAll();
    }
}

